/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.execution;

import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.task.execution.TableExecutionDataSource;
import com.prelytis.dashboard.task.execution.TableExecutionDatabase;
import com.prelytis.dashboard.task.execution.TableExecutionResultImpl;
import com.prelytis.dashboard.task.execution.TableExecutionRoot;
import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TableExecutionAutoCommit
extends TableExecutionResultImpl
implements TableExecutionRoot {
    protected static final Logger log = LogManager.getLogger(TableExecutionDatabase.class);
    private TableExecutionDataSource tableExecution;
    private Connection connection;

    @Override
    public void start() throws DashboardException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"TableExecution > AutoCommit > start");
            }
            DataSource dataSource = this.tableExecution.getDataSource();
            this.connection = dataSource.getConnection();
            this.tableExecution.setListener(this);
            this.tableExecution.setConnection(this.connection);
            this.tableExecution.start();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void insert(String[] values) throws DashboardException {
        this.tableExecution.insert(values);
    }

    @Override
    public void end() throws DashboardException {
        try {
            this.tableExecution.end();
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)"TableExecution > AutoCommit > end");
            }
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        this.connection = null;
        this.tableExecution.setConnection(null);
    }

    public TableExecutionDataSource getTableExecution() {
        return this.tableExecution;
    }

    public void setTableExecution(TableExecutionDataSource tableExecution) {
        this.tableExecution = tableExecution;
    }

    protected void handleException(Exception e) throws DashboardException {
        if (e instanceof DashboardException) {
            throw (DashboardException)((Object)e);
        }
        throw new DashboardException((Throwable)e);
    }

    @Override
    public void error(DashboardException de) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"TableExecution > AutoCommit > error");
        }
        this.tableExecution.error(de);
        try {
            this.connection.close();
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        this.connection = null;
        this.tableExecution.setConnection(null);
    }
}

