/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.execution;

import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.task.execution.TableExecutionDataSource;
import com.prelytis.dashboard.task.execution.TableExecutionDatabase;
import com.prelytis.dashboard.task.execution.TableExecutionResultImpl;
import com.prelytis.dashboard.task.execution.TableExecutionRoot;
import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TableExecutionCommit
extends TableExecutionResultImpl
implements TableExecutionRoot {
    protected static final Logger log = LogManager.getLogger(TableExecutionDatabase.class);
    private TableExecutionDataSource tableExecution;
    private int nbCommitRows;
    private int nb;
    private Connection connection;

    @Override
    public void start() throws DashboardException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"TableExecution > Commit > start");
            }
            DataSource dataSource = this.tableExecution.getDataSource();
            this.connection = dataSource.getConnection();
            this.tableExecution.setListener(this);
            this.tableExecution.setConnection(this.connection);
            this.connection.setAutoCommit(false);
            this.nb = 0;
            this.tableExecution.start();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void insert(String[] values) throws DashboardException {
        if (this.nb >= this.nbCommitRows && this.nbCommitRows != -1) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"TableExecution > Commit > Commit");
                }
                this.connection.commit();
                this.nb = 0;
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        this.tableExecution.insert(values);
    }

    @Override
    public void end() throws DashboardException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"TableExecution > Commit > end > COMMIT");
        }
        try {
            this.tableExecution.end();
            this.connection.commit();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        this.connection = null;
        this.tableExecution.setConnection(null);
    }

    public TableExecutionDataSource getTableExecution() {
        return this.tableExecution;
    }

    public void setTableExecution(TableExecutionDataSource tableExecution) throws DashboardException {
        this.tableExecution = tableExecution;
    }

    public int getNbCommitRows() {
        return this.nbCommitRows;
    }

    public void setNbCommitRows(int nbRows) {
        this.nbCommitRows = nbRows;
    }

    protected void handleException(Exception e) throws DashboardException {
        if (e instanceof DashboardException) {
            throw (DashboardException)((Object)e);
        }
        throw new DashboardException((Throwable)e);
    }

    @Override
    public void error(DashboardException de) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"TableExecution > Commit > error");
        }
        try {
            this.tableExecution.error(de);
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        try {
            this.connection.rollback();
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        try {
            this.connection.close();
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        this.connection = null;
        this.tableExecution.setConnection(null);
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void lineInserted(String[] data) {
        super.lineInserted(data);
        ++this.nb;
    }

    @Override
    public void lineUpdated(String[] data) {
        super.lineUpdated(data);
        ++this.nb;
    }
}

