/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.execution;

import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.task.execution.TableExecutionDatabase;
import com.prelytis.dashboard.util.ConversionHelper;
import com.prelytis.dashboard.util.sql.SQLTable;
import com.prelytis.dashboard.util.sql.SQLTableHelper;
import com.prelytis.dashboard.value.util.FieldMetaData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class TableExecutionDelete
extends TableExecutionDatabase {
    protected int[] keyOrder;

    protected TableExecutionDelete(SQLTableHelper sqlTableHelper, SQLTable sqlTable, List<String> primaryKeys, ConversionHelper conversionHelper) throws DashboardException {
        super(sqlTableHelper, sqlTable, conversionHelper);
        try {
            int i;
            if (log.isDebugEnabled()) {
                log.debug((Object)"TableExecution > Delete > init");
            }
            String iqs = sqlTableHelper.getIdentifierQuoteString();
            StringBuffer strUpWhere = new StringBuffer();
            assert (primaryKeys != null && !primaryKeys.isEmpty());
            HashSet<String> pk = new HashSet<String>(primaryKeys);
            int nbFields = sqlTable.getFieldList().size();
            ArrayList<Integer> whereOrder = new ArrayList<Integer>();
            for (i = 0; i < nbFields; ++i) {
                String fieldName = ((FieldMetaData)sqlTable.getFieldList().get(i)).getName();
                if (!pk.remove(fieldName)) continue;
                if (strUpWhere.length() == 0) {
                    strUpWhere.append(" WHERE ");
                } else {
                    strUpWhere.append(" AND ");
                }
                strUpWhere.append(iqs).append(fieldName).append(iqs).append("=?");
                whereOrder.add(i);
            }
            if (!pk.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"TableExecution > Update > No primary key defined");
                }
                throw new DashboardException();
            }
            this.keyOrder = new int[whereOrder.size()];
            for (i = 0; i < whereOrder.size(); ++i) {
                int value;
                this.keyOrder[i] = value = ((Integer)whereOrder.get(i)).intValue();
            }
            this.request = new StringBuffer("DELETE FROM ").append(sqlTableHelper.getQualifiedTableName(sqlTable)).append(strUpWhere).toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)this.request);
            }
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    public String[] getKey(String[] values) {
        String[] resu = new String[this.keyOrder.length];
        for (int i = 0; i < this.keyOrder.length; ++i) {
            resu[i] = values[this.keyOrder[i]];
        }
        return resu;
    }

    protected String toString(String[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            if (i != 0) {
                str.append(", ");
            }
            str.append(data[i]);
        }
        return str.toString();
    }
}

