/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.execution;

import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.task.execution.TableExecutionDatabase;
import com.prelytis.dashboard.util.ConversionHelper;
import com.prelytis.dashboard.util.sql.SQLTable;
import com.prelytis.dashboard.util.sql.SQLTableHelper;
import com.prelytis.dashboard.value.util.FieldMetaData;
import java.util.ArrayList;

public abstract class TableExecutionInsert
extends TableExecutionDatabase {
    private final int[] insOrder;

    public TableExecutionInsert(SQLTableHelper sqlTableHelper, SQLTable sqlTable, ConversionHelper conversionHelper) throws DashboardException {
        super(sqlTableHelper, sqlTable, conversionHelper);
        try {
            int i;
            if (log.isDebugEnabled()) {
                log.debug((Object)"TableExecution > Insert > init");
            }
            String iqs = sqlTableHelper.getIdentifierQuoteString();
            StringBuffer strFld = new StringBuffer();
            StringBuffer str = new StringBuffer();
            boolean first = true;
            ArrayList<Integer> l = new ArrayList<Integer>();
            int nbFields = sqlTable.getFieldList().size();
            for (i = 0; i < nbFields; ++i) {
                FieldMetaData fmd = (FieldMetaData)sqlTable.getFieldList().get(i);
                if (fmd.isAutoIncrement()) continue;
                if (first) {
                    first = false;
                } else {
                    str.append(",");
                    strFld.append(",");
                }
                str.append("?");
                strFld.append(iqs).append(fmd.getName()).append(iqs);
                l.add(i);
            }
            this.insOrder = new int[l.size()];
            for (i = 0; i < l.size(); ++i) {
                this.insOrder[i] = (Integer)l.get(i);
            }
            this.request = new StringBuffer("INSERT INTO ").append(sqlTableHelper.getQualifiedTableName(sqlTable)).append(" (").append(strFld.toString()).append(") VALUES (").append(str.toString()).append(")").toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)this.request);
            }
        }
        catch (Exception e) {
            throw new DashboardException((Throwable)e);
        }
    }

    protected final void setFields(String[] values) throws DashboardException {
        int col = 1;
        for (int o : this.insOrder) {
            FieldMetaData fmd = this.getFieldMetaData(o);
            this.setField(col++, fmd, values[o]);
        }
    }
}

