/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.execution;

import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.task.execution.TableExecutionDatabase;
import com.prelytis.dashboard.util.ConversionHelper;
import com.prelytis.dashboard.util.sql.SQLTable;
import com.prelytis.dashboard.util.sql.SQLTableHelper;
import com.prelytis.dashboard.value.util.FieldMetaData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class TableExecutionUpdate
extends TableExecutionDatabase {
    private final int[] updateOrder;
    private final int[] keyOrder;

    protected TableExecutionUpdate(SQLTableHelper sqlTableHelper, SQLTable sqlTable, List<String> primaryKeys, ConversionHelper conversionHelper) throws DashboardException {
        super(sqlTableHelper, sqlTable, conversionHelper);
        try {
            int i;
            if (log.isDebugEnabled()) {
                log.debug((Object)"TableExecution > Update > init");
            }
            String iqs = sqlTableHelper.getIdentifierQuoteString();
            StringBuffer strUpdate = new StringBuffer();
            StringBuffer strUpWhere = new StringBuffer();
            assert (primaryKeys != null && !primaryKeys.isEmpty());
            int nbFields = sqlTable.getFieldList().size();
            HashSet<String> pk = new HashSet<String>(primaryKeys);
            ArrayList<Integer> updOrder = new ArrayList<Integer>();
            ArrayList<Integer> whereOrder = new ArrayList<Integer>();
            boolean needsComma = false;
            for (i = 0; i < nbFields; ++i) {
                FieldMetaData fmd = (FieldMetaData)sqlTable.getFieldList().get(i);
                String fieldName = fmd.getName();
                if (!pk.remove(fieldName)) {
                    if (fmd.isAutoIncrement()) continue;
                    updOrder.add(i);
                    if (needsComma) {
                        strUpdate.append(", ");
                    } else {
                        needsComma = true;
                    }
                    strUpdate.append(iqs).append(fieldName).append(iqs).append("=?");
                    continue;
                }
                if (strUpWhere.length() == 0) {
                    strUpWhere.append(" WHERE ");
                } else {
                    strUpWhere.append(" AND ");
                }
                strUpWhere.append(iqs).append(fieldName).append(iqs).append("=?");
                whereOrder.add(i);
            }
            if (!needsComma) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"TableExecution > Update > No data to update");
                }
                throw new DashboardException();
            }
            if (!pk.isEmpty()) {
                if (log.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder("TableExecution > Update > No given value for ");
                    boolean first = true;
                    for (String v : pk) {
                        if (first) {
                            first = false;
                        } else {
                            sb.append(", ");
                        }
                        sb.append("'").append(v).append("'");
                    }
                    log.debug((Object)sb.toString());
                }
                throw new DashboardException();
            }
            this.updateOrder = new int[updOrder.size()];
            for (i = 0; i < updOrder.size(); ++i) {
                this.updateOrder[i] = (Integer)updOrder.get(i);
            }
            this.keyOrder = new int[whereOrder.size()];
            for (i = 0; i < whereOrder.size(); ++i) {
                this.keyOrder[i] = (Integer)whereOrder.get(i);
            }
            this.request = new StringBuffer("UPDATE ").append(sqlTableHelper.getQualifiedTableName(sqlTable)).append(" SET ").append(strUpdate).append(strUpWhere).toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)this.request);
            }
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    protected final void setFields(String[] values) throws DashboardException {
        FieldMetaData fmd;
        int col = 1;
        for (int o : this.updateOrder) {
            fmd = this.getFieldMetaData(o);
            this.setField(col++, fmd, values[o]);
        }
        for (int o : this.keyOrder) {
            fmd = this.getFieldMetaData(o);
            this.setField(col++, fmd, values[o]);
        }
    }

    protected final Key getKey(String[] values) {
        String[] d = new String[this.keyOrder.length];
        int col = 0;
        for (int o : this.keyOrder) {
            d[col++] = values[o];
        }
        return new Key(d);
    }

    protected static class Key {
        private String[] data;

        private Key(String[] data) {
            this.data = data;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                String[] key = ((Key)obj).data;
                if (obj == null || this.data.length != key.length) {
                    return false;
                }
                for (int i = 0; i < this.data.length; ++i) {
                    if (!(this.data[i] == null ? key[i] != null : key[i] == null || !key[i].equals(this.data[i]))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            if (this.data == null || this.data.length == 0 || this.data[0] == null) {
                return 0;
            }
            return this.data[0].hashCode();
        }

        public String toString() {
            if (this.data == null || this.data.length == 0) {
                return "";
            }
            StringBuffer str = new StringBuffer();
            for (int i = 0; i < this.data.length; ++i) {
                if (i != 0) {
                    str.append(", ");
                }
                str.append(this.data[i]);
            }
            return str.toString();
        }
    }
}

