/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.web.system.exports;

import com.prelytis.dashboard.business.LifeCycleFacade;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardFacade;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.WorkspaceHelper;
import com.prelytis.dashboard.value.ExecutionContext;
import com.prelytis.dashboard.value.ExportParamRequest;
import com.prelytis.dashboard.value.ExportParamResponse;
import com.prelytis.dashboard.value.LoginRequest;
import com.prelytis.dashboard.value.LoginResponse;
import com.prelytis.dashboard.value.LogoutRequest;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.api.PrelytisPrincipal;
import com.prelytis.dashboard.value.data.BeanSession;
import com.prelytis.dashboard.value.data.ExportBean;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ExportTool {
    private static final Logger LOG = LogManager.getLogger(ExportTool.class);
    private static ExportTool instance;
    private String userSessionGuid;
    private ExecutionContext executionContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExportTool getInstance() {
        Class<ExportTool> clazz = ExportTool.class;
        synchronized (ExportTool.class) {
            if (instance == null) {
                instance = new ExportTool();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void login(String user, String password, String domain) throws DashboardException {
        LoginRequest request = new LoginRequest();
        request.setAction(LoginRequest.Action.LOGIN);
        request.setUserPrincipal((Principal)new PrelytisPrincipal(user));
        request.setForceConnection(Boolean.valueOf(true));
        request.setPassword(password == null ? null : password.toCharArray());
        request.setPassportDomain(domain);
        LoginResponse resp = (LoginResponse)DefaultFacade.getInstance().dashboardRequest((Request)request);
        this.userSessionGuid = resp.getUserSessionGuid();
        this.executionContext = resp.getDefaultExecutionContext();
    }

    private void logout() {
        if (this.executionContext != null) {
            LogoutRequest req = new LogoutRequest();
            req.setExecutionContext(this.executionContext.getName());
            req.setUserGuidToDeconnect(this.userSessionGuid);
            req.setUserSessionGuid(this.userSessionGuid);
            try {
                DefaultFacade.getInstance().dashboardRequest((Request)req);
            }
            catch (DashboardException ex) {
                LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
        this.executionContext = null;
        this.userSessionGuid = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean export(String user, String pwd, String domain, Map<SessionParameterType, ArrayList<String>> objects, File exportFile) {
        boolean success;
        block8: {
            success = true;
            try {
                this.checkExportFile(exportFile);
                this.checkUserRights(user, pwd, domain);
                ExportParamRequest requestGetExportBean = new ExportParamRequest();
                List<ExportBean> exportBeanList = this.buildExportList(objects);
                requestGetExportBean.setAction(ExportParamRequest.Action.XML_LIST_BEAN_WILDCARDS);
                requestGetExportBean.setUserSessionGuid(this.userSessionGuid);
                requestGetExportBean.setExportList(exportBeanList);
                ArrayList<SessionParameterType> sessionParameterList = new ArrayList<SessionParameterType>(objects.keySet());
                requestGetExportBean.setSessionList(sessionParameterList);
                ExportParamResponse response = (ExportParamResponse)DefaultFacade.getInstance().dashboardRequest((Request)requestGetExportBean);
                ExportParamRequest requestCreateZip = new ExportParamRequest();
                List sortedExportBeanList = response.getList();
                if (!sortedExportBeanList.isEmpty()) {
                    requestCreateZip.setExportList(sortedExportBeanList);
                    requestCreateZip.setAction(ExportParamRequest.Action.CREATE_ZIP);
                    requestCreateZip.setUserSessionGuid(this.userSessionGuid);
                    response = (ExportParamResponse)DefaultFacade.getInstance().dashboardRequest((Request)requestCreateZip);
                    this.writeZipFile(response, exportFile);
                    break block8;
                }
                throw new DashboardException("Objects to export not found");
            }
            catch (DashboardException e) {
                String errMsg = this.getErrorMsg(e);
                LOG.error((Object)("Export failed. " + errMsg));
                LOG.debug((Object)(errMsg + " Error code: " + e.getCode() + ". Error message: " + e.getMessage()), (Throwable)e);
                success = false;
            }
            catch (IOException e) {
                LOG.error((Object)("Export failed. " + e.getMessage()));
                LOG.debug((Object)("Export failed. " + e.getMessage()), (Throwable)e);
                success = false;
            }
            finally {
                this.logout();
            }
        }
        return success;
    }

    private void checkExportFile(File exportFile) throws DashboardException {
        File parent;
        File currentDir = new File(System.getProperty("user.dir"));
        if (exportFile.exists()) {
            throw new DashboardException("Export file already exists.");
        }
        if (exportFile.getParent() == null) {
            exportFile = new File(currentDir.getAbsolutePath() + File.separator + exportFile.getName());
        }
        if (!(parent = new File(exportFile.getParent())).exists()) {
            throw new DashboardException("Parent folder of the export file does not exists.");
        }
        if (!parent.canWrite()) {
            throw new DashboardException("No write permission to create the export file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SessionParameterType> getObjectTypes(String user, String pwd, String domain) throws DashboardException {
        ArrayList<SessionParameterType> exportableTypes = new ArrayList<SessionParameterType>();
        try {
            this.checkUserRights(user, pwd, domain);
            ExportParamRequest request = new ExportParamRequest();
            request.setUserSessionGuid(this.userSessionGuid);
            request.setAction(ExportParamRequest.Action.LIST_SESSION);
            ExportParamResponse response = (ExportParamResponse)DefaultFacade.getInstance().dashboardRequest((Request)request);
            for (Element element : response.getList()) {
                BeanSession bean = (BeanSession)element;
                String description = (String)bean.getDescriptionMap().get(Locale.ENGLISH);
                if (description == null) {
                    description = bean.getName();
                }
                Integer sessParamTypeId = bean.getObjectID();
                SessionParameterType sessParamType = SessionParameterType.valueOf((int)sessParamTypeId);
                exportableTypes.add(sessParamType);
            }
        }
        finally {
            this.logout();
        }
        return exportableTypes;
    }

    private List<ExportBean> buildExportList(Map<SessionParameterType, ArrayList<String>> objects) {
        ArrayList<ExportBean> exportBeanList = new ArrayList<ExportBean>();
        for (Map.Entry<SessionParameterType, ArrayList<String>> object : objects.entrySet()) {
            ArrayList<String> valueList = object.getValue();
            for (String beanName : valueList) {
                ExportBean exportBean = new ExportBean();
                exportBean.setName(beanName);
                exportBean.setSessionParameterType(object.getKey());
                exportBean.setActionAdd(true);
                exportBeanList.add(exportBean);
            }
        }
        return exportBeanList;
    }

    private void writeZipFile(ExportParamResponse response, File zipFile) throws IOException {
        zipFile.createNewFile();
        try {
            FileOutputStream out = new FileOutputStream(zipFile);
            out.write(response.getData());
            out.close();
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)e.getMessage());
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage());
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void checkUserRights(String user, String pwd, String domain) throws DashboardException {
        this.login(user, pwd, domain);
        WorkspaceHelper workspaceHelper = WorkspaceHelper.getInstance(DaoFactory.getInstance());
        int impAccessLevel = workspaceHelper.getAccessLevel(this.executionContext.getObjectID(), SessionParameterType.EXPORT_XML);
        if (impAccessLevel != 2) {
            throw new DashboardException("Not enough rights to run XML export command!");
        }
    }

    private String getErrorMsg(DashboardException exc) {
        String errMsg = null;
        if (ErrorCode.NOT_FOUND_ERROR.equals((Object)exc.getCode())) {
            errMsg = "Object missing.";
        } else {
            errMsg = exc.getMessage();
            if (exc.getMessage() == null) {
                errMsg = "Unknown error.";
            }
        }
        return errMsg;
    }

    private static final class DefaultFacade
    extends LifeCycleFacade {
        private static DashboardFacade instance;

        private DefaultFacade() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static DashboardFacade getInstance() {
            Class<DefaultFacade> clazz = DefaultFacade.class;
            synchronized (DefaultFacade.class) {
                if (instance == null) {
                    instance = new DefaultFacade();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }
    }
}

