/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.web.system.imports;

import com.prelytis.dashboard.dao.db.DefaultDaoFactory;
import com.prelytis.dashboard.web.system.imports.tools.ImportResults;
import com.prelytis.dashboard.web.system.imports.tools.ImportTool;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class StartupImportHelper {
    private static final Logger LOG = LogManager.getLogger(StartupImportHelper.class);
    public static final String SUPERADMIN = "superadmin";
    private static final String IMPORT_FILE_EXT = "zip";
    private static final String PREPACK_WORLD_ZIP = "prepackagedWorld.zip";

    private StartupImportHelper() {
    }

    public static ImportResults importFromFolder(File importFolder) {
        ImportResults importResults = null;
        if (StartupImportHelper.isValidFoder(importFolder)) {
            File[] files = StartupImportHelper.getFolderFiles(importFolder);
            if (files.length > 0) {
                List<File> fileListOrdered = StartupImportHelper.getOrderedFilesForImport(files);
                String user = SUPERADMIN;
                String password = StartupImportHelper.getUserPassword(SUPERADMIN);
                importResults = ImportTool.getInstance().importFiles(SUPERADMIN, password, fileListOrdered, true, true);
            }
        } else {
            LOG.warn((Object)"Import folder does not exist or is not a folder");
        }
        return importResults;
    }

    private static File[] getFolderFiles(File importFolder) {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname != null && pathname.getName().toLowerCase().endsWith(".zip");
            }
        };
        return importFolder.listFiles(filter);
    }

    private static boolean isValidFoder(File importFolder) {
        return importFolder.exists() && importFolder.isDirectory();
    }

    private static List<File> getOrderedFilesForImport(File[] fileList) {
        LinkedList<File> orderedList = new LinkedList<File>(Arrays.asList(fileList));
        for (int i = 0; i < orderedList.size(); ++i) {
            File element = (File)orderedList.get(i);
            if (!element.getAbsolutePath().endsWith(PREPACK_WORLD_ZIP)) continue;
            orderedList.remove(i);
            orderedList.addFirst(element);
            break;
        }
        return orderedList;
    }

    private static String getUserPassword(String user) {
        return DefaultDaoFactory.getInstance().getUserDao().getUserPassword(user);
    }
}

