/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.web.system.imports.tools;

import java.util.List;

public final class ImportResult {
    private String fileName;
    private final String[] itemsWithError;
    private final String[] itemsSkipped;
    private final String[] itemsImportedOk;
    private boolean reloadNeeded;

    public ImportResult(String fileName, List<String> itemsImportedOk, List<String> itemsSkipped, List<String> itemsWithError) {
        this.itemsImportedOk = itemsImportedOk == null ? new String[]{} : itemsImportedOk.toArray(new String[itemsImportedOk.size()]);
        this.itemsSkipped = itemsSkipped == null ? new String[]{} : itemsSkipped.toArray(new String[itemsSkipped.size()]);
        this.itemsWithError = itemsWithError == null ? new String[]{} : itemsWithError.toArray(new String[itemsWithError.size()]);
        this.fileName = fileName;
    }

    public String[] getItemsImportedOk() {
        String[] importedOk = new String[this.itemsImportedOk.length];
        System.arraycopy(this.itemsImportedOk, 0, importedOk, 0, this.itemsImportedOk.length);
        return importedOk;
    }

    public String[] getItemsSkipped() {
        String[] skippedItems = new String[this.itemsSkipped.length];
        System.arraycopy(this.itemsSkipped, 0, skippedItems, 0, this.itemsSkipped.length);
        return skippedItems;
    }

    public String[] getItemsWithError() {
        String[] withErrorItems = new String[this.itemsWithError.length];
        System.arraycopy(this.itemsWithError, 0, withErrorItems, 0, this.itemsWithError.length);
        return withErrorItems;
    }

    public boolean isOk() {
        return this.getItemsImportedOk().length > 0 && this.getItemsSkipped().length == 0 && this.getItemsWithError().length == 0;
    }

    public void setReloadNeeded(boolean shouldReload) {
        this.reloadNeeded = shouldReload;
    }

    public boolean isReloadNeeded() {
        return this.reloadNeeded;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String toString() {
        StringBuilder message = new StringBuilder(21);
        message.append("File '").append(this.fileName).append("' was imported ");
        message.append(this.hasItemsInError() ? "with errors" : "successfully");
        message.append(this.hasItemsSkipped() || this.hasItemsInError() ? ":" : ".");
        if (this.hasItemsInError()) {
            message.append(' ').append(this.itemsWithError.length).append(" item").append(this.itemsWithError.length > 1 ? Character.valueOf('s') : "").append(" could not be imported (");
            message.append(this.formatListMessage(this.itemsWithError));
        }
        if (this.hasItemsSkipped()) {
            message.append(' ').append(this.itemsSkipped.length).append(" item").append(this.itemsSkipped.length > 1 ? "s were" : " was").append(" skipped (");
            message.append(this.formatListMessage(this.itemsSkipped));
        }
        return message.toString();
    }

    public boolean hasItemsImportedOk() {
        return this.itemsImportedOk.length > 0;
    }

    public boolean hasItemsInError() {
        return this.itemsWithError.length > 0;
    }

    public boolean hasItemsSkipped() {
        return this.itemsSkipped.length > 0;
    }

    private String formatListMessage(String[] items) {
        StringBuilder message = new StringBuilder();
        boolean addComma = false;
        for (String item : items) {
            if (addComma) {
                message.append(", ");
            } else {
                addComma = true;
            }
            message.append(item);
        }
        message.append(").");
        return message.toString();
    }
}

