/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.web.system.imports.tools;

import com.prelytis.dashboard.business.LifeCycleFacade;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.helper.DataFileHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardFacade;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.WorkspaceHelper;
import com.prelytis.dashboard.util.HashingUtil;
import com.prelytis.dashboard.value.ExecutionContext;
import com.prelytis.dashboard.value.ImportParamRequest;
import com.prelytis.dashboard.value.ImportParamResponse;
import com.prelytis.dashboard.value.LoginRequest;
import com.prelytis.dashboard.value.LoginResponse;
import com.prelytis.dashboard.value.LogoutRequest;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.api.PrelytisPrincipal;
import com.prelytis.dashboard.value.data.ImportBean;
import com.prelytis.dashboard.value.data.ImportXmlResult;
import com.prelytis.dashboard.value.util.ExecutionMessage;
import com.prelytis.dashboard.web.system.imports.tools.ImportResult;
import com.prelytis.dashboard.web.system.imports.tools.ImportResults;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ImportTool {
    private static final Logger LOG = LogManager.getLogger(ImportTool.class);
    private static ImportTool instance;
    private String userSessionGuid;
    private ExecutionContext executionContext;
    private Boolean skipSentinelServerLogin;
    private String auditUserName;
    private String auditSessionId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImportTool getInstance() {
        Class<ImportTool> clazz = ImportTool.class;
        synchronized (ImportTool.class) {
            if (instance == null) {
                instance = new ImportTool();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void login(String user, String password, String domain) throws DashboardException {
        LoginRequest request = new LoginRequest();
        this.auditSessionId = HashingUtil.generateHashFromString((String)(request.getIpAddress() + System.currentTimeMillis()));
        request.setUserSessionAuditId(this.auditSessionId);
        request.setAction(LoginRequest.Action.LOGIN);
        request.setUserPrincipal((Principal)new PrelytisPrincipal(user));
        request.setForceConnection(Boolean.valueOf(true));
        request.setPassword(password == null ? null : password.toCharArray());
        request.setPassportDomain(domain);
        request.setSkipSentinelServerLogin(this.skipSentinelServerLogin.booleanValue());
        LoginResponse resp = (LoginResponse)DefaultFacade.getInstance().dashboardRequest((Request)request);
        this.auditUserName = resp.getUserLoginAudit();
        this.userSessionGuid = resp.getUserSessionGuid();
        this.executionContext = resp.getDefaultExecutionContext();
    }

    private void logout() {
        LogoutRequest req = new LogoutRequest();
        req.setExecutionContext(this.executionContext.getName());
        req.setUserGuidToDeconnect(this.userSessionGuid);
        req.setUserSessionGuid(this.userSessionGuid);
        req.setSkipLogoutAudit(true);
        try {
            DefaultFacade.getInstance().dashboardRequest((Request)req);
        }
        catch (DashboardException ex) {
            LOG.error((Object)ex.getLocalizedMessage());
            LOG.debug((Object)ex.getLocalizedMessage(), (Throwable)ex);
        }
        this.executionContext = null;
        this.userSessionGuid = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportResult importFile(String user, String pwd, String domain, File file, boolean force, boolean skipServerLogin) {
        ImportResult result;
        block7: {
            result = null;
            try {
                this.skipSentinelServerLogin = skipServerLogin;
                this.checkUserRights(user, pwd, domain);
                if (!DataFileHelper.isZipFile(file)) break block7;
                try {
                    result = this.doImport(file, force);
                }
                catch (Throwable t) {
                    LOG.error((Object)t.getLocalizedMessage());
                    LOG.debug((Object)t.getLocalizedMessage(), t);
                }
                finally {
                    this.logout();
                }
            }
            catch (DashboardException e) {
                LOG.error((Object)e.getMessage());
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportResults importFiles(String user, String pwd, List<File> files, boolean force, boolean skipServerLogin) {
        ImportResults results = null;
        try {
            this.skipSentinelServerLogin = skipServerLogin;
            this.checkUserRights(user, pwd, null);
            results = new ImportResults();
            ArrayList<Throwable> exceptionsList = new ArrayList<Throwable>();
            for (File file : files) {
                if (!DataFileHelper.isZipFile(file)) continue;
                try {
                    ImportResult result = this.doImport(file, force);
                    results.addImportResult(result);
                }
                catch (Throwable t) {
                    LOG.error((Object)t.getMessage(), t);
                    exceptionsList.add(t);
                }
            }
            if (!exceptionsList.isEmpty()) {
                this.logImportExceptions(exceptionsList);
            }
        }
        catch (DashboardException e) {
            LOG.error((Object)e.getMessage());
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.logout();
        }
        return results;
    }

    private ImportResult doImport(File archiveFile, boolean forceImport) throws IOException, DashboardException {
        ImportParamRequest request = new ImportParamRequest();
        request.setUserSessionGuid(this.userSessionGuid);
        request.setExecutionContext(this.executionContext.getName());
        request.setAction(ImportParamRequest.Action.ANALYZE);
        request.setData(DataFileHelper.getData(archiveFile));
        request.setUserLoginName(this.auditUserName);
        request.setAuditSessionId(this.auditSessionId);
        ImportParamResponse response = (ImportParamResponse)DefaultFacade.getInstance().dashboardRequest((Request)request);
        List importBeans = response.getImportList();
        if (forceImport) {
            this.markBeansForForceImport(importBeans);
        }
        request.setBeanList(importBeans);
        request.setAction(ImportParamRequest.Action.EXECUTION);
        response = (ImportParamResponse)DefaultFacade.getInstance().dashboardRequest((Request)request);
        ImportResult importResult = this.buildImportResult(request, response, archiveFile);
        return importResult;
    }

    private void markBeansForForceImport(List<ImportBean> importBeans) {
        for (ImportBean importBean : importBeans) {
            importBean.setAction(ImportBean.Action.ADD);
        }
    }

    private void checkUserRights(String user, String pwd, String domain) throws DashboardException {
        this.login(user, pwd, domain);
        WorkspaceHelper workspaceHelper = WorkspaceHelper.getInstance(DaoFactory.getInstance());
        int impAccessLevel = workspaceHelper.getAccessLevel(this.executionContext.getObjectID(), SessionParameterType.IMPORT_XML);
        if (impAccessLevel != 2) {
            throw new DashboardException("Not enough rights to run XML import command!");
        }
    }

    private ImportResult buildImportResult(ImportParamRequest request, ImportParamResponse response, File importFile) {
        this.logExecutionMessages(response);
        ArrayList<String> itemsSkipped = new ArrayList<String>();
        for (ImportBean bean : request.getBeanList()) {
            itemsSkipped.add(bean.getName());
        }
        List results = response.getResultList();
        ArrayList<String> itemsImportedOk = new ArrayList<String>();
        ArrayList<String> itemsWithError = new ArrayList<String>();
        if (results != null) {
            for (ImportXmlResult result : results) {
                itemsSkipped.remove(result.getBeanName());
                if (result.isImportError()) {
                    itemsWithError.add(result.getBeanName());
                    continue;
                }
                itemsImportedOk.add(result.getBeanName());
            }
        }
        ImportResult importResult = new ImportResult(importFile.getName(), itemsImportedOk, itemsSkipped, itemsWithError);
        importResult.setReloadNeeded(response.isShouldReload());
        if (importResult.hasItemsInError()) {
            LOG.error((Object)importResult);
        } else {
            LOG.info((Object)importResult);
        }
        return importResult;
    }

    private void logImportExceptions(List<Throwable> throwList) {
        for (Throwable item : throwList) {
            String message = item.getLocalizedMessage();
            if (message == null) continue;
            LOG.error((Object)message);
        }
    }

    private void logExecutionMessages(ImportParamResponse response) {
        List messages = response.getMessageList();
        if (messages != null) {
            for (ExecutionMessage message : messages) {
                if (message.getSeverity() == 3) {
                    LOG.error((Object)message.toString());
                    continue;
                }
                LOG.debug((Object)message.toString());
            }
        }
    }

    private static class DefaultFacade
    extends LifeCycleFacade {
        private static DashboardFacade instance;

        private DefaultFacade() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static DashboardFacade getInstance() {
            Class<DefaultFacade> clazz = DefaultFacade.class;
            synchronized (DefaultFacade.class) {
                if (instance == null) {
                    instance = new DefaultFacade();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }
    }
}

