/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.business;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.ext.AbstractFacade;
import com.prelytis.dashboard.helper.ConnectionInformationHelper;
import com.prelytis.dashboard.helper.DocumentHelper;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.helper.ExpressionEvaluationDataHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardFacade;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.model.ExecutionContextHelper;
import com.prelytis.dashboard.model.helper.ControlHelper;
import com.prelytis.dashboard.model.helper.DashBoardHelper;
import com.prelytis.dashboard.model.helper.EntityHelper;
import com.prelytis.dashboard.model.helper.ExtSessionHelper;
import com.prelytis.dashboard.model.helper.FormHelper;
import com.prelytis.dashboard.model.helper.MetricHelper;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.PrelytisInfoHelper;
import com.prelytis.dashboard.model.helper.ReportHelper;
import com.prelytis.dashboard.util.sql.ConnectionInformation;
import com.prelytis.dashboard.value.DocumentRequest;
import com.prelytis.dashboard.value.FolderValueRequest;
import com.prelytis.dashboard.value.LoginRequest;
import com.prelytis.dashboard.value.LogoutRequest;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.data.BeanDashBoard;
import com.prelytis.dashboard.value.data.BeanTask;
import com.prelytis.dashboard.value.data.SecurityAdapter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.Locale;
import java.util.Map;

public final class AccessControlFacade
extends AbstractFacade {
    public AccessControlFacade(DashboardFacade facade) {
        super(facade);
    }

    @Override
    public void init(Map<String, String> properties) {
    }

    public Response dashboardRequest(Request value) throws DashboardException {
        switch (value.getType()) {
            case 10: 
            case 13: 
            case 17: 
            case 25: 
            case 42: {
                return this.getFacade().dashboardRequest(value);
            }
        }
        return this.handleRequest(value);
    }

    private Response handleRequest(Request value) throws DashboardException {
        DaoFactory daoFactory = DaoFactory.getInstance();
        ConnectionInformationHelper helper = ConnectionInformationHelper.getInstance(daoFactory);
        switch (value.getType()) {
            case 4: {
                this.checkLogout(daoFactory, value.getUserSessionGuid(), ((LogoutRequest)value).getUserGuidToDeconnect());
                this.addSourceHostToRequest(value, helper);
                break;
            }
            case 13: 
            case 25: {
                break;
            }
            case 3: {
                LoginRequest lr = (LoginRequest)value;
                if (value.getUserSessionGuid() != null && !helper.exists(value.getUserSessionGuid()) && lr.getAction() == LoginRequest.Action.LOGIN) {
                    value.setUserSessionGuid(null);
                    value.setExecutionContext(null);
                }
                if (lr.getConnectionType() != null) break;
                lr.setConnectionType(Integer.valueOf(1));
                break;
            }
            default: {
                if (value.getUserSessionGuid() == null || helper.exists(value.getUserSessionGuid())) break;
                throw this.getExceptionHelper(daoFactory).createInvalidSessionGUIDException();
            }
        }
        int neededAccess = 2;
        switch (value.getType()) {
            case 2: {
                neededAccess = this.getParameterNeededAccess(daoFactory, (ParameterRequest)value);
                break;
            }
            case 7: {
                neededAccess = this.getDocumentNeededAccess(daoFactory, (DocumentRequest)value);
                break;
            }
            case 40: {
                neededAccess = this.getFolderNeededAccess(daoFactory, (FolderValueRequest)value);
            }
        }
        Response response = this.getFacade().dashboardRequest(value);
        switch (value.getType()) {
            case 2: {
                ParameterResponse parameterResponse = (ParameterResponse)response;
                SecurityAdapter securityAdapter = parameterResponse.getElement();
                if (neededAccess == 0 || securityAdapter == null || securityAdapter.isRead()) break;
                throw new SecurityException();
            }
        }
        return response;
    }

    private void addSourceHostToRequest(Request value, ConnectionInformationHelper helper) {
        ConnectionInformation ci;
        String userSessionGuid = value.getUserSessionGuid();
        if (userSessionGuid != null && (ci = helper.getConnectedUser(userSessionGuid)) != null) {
            ((LogoutRequest)value).setUserHost(ci.getIpAddress());
        }
    }

    private void checkLogout(DaoFactory daoFactory, String userSessionGuid, String userSessionGuidToDeconnect) throws DashboardException {
        if (userSessionGuidToDeconnect == null) {
            return;
        }
        if (userSessionGuid == null) {
            throw this.getExceptionHelper(daoFactory).createInvalidSessionGUIDException();
        }
        ConnectionInformationHelper helper = ConnectionInformationHelper.getInstance(daoFactory);
        ConnectionInformation ci = helper.getConnectedUser(userSessionGuid);
        if (ci == null) {
            throw this.getExceptionHelper(daoFactory).createInvalidSessionGUIDException();
        }
        ConnectionInformation di = helper.getConnectedUser(userSessionGuidToDeconnect);
        if (di == null) {
            throw this.getExceptionHelper(daoFactory).createInvalidSessionGUIDException();
        }
        if (ci.getProfile() == 0) {
            throw new SecurityException();
        }
        ExecutionContextHelper ech = ExecutionContextHelper.getInstance(daoFactory);
        if (ech.isAllowed(ci.getExecutionContextName(), di.getExecutionContextName())) {
            return;
        }
        throw new SecurityException();
    }

    private int getParameterNeededAccess(DaoFactory daoFactory, ParameterRequest parameterRequest) throws DashboardException {
        int neededAccess = 2;
        SessionParameterType sessionParameterType = parameterRequest.getSessionParameterType();
        if (sessionParameterType == null) {
            throw this.getExceptionHelper(daoFactory).createMissingParameter("sessionOid");
        }
        ParameterRequest.Action action = parameterRequest.getAction();
        if (action == null) {
            action = ParameterRequest.Action.OPEN;
        }
        WorkspaceDao workspaceDao = daoFactory.getWorkspaceDao();
        ExpressionEvaluationData data = ExpressionEvaluationDataHelper.getInstance(daoFactory).getExpressionEvaluationData(parameterRequest.getUserSessionGuid(), parameterRequest.getExecutionContext());
        int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), sessionParameterType).getAccessLevel();
        switch (action) {
            case CUSTOMIZE: 
            case OPEN_CUSTOMIZE: 
            case OPEN_AS_SUPER_USER: 
            case DELETE_CUSTOMIZE: 
            case SAVE_CUSTOMIZE: {
                neededAccess = 0;
                break;
            }
            case OPEN: {
                neededAccess = sessionParameterType.equals((Object)SessionParameterType.THRESHOLD_TYPE) ? 0 : 1;
            }
        }
        if (neededAccess > accessLevel) {
            throw new SecurityException();
        }
        return neededAccess;
    }

    private int getDocumentNeededAccess(DaoFactory daoFactory, DocumentRequest documentRequest) throws DashboardException {
        EntityHelper entityHelper;
        SessionType docType = documentRequest.getDocumentType();
        if (docType == null) {
            throw this.getExceptionHelper(daoFactory).createMissingParameter("documentType");
        }
        Integer accessLevel = null;
        String name = documentRequest.getName();
        Integer ownerEntityOid = null;
        boolean preview = false;
        ExpressionEvaluationData data = ExpressionEvaluationDataHelper.getInstance(daoFactory).getExpressionEvaluationData(documentRequest.getUserSessionGuid(), documentRequest.getExecutionContext());
        switch (docType) {
            case DOCUMENT: {
                preview = documentRequest.isPreview();
                if (preview) {
                    ownerEntityOid = data.getEntityOid();
                    break;
                }
                if (name == null || name.isEmpty()) {
                    if (documentRequest.getDocument() != null) {
                        name = documentRequest.getDocument().getName();
                    }
                    if (documentRequest.getReport() != null) {
                        name = documentRequest.getReport().getName();
                    }
                }
                if (name == null || name.isEmpty()) {
                    throw this.getExceptionHelper(daoFactory).createMissingParameter("name");
                }
                ReportHelper reportHelper = ReportHelper.getInstance(daoFactory);
                BeanDashBoard elt = reportHelper.getCore(name);
                ownerEntityOid = elt.getOwnerEntOID();
                break;
            }
            case CONTROL: {
                if (name == null && documentRequest.getDocument() != null) {
                    name = documentRequest.getDocument().getName();
                }
                if (name == null) {
                    throw this.getExceptionHelper(daoFactory).createMissingParameter("name");
                }
                ParameterHelper taskHelper = ControlHelper.getInstance(daoFactory);
                BeanTask task = ((ControlHelper)taskHelper).getCore(name);
                ownerEntityOid = task.getOwnerEntOID();
                break;
            }
            case DASHBOARD: {
                if (name == null && documentRequest.getDocument() != null) {
                    name = documentRequest.getDocument().getName();
                }
                if (name == null) {
                    throw this.getExceptionHelper(daoFactory).createMissingParameter("name");
                }
                DashBoardHelper dashboardHelper = DashBoardHelper.getInstance(daoFactory);
                BeanDashBoard elt = dashboardHelper.getCore(name);
                ownerEntityOid = elt.getOwnerEntOID();
                break;
            }
            case FORM: {
                if (name == null && documentRequest.getDocument() != null) {
                    name = documentRequest.getDocument().getName();
                }
                if (name == null) {
                    throw this.getExceptionHelper(daoFactory).createMissingParameter("name");
                }
                FormHelper formHelper = FormHelper.getInstance(daoFactory);
                BeanDashBoard elt = formHelper.getCore(name);
                ownerEntityOid = elt.getOwnerEntOID();
                break;
            }
            case EXTERN: {
                if (name == null && documentRequest.getDocument() != null) {
                    name = documentRequest.getDocument().getName();
                }
                if (name == null) {
                    throw this.getExceptionHelper(daoFactory).createMissingParameter("name");
                }
                ExtSessionHelper extSessionHelper = ExtSessionHelper.getInstance(daoFactory);
                BeanDashBoard elt = extSessionHelper.getCore(name);
                name = elt.getName();
                break;
            }
            case METRIC: 
            case METRIC_HISTORY: {
                if (name == null && documentRequest.getDocument() != null) {
                    name = documentRequest.getDocument().getName();
                }
                if (name == null) {
                    throw this.getExceptionHelper(daoFactory).createMissingParameter("name");
                }
                ParameterHelper taskHelper = MetricHelper.getInstance(daoFactory);
                BeanTask task = ((MetricHelper)taskHelper).getCore(name);
                ownerEntityOid = task.getOwnerEntOID();
                break;
            }
            case CONTROL_PANEL: 
            case METRIC_PANEL: 
            case STRATEGY_MAP: {
                break;
            }
        }
        if (ownerEntityOid != null && !(entityHelper = EntityHelper.getInstance(daoFactory)).hasRights(data.getEntityOid(), ownerEntityOid)) {
            throw new SecurityException();
        }
        DocumentHelper helper = DocumentHelper.getInstance(daoFactory);
        accessLevel = helper.getDocumentAccessLevelForEC(data.getExecutionContextOid(), docType, name, preview);
        int neededAccess = 1;
        if (accessLevel != null && neededAccess > accessLevel) {
            throw new SecurityException();
        }
        return neededAccess;
    }

    private int getFolderNeededAccess(DaoFactory daoFactory, FolderValueRequest folderRequest) throws DashboardException {
        int neededAccess;
        ExpressionEvaluationData data = ExpressionEvaluationDataHelper.getInstance(daoFactory).getExpressionEvaluationData(folderRequest.getUserSessionGuid(), folderRequest.getExecutionContext());
        String folderName = folderRequest.getFolderName();
        if (folderName == null) {
            throw ExceptionHelper.getInstance(data.getLocale()).createMissingParameter("folderName");
        }
        WorkspaceDao workspaceDao = daoFactory.getWorkspaceDao();
        int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionType.FILE, folderName).getAccessLevel();
        FolderValueRequest.Action action = folderRequest.getAction();
        if (action == null) {
            action = FolderValueRequest.Action.FILL_CONTENT;
        }
        switch (action) {
            default: {
                neededAccess = 2;
                break;
            }
            case DOWNLOAD: 
            case FILL_CONTENT: {
                neededAccess = 1;
            }
        }
        if (neededAccess > accessLevel) {
            throw new SecurityException();
        }
        return neededAccess;
    }

    private ExceptionHelper getExceptionHelper(DaoFactory daoFactory) {
        PrelytisInfoHelper prelytisInfoHelper = PrelytisInfoHelper.getInstance(daoFactory);
        Locale locale = prelytisInfoHelper.getDefaultLocale();
        return ExceptionHelper.getInstance(locale);
    }
}

