/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.business;

import com.prelytis.dashboard.business.AccessControlFacade;
import com.prelytis.dashboard.business.BusinessFacade;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.PrelytisInfoDao;
import com.prelytis.dashboard.db.RequestContextImpl;
import com.prelytis.dashboard.ext.AbstractFacade;
import com.prelytis.dashboard.interfaces.ApplicationException;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardFacade;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.interfaces.InvalidSessionException;
import com.prelytis.dashboard.interfaces.LicenseViolationException;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.value.LifeCycleRequest;
import com.prelytis.dashboard.value.LifeCycleResponse;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.SystemRequest;
import com.prelytis.dashboard.value.data.BeanPRPInfoModule;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.LogManager;

public abstract class LifeCycleFacade
implements DashboardFacade {
    private boolean axwayInstallerContext = false;
    private static String STD_AUTH_FACADE = "com.prelytis.dashboard.business.StandardAuthenticationFacade";
    private DashboardFacade facade;

    public void init(Map<String, String> properties) {
    }

    /*
     * Loose catch block
     */
    public Response dashboardRequest(Request request) throws DashboardException {
        if (request == null) {
            return null;
        }
        RequestContextImpl r = new RequestContextImpl(request.getUserSessionGuid(), request.getRequestGuid());
        try {
            boolean acceptRequest;
            DaoFactory daoFactory;
            try {
                daoFactory = DaoFactory.getInstance();
            }
            catch (Exception e) {
                daoFactory = null;
            }
            if (daoFactory != null) {
                PrelytisInfoDao infoDao = daoFactory.getPrelytisInfoDao();
                acceptRequest = infoDao.isDatabaseInCurrentVersion();
            } else {
                acceptRequest = false;
            }
            switch (request.getType()) {
                case 25: {
                    try {
                        LifeCycleResponse response;
                        LifeCycleRequest req = (LifeCycleRequest)request;
                        LifeCycleResponse lifeCycleResponse = response = (LifeCycleResponse)this.getFacade(daoFactory, !acceptRequest || req.getAction() != null && req.getAction() == LifeCycleRequest.Action.RELOAD_CONTEXT).dashboardRequest(request);
                        return lifeCycleResponse;
                    }
                    catch (Exception e) {
                        LifeCycleResponse response = new LifeCycleResponse();
                        response.setState(Integer.valueOf(0));
                        LifeCycleResponse lifeCycleResponse = response;
                        r.release();
                        return lifeCycleResponse;
                    }
                }
                case 22: {
                    Response e = this.getFacade(daoFactory, false).dashboardRequest(request);
                    return e;
                }
                case 13: {
                    SystemRequest systemRequest = (SystemRequest)request;
                    switch (systemRequest.getAction()) {
                        case CHECK_INSTALL: 
                        case CHECK_VERSION: 
                        case CREATE_DATABASE: 
                        case RUN_SQL_SCRIPTS: 
                        case MIGRATE_PROPERTY_FILE: {
                            Response response = this.getFacade(daoFactory, false).dashboardRequest((Request)systemRequest);
                            return response;
                        }
                    }
                }
            }
            if (!acceptRequest) {
                ApplicationException ae = new ApplicationException(ErrorCode.INSIGHT_PARAMETER_ERROR, "The application is not started");
                ae.setLocalizedMessage("The application is not started");
                throw ae;
            }
            Response response = this.getFacade(daoFactory, false).dashboardRequest(request);
            return response;
            {
                catch (DashboardException e) {
                    throw this.getLocalizedException(e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            r.release();
        }
    }

    private synchronized DashboardFacade getFacade(DaoFactory daoFactory, boolean reset) throws DashboardException {
        if (this.facade == null || reset) {
            List<BeanPRPInfoModule> modules = new ArrayList<BeanPRPInfoModule>();
            if (daoFactory != null) {
                PrelytisInfoDao infoDao = daoFactory.getPrelytisInfoDao();
                try {
                    modules.addAll(infoDao.getModules(true));
                }
                catch (Exception e) {
                    LogManager.getLogger(LifeCycleFacade.class).warn((Object)"Impossible to load modules", (Throwable)e);
                }
            }
            AbstractFacade prevDecorator = new BusinessFacade(null);
            ((AbstractFacade)prevDecorator).init(null);
            try {
                Thread thread = Thread.currentThread();
                ClassLoader classLoader = thread.getContextClassLoader();
                modules = this.getModulesWithOneStandardAuthFacade(modules);
                for (BeanPRPInfoModule dc : modules) {
                    try {
                        Class<?> decoratorClass = classLoader.loadClass(dc.getClassName());
                        Class[] cc = new Class[]{DashboardFacade.class};
                        Object[] oc = new Object[]{prevDecorator};
                        AbstractFacade decorator = (AbstractFacade)decoratorClass.getConstructor(cc).newInstance(oc);
                        decorator.init(dc.getParams());
                        prevDecorator = decorator;
                    }
                    catch (ClassNotFoundException cnfe) {
                        LogManager.getLogger(this.getClass()).error((Object)("Facade " + dc.getClassName() + " not found"));
                    }
                    catch (NoClassDefFoundError ncdfe) {
                        LogManager.getLogger(this.getClass()).error((Object)("Facade " + dc.getClassName() + " not loaded"));
                    }
                }
            }
            catch (Exception ex) {
                LogManager.getLogger(this.getClass()).error((Object)ex, (Throwable)ex);
                DashboardException de = new DashboardException((Throwable)ex);
                de.setLogged(true);
                throw de;
            }
            AccessControlFacade accessControlFacade = new AccessControlFacade(prevDecorator);
            ((AbstractFacade)accessControlFacade).init(null);
            this.facade = accessControlFacade;
        }
        return this.facade;
    }

    private List<BeanPRPInfoModule> getModulesWithOneStandardAuthFacade(List<BeanPRPInfoModule> modules) {
        ArrayList<BeanPRPInfoModule> newModules = new ArrayList<BeanPRPInfoModule>();
        if (!this.axwayInstallerContext) {
            BeanPRPInfoModule module = new BeanPRPInfoModule();
            module.setActive(true);
            module.setClassName(STD_AUTH_FACADE);
            module.setSystem(true);
            newModules.add(module);
            for (BeanPRPInfoModule dc : modules) {
                if (dc.getClassName().equals(STD_AUTH_FACADE)) continue;
                newModules.add(dc);
            }
        }
        return newModules;
    }

    protected void setAxwayInstallerContext(boolean value) {
        this.axwayInstallerContext = value;
    }

    private DashboardException getLocalizedException(DashboardException dashboardException) {
        DashboardException e = dashboardException;
        try {
            Locale locale = Locale.ENGLISH;
            if (e instanceof SecurityException) {
                this.localizeException(locale, e, "com.prelytis.dashboard.resources.Messages", "security", null);
            } else if (e instanceof InvalidSessionException) {
                this.localizeException(locale, e, "com.prelytis.dashboard.resources.Messages", "invalidSessionGUID", null);
            } else if (e instanceof LicenseViolationException) {
                this.localizeException(locale, e, "com.prelytis.dashboard.resources.Messages", "licenseViolation", null);
            }
            if (e.getLocalizedMessage() == null) {
                this.localizeException(locale, e, "com.prelytis.dashboard.resources.Messages", "genericError", null);
            }
            if (!e.isLogged()) {
                e.log(LogManager.getLogger(this.getClass()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return e;
    }

    private void localizeException(Locale locale, DashboardException e, String bundleName, String msgKey, Object[] parameters) {
        ResourceBundle bundle = null;
        bundle = locale == null ? ResourceBundle.getBundle(bundleName) : ResourceBundle.getBundle(bundleName, locale);
        String message = bundle.getString(msgKey);
        if (parameters != null) {
            MessageFormat mf = new MessageFormat(message);
            e.setLocalizedMessage(mf.format(parameters));
        } else {
            e.setLocalizedMessage(message);
        }
    }
}

