/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.business;

import com.prelytis.dashboard.ext.AbstractFacade;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardFacade;
import com.prelytis.dashboard.model.helper.UserLoginNamesBean;
import com.prelytis.dashboard.sentinel.security.ISentinelAuthenticationFacade;
import com.prelytis.dashboard.sentinel.security.SentinelAuthenticationFacade;
import com.prelytis.dashboard.value.LoginRequest;
import com.prelytis.dashboard.value.LoginResponse;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.api.PrelytisPrincipal;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;

public class StandardAuthenticationFacade
extends AbstractFacade {
    public StandardAuthenticationFacade(DashboardFacade facade) {
        super(facade);
    }

    @Override
    public void init(Map<String, String> properties) {
    }

    private Response dashboardLoginRequestWithLoginAction(LoginRequest loginRequest) throws DashboardException {
        String alteredLoginName = null;
        String originalLoginName = null;
        if (!loginRequest.isSkipSentinelServerLogin()) {
            UserLoginNamesBean userNamesBean = this.performSentinelLogin(loginRequest);
            alteredLoginName = userNamesBean.getLocalLoginName();
            originalLoginName = userNamesBean.getAuditLoginName();
        }
        if (alteredLoginName != null) {
            loginRequest.setUserPrincipal((Principal)new PrelytisPrincipal(alteredLoginName));
        }
        LoginResponse response = (LoginResponse)this.getFacade().dashboardRequest((Request)loginRequest);
        response.setUserLoginAudit(originalLoginName);
        return response;
    }

    public Response dashboardRequest(Request request) throws DashboardException {
        LoginRequest value;
        if (request.getType() == 3 && (value = (LoginRequest)request).getAction() == LoginRequest.Action.LOGIN) {
            return this.dashboardLoginRequestWithLoginAction(value);
        }
        return this.getFacade().dashboardRequest(request);
    }

    private UserLoginNamesBean performSentinelLogin(LoginRequest value) throws DashboardException {
        String principal = value.getUserPrincipal().getName();
        String passportDomain = value.getPassportDomain();
        String pwd = value.getPassword() == null ? "" : new String(value.getPassword());
        String token = (String)value.getOptions().get("com.prelytis.dashboard.SENTINEL_AUTHENTICATION_TOKEN_KEY");
        String ssoDomain = (String)value.getOptions().get("com.prelytis.dashboard.SENTINEL_AUTHENTICATION_SSO_DOMAIN");
        String ssoPrincipal = (String)value.getOptions().get("com.prelytis.dashboard.SENTINEL_AUTHENTICATION_SSO_LOGIN");
        String commonSSOPrincipal = (String)value.getOptions().get("SENTINEL_AUTHENTICATION_COMMON_SSO_LOGIN");
        HashMap commonSSOAttributes = (HashMap)value.getOptions().get("COMMON_SSO_ATTRIBUTES");
        String ipAddress = value.getIpAddress();
        String auditSessionId = value.getUserSessionAuditId();
        UserLoginNamesBean userLoginNames = null;
        ISentinelAuthenticationFacade sentinelFacade = SentinelAuthenticationFacade.getInstance();
        if ("webdashboard".equals(principal) && sentinelFacade.usesDomain()) {
            userLoginNames = new UserLoginNamesBean("webdashboard", "");
        } else if (commonSSOPrincipal != null) {
            userLoginNames = sentinelFacade.loginCommonSSO(commonSSOPrincipal, auditSessionId, ipAddress, commonSSOAttributes);
        } else if (ssoDomain != null && ssoPrincipal != null) {
            userLoginNames = sentinelFacade.login(ssoPrincipal, null, ssoDomain, true, auditSessionId, ipAddress);
        } else if (token != null) {
            userLoginNames = sentinelFacade.login(token, auditSessionId, ipAddress);
        } else if (principal != null && pwd != null) {
            userLoginNames = sentinelFacade.login(principal, pwd, passportDomain, false, auditSessionId, ipAddress);
        }
        return userLoginNames;
    }
}

