/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.calculation;

import com.prelytis.dashboard.data.calculation.CalculationSimple;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.db.value.ValueBigDecimal;
import com.prelytis.dashboard.db.value.ValueDecimalNumber;
import com.prelytis.dashboard.db.value.ValueDouble;
import com.prelytis.dashboard.db.value.ValueLong;
import com.prelytis.dashboard.db.value.ValueNull;
import com.prelytis.dashboard.interfaces.DashboardException;
import java.math.BigDecimal;
import java.util.Arrays;

public final class CalculationBase
extends CalculationSimple {
    private BigDecimal sumSquarred;
    private BigDecimal sum;
    private BigDecimal min;
    private BigDecimal max;
    private BigDecimal count;
    private BigDecimal[] values;

    public CalculationBase() {
    }

    public CalculationBase(CalculationBase calculation) {
        this.sumSquarred = calculation.sumSquarred;
        this.sum = calculation.sum;
        this.min = calculation.min;
        this.max = calculation.max;
        this.count = calculation.count;
        if (calculation.values != null) {
            int length = calculation.values.length;
            this.values = new BigDecimal[length];
            System.arraycopy(calculation.values, 0, this.values, 0, length);
        }
    }

    @Override
    public void addValue(Value value) throws DashboardException {
        if (value == null) {
            return;
        }
        if (value instanceof ValueDecimalNumber) {
            BigDecimal d = ((ValueDecimalNumber)value).getDecimalValue();
            this.sumSquarred = this.sumSquarred.add(d.pow(2));
            this.sum = this.sum.add(d);
            this.count = this.count.add(BigDecimal.ONE);
            this.min = this.min == null ? d : this.min.min(d);
            this.max = this.max == null ? d : this.max.max(d);
            System.arraycopy(this.values, 0, this.values, 1, this.values.length - 1);
            this.values[0] = d;
        }
    }

    @Override
    public Value getValue() {
        return this.getCount();
    }

    @Override
    public void reset() {
        this.sumSquarred = BigDecimal.ZERO;
        this.sum = BigDecimal.ZERO;
        this.count = BigDecimal.ZERO;
        this.max = null;
        this.min = null;
        this.values = new BigDecimal[2];
    }

    public Value getMin() {
        if (this.min == null) {
            return ValueNull.BIG_DECIMAL;
        }
        return new ValueBigDecimal(this.min);
    }

    public Value getMax() {
        if (this.max == null) {
            return ValueNull.BIG_DECIMAL;
        }
        return new ValueBigDecimal(this.max);
    }

    public Value getSum() {
        return new ValueBigDecimal(this.sum);
    }

    public Value getSumSquarred() {
        return new ValueBigDecimal(this.sumSquarred);
    }

    public ValueLong getCount() {
        return ValueLong.valueOf((long)this.count.longValue());
    }

    public Value getAverage() {
        if (this.count.signum() == 0) {
            return ValueNull.BIG_DECIMAL;
        }
        return new ValueBigDecimal(this.sum.divide(this.count, MATH_CONTEXT));
    }

    public Value getMedian() {
        if (this.min == null || this.max == null) {
            return ValueNull.BIG_DECIMAL;
        }
        return new ValueBigDecimal(this.min.add(this.max).divide(BigDecimal.valueOf(2L), MATH_CONTEXT));
    }

    public Value getStandardDeviation() {
        Value v = this.getVariance();
        if (v instanceof ValueDecimalNumber) {
            ValueDecimalNumber vdn = (ValueDecimalNumber)v;
            return new ValueDouble(Math.sqrt(vdn.getDecimalValue().doubleValue()));
        }
        return ValueNull.BIG_DECIMAL;
    }

    public Value getVariance() {
        if (this.count.signum() == 0) {
            return ValueNull.BIG_DECIMAL;
        }
        return new ValueBigDecimal(this.sumSquarred.subtract(this.sum.pow(2).divide(this.count, MATH_CONTEXT)).divide(this.count.subtract(BigDecimal.ONE), MATH_CONTEXT));
    }

    public Value getPercEvolution() {
        BigDecimal pValue = this.values[1];
        BigDecimal cValue = this.values[0];
        if (pValue == null && cValue == null) {
            return ValueNull.DOUBLE;
        }
        if (pValue != null && pValue.signum() != 0) {
            return new ValueBigDecimal(cValue.subtract(pValue).divide(pValue, MATH_CONTEXT));
        }
        switch (cValue.signum()) {
            case -1: {
                return new ValueDouble(Double.NEGATIVE_INFINITY);
            }
        }
        return new ValueDouble(Double.POSITIVE_INFINITY);
    }

    public Value getEvolution() {
        BigDecimal pValue = this.values[1];
        BigDecimal cValue = this.values[0];
        if (pValue == null || cValue == null) {
            return ValueNull.DOUBLE;
        }
        return new ValueBigDecimal(cValue.subtract(pValue));
    }

    public void addValues(CalculationBase calculation) {
        this.count = this.count.add(calculation.count);
        this.sum = this.sum.add(calculation.sum);
        this.sumSquarred = this.sumSquarred.add(calculation.sumSquarred);
        BigDecimal bigDecimal = this.min == null ? calculation.min : (this.min = calculation.min == null ? this.min : this.min.min(calculation.min));
        this.max = this.max == null ? calculation.max : (calculation.max == null ? this.max : this.max.max(calculation.max));
        Arrays.fill(this.values, BigDecimal.ZERO);
    }
}

