/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.engine;

import com.prelytis.dashboard.dao.value.DbJdbcDriverFunctionMapping;
import com.prelytis.dashboard.data.engine.ExecutionContext;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.util.DataExpressionParser;
import com.prelytis.dashboard.value.data.AbstractBeanReportAvlField;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTable;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableField;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableFilter;
import com.prelytis.dashboard.value.data.BeanQueryStar;
import com.prelytis.dashboard.value.query.ComparisonExpression;
import com.prelytis.dashboard.value.query.ConstantOperand;
import com.prelytis.dashboard.value.query.FieldOperand;
import com.prelytis.dashboard.value.query.LogicalExpression;
import com.prelytis.dashboard.value.query.Operand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CommandParameter {
    private final BeanQueryStar query;
    private final Map<Integer, DbJdbcDriverFunctionMapping> functionMapping;
    private final Map<String, BeanQueryDataStructureTable> queryTableMap;
    private final Map<String, AbstractBeanReportAvlField> fieldMap;
    private Map<String, BeanQueryDataStructureTableField> queryFieldMap;
    private final DataExpressionParser parser = DataExpressionParser.getInstance();
    private final Locale locale;

    private CommandParameter(ExecutionContext context, Map<String, BeanQueryDataStructureTable> queryTableMap, Map<String, BeanQueryDataStructureTableField> queryFieldMap) {
        this.fieldMap = context.getFieldMap();
        this.queryFieldMap = queryFieldMap;
        this.queryTableMap = queryTableMap;
        this.query = (BeanQueryStar)context.getQuery();
        this.functionMapping = context.getDriver() == null ? null : context.getDriver().getMapping();
        this.locale = context.getData() == null ? Locale.ENGLISH : context.getData().getLocale();
    }

    private static void fillFieldMap(BeanQueryDataStructureTable table, Map<String, BeanQueryDataStructureTable> queryTableMap, Map<String, BeanQueryDataStructureTableField> queryFieldMap) {
        queryTableMap.put(table.getName(), table);
        for (BeanQueryDataStructureTableField field : table.getTableFieldList()) {
            queryFieldMap.put(field.getName(), field);
        }
        for (BeanQueryDataStructureTable childTable : table.getTableChildList()) {
            CommandParameter.fillFieldMap(childTable, queryTableMap, queryFieldMap);
        }
    }

    public BeanQueryStar getQuery() {
        return this.query;
    }

    public AbstractBeanReportAvlField getAvlField(String name) {
        return this.fieldMap.get(name);
    }

    public BeanQueryDataStructureTableField getTableField(String name) throws DashboardException {
        BeanQueryDataStructureTableField field = this.queryFieldMap.get(name);
        if (field == null) {
            throw ExceptionHelper.getInstance(this.locale).createDashboardException("unknownField", new String[]{name}, null);
        }
        return field;
    }

    public BeanQueryDataStructureTable getTable(String name) throws DashboardException {
        BeanQueryDataStructureTable table = this.queryTableMap.get(name);
        if (table == null) {
            throw ExceptionHelper.getInstance(this.locale).createDashboardException("unknownTable", new String[]{name}, null);
        }
        return table;
    }

    public DbJdbcDriverFunctionMapping getSqlFunctionMapping(int functionOID) {
        return this.functionMapping.get(functionOID);
    }

    public LogicalExpression getQueryFilter() throws DashboardException {
        LogicalExpression expression = new LogicalExpression();
        expression.setOperator(1);
        this.fillFilter(expression, this.query.getTableFact());
        return expression;
    }

    private void fillFilter(LogicalExpression expression, BeanQueryDataStructureTable table) throws DashboardException {
        for (BeanQueryDataStructureTableFilter filter : table.getFilterList()) {
            ComparisonExpression exp = new ComparisonExpression();
            exp.setOperator(3);
            FieldOperand left = new FieldOperand();
            left.setField(this.getFieldName(table, filter.getFieldName()));
            left.setId(left.getId());
            ConstantOperand right = new ConstantOperand();
            right.setDataType(filter.getDataType());
            right.setValue((Object)this.parser.parseExpression(filter.getDataType(), filter.getPersField()));
            exp.setLeftOperand((Operand)left);
            exp.setRightOperand((Operand)right);
            expression.getExpressionList().add(exp);
        }
        List childList = table.getTableChildList();
        if (childList != null) {
            for (BeanQueryDataStructureTable child : childList) {
                this.fillFilter(expression, child);
            }
        }
    }

    private String getFieldName(BeanQueryDataStructureTable table, String sqlName) {
        for (BeanQueryDataStructureTableField field : table.getTableFieldList()) {
            if (!sqlName.equals(field.getSqlField())) continue;
            return field.getName();
        }
        throw new RuntimeException("sql " + sqlName + " not found");
    }

    public void add(BeanQueryDataStructureTable dsTable, BeanQueryDataStructureTableField dsField) {
        dsField.setBeanQueryDataStructureTable(dsTable);
        dsTable.getTableFieldList().add(dsField);
        this.queryFieldMap.put(dsField.getName(), dsField);
    }

    public BeanQueryDataStructureTable getParentTable(BeanQueryDataStructureTable table, String field) {
        int d;
        if (table == this.query.getTableFact()) {
            return table;
        }
        BeanQueryDataStructureTableField f = this.queryFieldMap.get(field);
        if (f == null) {
            throw new NullPointerException(field + " not found");
        }
        BeanQueryDataStructureTable t = f.getBeanQueryDataStructureTable();
        if (table == null) {
            return t;
        }
        List<BeanQueryDataStructureTable> ds2 = this.getParentList(t);
        int d2 = ds2.size();
        List<BeanQueryDataStructureTable> ds1 = this.getParentList(table);
        int d1 = ds1.size();
        for (int i = d = Math.min(d1, d2) - 1; i >= 0; --i) {
            BeanQueryDataStructureTable dst2;
            BeanQueryDataStructureTable dst1 = ds1.get(i);
            if (dst1 != (dst2 = ds2.get(i))) continue;
            return dst1;
        }
        throw new DashboardRuntimeException(ErrorCode.SHOULD_NEVER_OCCUR);
    }

    private List<BeanQueryDataStructureTable> getParentList(BeanQueryDataStructureTable t) {
        ArrayList<BeanQueryDataStructureTable> l = new ArrayList<BeanQueryDataStructureTable>();
        this.add(l, t);
        return l;
    }

    private void add(List<BeanQueryDataStructureTable> l, BeanQueryDataStructureTable t) {
        l.add(0, t);
        if (t.getParentTable() != null) {
            this.add(l, t.getParentTable());
        }
    }

    public static final CommandParameter getInstance(ExecutionContext context) {
        BeanQueryStar q = (BeanQueryStar)context.getQuery();
        HashMap<String, BeanQueryDataStructureTableField> queryFieldMap = new HashMap<String, BeanQueryDataStructureTableField>();
        HashMap<String, BeanQueryDataStructureTable> queryTableMap = new HashMap<String, BeanQueryDataStructureTable>();
        CommandParameter.fillFieldMap(q.getTableFact(), queryTableMap, queryFieldMap);
        return new CommandParameter(context, queryTableMap, queryFieldMap);
    }
}

