/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.engine;

import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.util.parsing.ExpressionParser;
import com.prelytis.dashboard.util.parsing.ParseException;
import com.prelytis.dashboard.util.parsing.PatternExpression;
import com.prelytis.dashboard.value.query.ComparisonExpression;
import com.prelytis.dashboard.value.query.ConstantOperand;
import com.prelytis.dashboard.value.query.Expression;
import com.prelytis.dashboard.value.query.FieldOperand;
import com.prelytis.dashboard.value.query.LogicalExpression;
import com.prelytis.dashboard.value.query.Operand;
import com.prelytis.dashboard.value.query.PromptOperand;
import com.prelytis.dashboard.value.util.DataType;
import java.util.ArrayList;
import java.util.List;

public final class ExpressionBuilder {
    private ExpressionBuilder() {
    }

    static Expression buildExpression(ComparisonExpression expression, ExpressionParser parser, PromptOperand prompt, FieldOperand fieldOp, boolean isSimpleValue) throws DashboardException {
        try {
            PatternExpression pe = parser.Parse();
            ComparisonExpression ce1 = null;
            ComparisonExpression ce2 = null;
            switch (expression.getOperator()) {
                case 3: {
                    ce1 = ExpressionBuilder.getCE(fieldOp, 3, prompt.getDataType(), pe.getInList(), pe.getLikeList(), isSimpleValue);
                    ce2 = ExpressionBuilder.getCE(fieldOp, 6, prompt.getDataType(), pe.getNotInList(), pe.getNotLikeList(), isSimpleValue);
                    break;
                }
                case 6: {
                    ce1 = ExpressionBuilder.getCE(fieldOp, 6, prompt.getDataType(), pe.getInList(), pe.getLikeList(), isSimpleValue);
                    ce2 = ExpressionBuilder.getCE(fieldOp, 3, prompt.getDataType(), pe.getNotInList(), pe.getNotLikeList(), isSimpleValue);
                }
            }
            if (ce1 == null) {
                return ce2;
            }
            if (ce2 == null) {
                return ce1;
            }
            return new LogicalExpression(ce1, 1, ce2);
        }
        catch (ParseException e) {
            throw new DashboardRuntimeException((Throwable)e);
        }
    }

    static ComparisonExpression getCE(FieldOperand lo, int op, DataType dataType, List<String> in, List<String> like, boolean isSimpleValue) throws DashboardException {
        ArrayList<String> l = new ArrayList<String>();
        if (in != null && !in.isEmpty()) {
            l.addAll(in);
        }
        if (like != null && !like.isEmpty()) {
            l.addAll(like);
        }
        if (!l.isEmpty()) {
            ConstantOperand co = new ConstantOperand();
            co.setDataType(dataType);
            co.setValue((Object)l.toArray(new Object[l.size()]));
            return ExpressionBuilder.getCE(lo, op, (Operand)co, isSimpleValue);
        }
        return null;
    }

    static ComparisonExpression getCE(FieldOperand lo, int op, Operand ro, boolean isSimpleValue) throws DashboardException {
        ComparisonExpression newExpression = new ComparisonExpression();
        newExpression.setLeftOperand((Operand)lo);
        newExpression.setRightOperand(ro);
        newExpression.setOperator(op);
        newExpression.setIsSimpleValue(isSimpleValue);
        return newExpression;
    }
}

