/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.engine.ds;

import com.prelytis.dashboard.dao.value.DbJdbcDriverFunctionMapping;
import com.prelytis.dashboard.data.engine.ExecutionContext;
import com.prelytis.dashboard.data.engine.SqlString;
import com.prelytis.dashboard.data.engine.ds.EngineDS;
import com.prelytis.dashboard.data.engine.ds.TempField;
import com.prelytis.dashboard.data.engine.ds.TempFieldColumn;
import com.prelytis.dashboard.data.engine.ds.TempFieldConstant;
import com.prelytis.dashboard.data.engine.ds.TempFieldSql;
import com.prelytis.dashboard.data.engine.ds.ToBeRemovedException;
import com.prelytis.dashboard.data.sql.RequestBuilder;
import com.prelytis.dashboard.data.value.QueryDS;
import com.prelytis.dashboard.data.value.QueryDSField;
import com.prelytis.dashboard.data.value.QueryDSJoin;
import com.prelytis.dashboard.data.value.QueryDSJoinElement;
import com.prelytis.dashboard.data.value.QueryDSTable;
import com.prelytis.dashboard.db.QuerySQL;
import com.prelytis.dashboard.db.operator.WorldHelper;
import com.prelytis.dashboard.db.operator.WorldType;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.db.value.ValueArray;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.util.DataExpressionParser;
import com.prelytis.dashboard.util.ExpressionEvaluationHelper;
import com.prelytis.dashboard.util.conversion.Conv2SQLString;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTable;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableField;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableFilter;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableJoin;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableJoinElement;
import com.prelytis.dashboard.value.data.BeanQueryStar;
import com.prelytis.dashboard.value.data.BeanReportAvlField;
import com.prelytis.dashboard.value.data.BeanSQLFctImplDefinition;
import com.prelytis.dashboard.value.data.BeanSQLFctImplParam;
import com.prelytis.dashboard.value.data.BeanSQLFctImplParamGroup;
import com.prelytis.dashboard.value.data.BeanSQLFunctionDefinition;
import com.prelytis.dashboard.value.data.BeanSQLFunctionParamType;
import com.prelytis.dashboard.value.data.BeanSQLStyle;
import com.prelytis.dashboard.value.data.BeanWorldDefinition;
import com.prelytis.dashboard.value.data.DriverCharacteristics;
import com.prelytis.dashboard.value.query.CalcFunctionOperand;
import com.prelytis.dashboard.value.query.CalculatedOperand;
import com.prelytis.dashboard.value.query.ComparisonExpression;
import com.prelytis.dashboard.value.query.ConstantOperand;
import com.prelytis.dashboard.value.query.FieldOperand;
import com.prelytis.dashboard.value.query.IOperandGroup;
import com.prelytis.dashboard.value.query.IOperandGroupElement;
import com.prelytis.dashboard.value.query.Operand;
import com.prelytis.dashboard.value.query.OperandGroup;
import com.prelytis.dashboard.value.query.OperandGroupElement;
import com.prelytis.dashboard.value.util.AllExpression;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.DateTruncation;
import com.prelytis.dashboard.value.util.Expression;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class CommandQuery {
    private static final Logger log = LogManager.getLogger(CommandQuery.class);
    private final EngineDS mediator;
    private final ExecutionContext context;
    private final Map<Integer, QueryDSTable> tableList = new HashMap<Integer, QueryDSTable>();
    private final QueryDS queryDS;
    private final QueryDSTable topTable;
    private final BeanQueryDataStructureTable topDSTable;
    private final WorldHelper worldHelper;
    private final String sep;
    private boolean booleanSupport;
    private final ExpressionEvaluationHelper helper = ExpressionEvaluationHelper.getInstance();
    private final DataExpressionParser parser = DataExpressionParser.getInstance();
    private Map<SqlString, Integer> sqlPosition = new HashMap<SqlString, Integer>();

    private CommandQuery(EngineDS mediator, ExecutionContext context, QueryDS queryDS, BeanQueryDataStructureTable table) {
        this.mediator = mediator;
        this.context = context;
        this.worldHelper = WorldHelper.getInstance((BeanWorldDefinition)context.getWorld(), (DriverCharacteristics)context.getDriver(), (ExpressionEvaluationData)context.getData());
        this.sep = this.worldHelper.getIdentifierQuoteString();
        this.topDSTable = table;
        this.queryDS = queryDS;
        this.topTable = new QueryDSTable(this.getTableName(table));
        this.queryDS.setTable(this.topTable);
        this.tableList.put(table.getId(), this.topTable);
    }

    public static CommandQuery getInstance(EngineDS mediator, ExecutionContext context, BeanQueryDataStructureTable table) {
        BeanQueryStar query = (BeanQueryStar)context.getQuery();
        QueryDS queryDS = new QueryDS();
        queryDS.setUsePreparedStatement(true);
        queryDS.setMaxRows(query.getMaxLines());
        return new CommandQuery(mediator, context, queryDS, table);
    }

    Integer addField(SqlString sql, DataType datatype) {
        Integer pos = this.sqlPosition.get(sql);
        if (pos == null) {
            pos = this.sqlPosition.size();
            this.sqlPosition.put(sql, pos);
            SqlString s = new SqlString();
            if (!this.booleanSupport && datatype == DataType.BOOLEAN) {
                s.setSql(new StringBuffer().append("(CASE WHEN ").append(sql.getSql()).append(" THEN 'true' ELSE 'false' END) AS C").append(pos).toString());
                datatype = DataType.VARCHAR;
            } else {
                s.setSql(new StringBuffer().append(sql.getSql()).append(" AS C").append(pos).toString());
            }
            s.getParameterList().addAll(sql.getParameterList());
            QueryDSField field = new QueryDSField(s, datatype);
            this.queryDS.getFieldList().add(field);
        }
        return pos;
    }

    TempFieldSql getTempFieldSql(CalcFunctionOperand function, BeanSQLFunctionDefinition fct, BeanSQLFctImplDefinition impl, List<TempField> fieldList) throws DashboardException {
        ArrayList<Value> parameterList = new ArrayList<Value>();
        StringBuffer str = new StringBuffer();
        Iterator<TempField> it = fieldList.iterator();
        SqlString prevGroupString = null;
        ArrayList<SqlString> groupByList = new ArrayList<SqlString>();
        if (impl.getLeftString() != null) {
            this.appendString(str, impl.getLeftString());
        }
        boolean containsAgreg = false;
        List implPrmGrpLst = impl.getParamGroupList();
        int nbGroup = function.getOperandGroups().size();
        for (int i = 0; i < nbGroup; ++i) {
            IOperandGroup group = (IOperandGroup)function.getOperandGroups().get(i);
            BeanSQLFctImplParamGroup implPrmGrp = (BeanSQLFctImplParamGroup)implPrmGrpLst.get(i);
            TempFieldSql grp = this.getGroupString(it, group, implPrmGrp, prevGroupString);
            prevGroupString = grp.getSql();
            if (grp.isAgregated()) {
                containsAgreg = true;
            }
            groupByList.addAll(grp.getGroupByList());
        }
        if (prevGroupString != null) {
            this.appendString(str, prevGroupString.getSql());
            parameterList.addAll(prevGroupString.getParameterList());
        }
        if (impl.getRightString() != null) {
            this.appendString(str, impl.getRightString());
        }
        TempFieldSql field = new TempFieldSql();
        SqlString sql = new SqlString();
        sql.setSql(str.toString());
        sql.getParameterList().addAll(parameterList);
        field.setSql(sql);
        field.setDatatype(this.getReturnDataType(fct));
        if (containsAgreg) {
            field.setGroupByList(groupByList);
            field.setAgregated(true);
        } else if (fct.getAgregation()) {
            field.setAgregated(true);
        } else {
            groupByList.clear();
            SqlString s = field.getSql();
            if (!this.booleanSupport && field.getDatatype() == DataType.BOOLEAN) {
                SqlString t = new SqlString();
                t.setSql(new StringBuffer().append("(CASE WHEN ").append(s.getSql()).append(" THEN 'true' ELSE 'false' END)").toString());
                t.getParameterList().addAll(s.getParameterList());
                s = t;
            }
            groupByList.add(s);
            field.setGroupByList(groupByList);
        }
        return field;
    }

    private DataType getReturnDataType(BeanSQLFunctionDefinition fct) {
        int paramTypeId = fct.getReturnParamTypeId();
        for (BeanSQLFunctionParamType type : fct.getParamTypeList()) {
            if (type.getParamTypeId() != paramTypeId) continue;
            return type.getDatatype();
        }
        return DataType.GENERIC_ANY;
    }

    QuerySQL getQuerySQL() throws DashboardException {
        try {
            BeanSQLStyle sqlStyle = this.context.getDriver().getSqlStyle();
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            Class<?> sqlStyleClass = classLoader.loadClass(sqlStyle.getClassName());
            RequestBuilder builder = (RequestBuilder)sqlStyleClass.newInstance();
            return builder.getRequest(this.queryDS);
        }
        catch (Exception e) {
            throw this.mediator.getDashboardException(e);
        }
    }

    void updateQuery(TempFieldSql queryFilter, TempField reportFilter) {
        if (reportFilter != null) {
            switch (reportFilter.getType()) {
                case COLUMN: {
                    if (queryFilter != null) {
                        this.queryDS.addGroupBy(queryFilter.getGroupByList());
                        this.queryDS.setWhere(queryFilter.getSql());
                    }
                    TempFieldColumn tfC = (TempFieldColumn)reportFilter;
                    tfC.getColumn();
                    break;
                }
                case CONSTANT: {
                    if (queryFilter == null) break;
                    this.queryDS.addGroupBy(queryFilter.getGroupByList());
                    this.queryDS.setWhere(queryFilter.getSql());
                    break;
                }
                case SQL: {
                    TempFieldSql tfs = (TempFieldSql)reportFilter;
                    this.queryDS.addGroupBy(tfs.getGroupByList());
                    if (tfs.isAgregated()) {
                        this.queryDS.setHaving(tfs.getSql());
                        if (queryFilter == null) break;
                        this.queryDS.addGroupBy(queryFilter.getGroupByList());
                        this.queryDS.setWhere(queryFilter.getSql());
                        break;
                    }
                    if (queryFilter != null) {
                        SqlString s = tfs.getSql();
                        this.queryDS.addGroupBy(queryFilter.getGroupByList());
                        SqlString qf = queryFilter.getSql();
                        StringBuffer sb = new StringBuffer();
                        sb.append("(");
                        sb.append(qf.getSql());
                        sb.append(") AND (");
                        sb.append(s.getSql());
                        sb.append(")");
                        SqlString ns = new SqlString();
                        List<Value> parameterList = ns.getParameterList();
                        parameterList.addAll(qf.getParameterList());
                        parameterList.addAll(s.getParameterList());
                        ns.setSql(sb.toString());
                        this.queryDS.setWhere(ns);
                        break;
                    }
                    this.queryDS.setWhere(tfs.getSql());
                }
            }
        } else if (queryFilter != null) {
            this.queryDS.addGroupBy(queryFilter.getGroupByList());
            this.queryDS.setWhere(queryFilter.getSql());
        }
    }

    TempFieldSql getQueryFilter() throws DashboardException {
        return this.getQueryFilter(this.topDSTable);
    }

    private TempFieldSql getQueryFilter(BeanQueryDataStructureTable table) throws DashboardException {
        List childList;
        StringBuffer sb = new StringBuffer();
        ArrayList<Value> parameterList = new ArrayList<Value>();
        boolean agregated = false;
        boolean hasData = false;
        TempFieldSql tfs = this.getTableFilter(table);
        if (tfs != null) {
            SqlString s = tfs.getSql();
            sb.append(s.getSql());
            parameterList.addAll(s.getParameterList());
            hasData = true;
        }
        if ((childList = table.getTableChildList()).size() > 0) {
            for (BeanQueryDataStructureTable child : childList) {
                tfs = this.getQueryFilter(child);
                if (tfs == null) continue;
                if (hasData) {
                    sb.append(" AND ");
                }
                SqlString s = tfs.getSql();
                sb.append(s.getSql());
                parameterList.addAll(s.getParameterList());
                if (tfs.isAgregated()) {
                    agregated = true;
                }
                hasData = true;
            }
        }
        if (hasData) {
            SqlString s = new SqlString();
            s.setSql(sb.toString());
            s.getParameterList().addAll(parameterList);
            tfs = new TempFieldSql();
            tfs.setAgregated(agregated);
            tfs.setSql(s);
            return tfs;
        }
        return null;
    }

    TempFieldSql getComparisonSqlTempField(TempField leftField, int operator, TempField rightField) throws DashboardException {
        SqlString s;
        TempFieldSql tfs;
        TempFieldConstant tfc;
        HashSet<SqlString> groupByList = new HashSet<SqlString>();
        ArrayList<Value> parameterList = new ArrayList<Value>();
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        boolean agregated = false;
        switch (leftField.getType()) {
            default: {
                throw new DashboardRuntimeException(ErrorCode.SHOULD_NEVER_OCCUR);
            }
            case CONSTANT: {
                tfc = (TempFieldConstant)leftField;
                buffer.append(this.encodeSql(tfc.getConstant()));
                break;
            }
            case SQL: {
                tfs = (TempFieldSql)leftField;
                s = tfs.getSql();
                buffer.append(s.getSql());
                parameterList.addAll(s.getParameterList());
            }
        }
        agregated &= leftField.isAgregated();
        buffer.append(ComparisonExpression.getStringOperator((int)operator));
        switch (rightField.getType()) {
            default: {
                throw new DashboardRuntimeException(ErrorCode.SHOULD_NEVER_OCCUR);
            }
            case CONSTANT: {
                tfc = (TempFieldConstant)rightField;
                buffer.append(this.encodeSql(tfc.getConstant()));
                break;
            }
            case SQL: {
                tfs = (TempFieldSql)rightField;
                s = tfs.getSql();
                buffer.append(s.getSql());
                parameterList.addAll(s.getParameterList());
            }
        }
        agregated &= rightField.isAgregated();
        buffer.append(")");
        SqlString s2 = new SqlString();
        s2.setSql(buffer.toString());
        s2.getParameterList().addAll(parameterList);
        TempFieldSql dest = new TempFieldSql();
        dest.setAgregated(agregated);
        dest.setDatatype(DataType.BOOLEAN);
        dest.setSql(s2);
        dest.setGroupByList(groupByList);
        return dest;
    }

    /*
     * WARNING - void declaration
     */
    TempFieldSql getComparisonSqlTempField(TempField leftField, int operator, Operand rightOperand, boolean isSimpleValue) throws DashboardException {
        String className = this.worldHelper.getDriverClassName();
        HashSet<SqlString> groupByList = new HashSet<SqlString>();
        ArrayList parameterList = new ArrayList();
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        boolean agregated = false;
        SqlString ls = null;
        Object[] values = null;
        switch (leftField.getType()) {
            default: {
                throw new DashboardRuntimeException(ErrorCode.SHOULD_NEVER_OCCUR);
            }
            case CONSTANT: {
                TempFieldConstant tfc = (TempFieldConstant)leftField;
                ls = new SqlString();
                ls.setSql(this.encodeSql(tfc.getConstant()));
                values = this.getDefaultValue(((TempFieldConstant)leftField).getDatatype());
                break;
            }
            case SQL: {
                TempFieldSql tfs = (TempFieldSql)leftField;
                ls = tfs.getSql();
                values = this.getDefaultValue(((TempFieldSql)leftField).getDatatype());
            }
        }
        agregated &= leftField.isAgregated();
        if (rightOperand instanceof ConstantOperand) {
            TempFieldConstant cst = this.mediator.getTempField((ConstantOperand)rightOperand);
            Object o = cst.getConstant().getObject();
            if (o instanceof Object[]) {
                values = (Object[])o;
            } else if (o != null) {
                values = new Object[]{o};
            }
        } else {
            throw new DashboardRuntimeException(ErrorCode.SHOULD_NEVER_OCCUR);
        }
        if (values == null) {
            buffer.append(ls.getSql());
            buffer.append(" IS NULL");
        } else {
            boolean wa = operator == 6 || operator == 3;
            ArrayList<Value> vss = new ArrayList<Value>();
            ArrayList<Value> vsw = new ArrayList<Value>();
            ArrayList<Object> vso = new ArrayList<Object>();
            for (Object value : values) {
                if (value instanceof Expression) {
                    value = this.helper.evaluateExpression((Expression)value, this.context.getData());
                }
                if (value instanceof Object[]) {
                    for (Object o : (Object[])value) {
                        if (this.isWildcard(o)) {
                            throw new ToBeRemovedException();
                        }
                        vso.add(o);
                    }
                    continue;
                }
                if (this.isWildcard(value)) {
                    throw new ToBeRemovedException();
                }
                vso.add(value);
            }
            for (Object e : vso) {
                if (wa && e != null && e instanceof String && this.containsWildcard((String)e) && !isSimpleValue) {
                    vsw.add(Value.valueOf((Object)((String)e).replaceAll("\\*", "%").replaceAll("\\?", "_")));
                    continue;
                }
                vss.add(Value.valueOf(e));
            }
            if (wa) {
                String opn;
                String opss;
                String ops;
                if (operator == 6) {
                    ops = "<>";
                    opss = " NOT IN ";
                    String string = " NOT LIKE ";
                    opn = " IS NOT NULL";
                } else if (operator == 3) {
                    ops = "=";
                    opss = " IN ";
                    String string = " LIKE ";
                    opn = " IS NULL";
                } else {
                    throw this.mediator.getDashboardException("unknownOperator", null);
                }
                boolean first = true;
                buffer.append("(");
                switch (vss.size()) {
                    case 0: {
                        if (!vsw.isEmpty()) break;
                        buffer.append(ls.getSql());
                        buffer.append(opn);
                        first = false;
                        break;
                    }
                    case 1: {
                        buffer.append(ls.getSql());
                        buffer.append(ops);
                        buffer.append("?");
                        parameterList.add(vss.get(0));
                        first = false;
                        break;
                    }
                    default: {
                        buffer.append(ls.getSql());
                        buffer.append(opss);
                        buffer.append("(");
                        boolean firstValue = true;
                        for (Value v : vss) {
                            if (firstValue) {
                                firstValue = false;
                            } else {
                                buffer.append(",");
                            }
                            buffer.append("?");
                            parameterList.add(v);
                        }
                        buffer.append(")");
                        first = false;
                    }
                }
                if (vsw.size() > 0) {
                    for (Value v : vsw) {
                        void var17_23;
                        if (first) {
                            first = false;
                        } else {
                            buffer.append(" OR ");
                        }
                        buffer.append(ls.getSql());
                        buffer.append((String)var17_23);
                        buffer.append("?");
                        parameterList.add(v);
                    }
                    if (className.equals(WorldType.MYSQL.toString())) {
                        buffer.append(" ESCAPE '\\\\'");
                    } else if (className.equals(WorldType.ORACLE.toString()) || className.equals(WorldType.DB2.toString()) || className.equals(WorldType.MICROSOFT.toString())) {
                        buffer.append(" ESCAPE '\\'");
                    }
                }
                buffer.append(")");
            } else if (vss.size() == 1) {
                Value v = (Value)vss.get(0);
                buffer.append(ls.getSql());
                buffer.append(ComparisonExpression.getStringOperator((int)operator));
                buffer.append("?");
                parameterList.add(v);
            } else if (vss.size() != 0) {
                throw this.mediator.getDashboardException("unsupportedMultipleValues", null);
            }
        }
        buffer.append(")");
        SqlString s = new SqlString();
        s.setSql(buffer.toString());
        s.getParameterList().addAll(parameterList);
        TempFieldSql dest = new TempFieldSql();
        dest.setAgregated(agregated);
        dest.setDatatype(DataType.BOOLEAN);
        dest.setSql(s);
        dest.setGroupByList(groupByList);
        return dest;
    }

    private Object[] getDefaultValue(DataType dataType) {
        if (dataType != null && dataType.isText()) {
            return new Object[]{""};
        }
        return null;
    }

    private boolean containsWildcard(String value) {
        return value != null && (value.indexOf(42) != -1 || value.indexOf(63) != -1);
    }

    String encodeSql(Value constant) throws DashboardException {
        try {
            Conv2SQLString conv = new Conv2SQLString("null");
            Object o = constant.getObject();
            if (o instanceof Object[]) {
                Object[] os = (Object[])o;
                o = os.length > 0 ? os[0] : null;
            }
            return conv.getValue(o);
        }
        catch (Exception e) {
            throw this.mediator.getDashboardException(e);
        }
    }

    TempFieldSql getLogicalSqlTempField(List<TempField> fieldList, String operator) throws DashboardException {
        HashSet<SqlString> groupByList = new HashSet<SqlString>();
        ArrayList<Value> parameterList = new ArrayList<Value>();
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        boolean first = true;
        boolean agregated = false;
        for (TempField field : fieldList) {
            if (first) {
                first = false;
            } else {
                buffer.append(operator);
            }
            switch (field.getType()) {
                default: {
                    throw this.mediator.getDashboardException("shouldNeverOccur", null);
                }
                case CONSTANT: {
                    TempFieldConstant tfc = (TempFieldConstant)field;
                    buffer.append(this.encodeSql(tfc.getConstant()));
                    break;
                }
                case SQL: {
                    TempFieldSql tfs = (TempFieldSql)field;
                    SqlString s = tfs.getSql();
                    buffer.append(s.getSql());
                    parameterList.addAll(s.getParameterList());
                }
            }
            agregated &= field.isAgregated();
        }
        buffer.append(")");
        SqlString s = new SqlString();
        s.setSql(buffer.toString());
        s.getParameterList().addAll(parameterList);
        TempFieldSql dest = new TempFieldSql();
        dest.setSql(s);
        dest.setGroupByList(groupByList);
        dest.setAgregated(agregated);
        dest.setDatatype(DataType.BOOLEAN);
        return dest;
    }

    Value getValue(Object value) throws DashboardException {
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            Value[] resu = new Value[values.length];
            for (int i = 0; i < resu.length; ++i) {
                resu[i] = this.getValue(values[i]);
            }
            return new ValueArray(resu);
        }
        if (value instanceof Expression) {
            return Value.valueOf((Object)this.helper.evaluateExpression((Expression)value, this.context.getData(), this.context.getFilterMap()));
        }
        return Value.valueOf((Object)value);
    }

    void addGroupBy(Collection<SqlString> groupByList) {
        this.queryDS.addGroupBy(groupByList);
    }

    void clearGroupByCollection() {
        this.queryDS.getGroupByList().clear();
    }

    void addSort(String alias, boolean sortOrder) {
        this.queryDS.addSort(alias, sortOrder);
    }

    boolean isSql(TempField field) {
        switch (field.getType()) {
            default: {
                return false;
            }
            case CONSTANT: 
            case SQL: 
        }
        return true;
    }

    private String getTableName(BeanQueryDataStructureTable dsTable) {
        return this.worldHelper.getQualifiedTableName(dsTable.getCatalog(), dsTable.getSchema(), dsTable.getName()) + " T" + dsTable.getId();
    }

    private void appendString(StringBuffer str, String value) {
        if (value != null && value.length() > 0) {
            boolean needSpace = true;
            if (this.isLastCharIsSeparator(str) && this.isFirstCharIsSeparator(value)) {
                needSpace = false;
            }
            if (needSpace) {
                str.append(" ");
            }
            str.append(value);
        }
    }

    private boolean isFirstCharIsSeparator(String value) {
        return this.isSeparator(value.charAt(0));
    }

    private boolean isLastCharIsSeparator(StringBuffer value) {
        int lastChar = value.length() - 1;
        if (lastChar < 0) {
            return false;
        }
        return this.isSeparator(value.charAt(lastChar));
    }

    private boolean isSeparator(char value) {
        switch (value) {
            case ' ': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '/': {
                return true;
            }
        }
        return false;
    }

    private TempFieldSql getGroupString(Iterator<TempField> it, IOperandGroup group, BeanSQLFctImplParamGroup implPrmGrp, SqlString prevGroupString) throws DashboardException {
        TempFieldSql resu = new TempFieldSql();
        ArrayList<Value> parameterList = new ArrayList<Value>();
        StringBuffer str = new StringBuffer();
        this.appendString(str, implPrmGrp.getLeftString());
        int cpt = 1;
        if (implPrmGrp.getPreviousGroupPosition() == cpt && prevGroupString != null) {
            this.appendString(str, prevGroupString.getSql());
            parameterList.addAll(prevGroupString.getParameterList());
        }
        HashSet<SqlString> groupByList = new HashSet<SqlString>();
        for (IOperandGroupElement elt : group.getElementList()) {
            int nbOperand = 0;
            if (elt.getOperands() != null) {
                nbOperand = elt.getOperands().size();
            }
            if (nbOperand != implPrmGrp.getNbParam()) {
                throw this.mediator.getDashboardException("invalidNumberOfOperand", null);
            }
            List implPrmList = implPrmGrp.getParamList();
            for (BeanSQLFctImplParam implPrm : implPrmList) {
                this.appendString(str, implPrm.getLeftString());
                if (implPrmGrp.getPreviousGroupPosition() == ++cpt && prevGroupString != null) {
                    this.appendString(str, prevGroupString.getSql());
                    parameterList.addAll(prevGroupString.getParameterList());
                }
                TempField field = it.next();
                switch (field.getType()) {
                    case COLUMN: {
                        throw this.mediator.getDashboardException("shouldNeverOccur", null);
                    }
                    case CONSTANT: {
                        TempFieldConstant tfc = (TempFieldConstant)field;
                        if (implPrm.getDataPosition() == 1) {
                            this.appendString(str, this.encodeSql(tfc.getConstant()));
                        }
                        this.appendString(str, implPrm.getMidString());
                        if (implPrmGrp.getPreviousGroupPosition() == ++cpt && prevGroupString != null) {
                            this.appendString(str, prevGroupString.getSql());
                            parameterList.addAll(prevGroupString.getParameterList());
                        }
                        if (implPrm.getDataPosition() == 2) {
                            this.appendString(str, this.encodeSql(tfc.getConstant()));
                        }
                        this.appendString(str, implPrm.getRightString());
                        break;
                    }
                    case SQL: {
                        SqlString tmp;
                        TempFieldSql tfs = (TempFieldSql)field;
                        if (!tfs.isAgregated()) {
                            if (tfs.getGroupByList() != null) {
                                groupByList.addAll(tfs.getGroupByList());
                            }
                        } else {
                            resu.setAgregated(true);
                        }
                        if (implPrm.getDataPosition() == 1) {
                            tmp = tfs.getSql();
                            parameterList.addAll(tmp.getParameterList());
                            this.appendString(str, tmp.getSql());
                        }
                        this.appendString(str, implPrm.getMidString());
                        if (implPrmGrp.getPreviousGroupPosition() == ++cpt && prevGroupString != null) {
                            this.appendString(str, prevGroupString.getSql());
                            parameterList.addAll(prevGroupString.getParameterList());
                        }
                        if (implPrm.getDataPosition() == 2) {
                            tmp = tfs.getSql();
                            parameterList.addAll(tmp.getParameterList());
                            this.appendString(str, tmp.getSql());
                        }
                        this.appendString(str, implPrm.getRightString());
                    }
                }
            }
        }
        if (implPrmGrp.getPreviousGroupPosition() == ++cpt && prevGroupString != null) {
            this.appendString(str, prevGroupString.getSql());
            parameterList.addAll(prevGroupString.getParameterList());
        }
        this.appendString(str, implPrmGrp.getRightString());
        SqlString sql = new SqlString();
        sql.setSql(str.toString());
        sql.getParameterList().addAll(parameterList);
        resu.setSql(sql);
        resu.setGroupByList(groupByList);
        return resu;
    }

    private TempFieldSql getTableFilter(BeanQueryDataStructureTable table) throws DashboardException {
        List filterList = table.getFilterList();
        StringBuffer sb = null;
        ArrayList<Value> parameterList = new ArrayList<Value>();
        boolean agregated = false;
        if (filterList.size() > 0) {
            for (BeanQueryDataStructureTableFilter filter : filterList) {
                Object obj = filter.getPersField();
                try {
                    obj = this.helper.evaluateExpression(this.parser.parseExpression(filter.getDataType(), filter.getPersField()), this.context.getData());
                }
                catch (DashboardException e) {
                    e.log(log);
                }
                if (this.isWildcard(obj)) continue;
                if (sb == null) {
                    sb = new StringBuffer();
                } else {
                    sb.append(" AND ");
                }
                StringBuffer lsb = new StringBuffer();
                lsb.append("T").append(table.getId()).append(".").append(this.sep).append(filter.getFieldName()).append(this.sep);
                SqlString ss = new SqlString();
                ss.setSql(lsb.toString());
                TempFieldSql left = new TempFieldSql();
                left.setSql(ss);
                ConstantOperand co = new ConstantOperand();
                co.setValue(obj);
                TempFieldSql tfs = this.getComparisonSqlTempField(left, filter.getOperator(), (Operand)co, false);
                SqlString s = tfs.getSql();
                sb.append(s.getSql());
                parameterList.addAll(s.getParameterList());
                if (!tfs.isAgregated()) continue;
                agregated = true;
            }
            this.fill(table);
        }
        if (sb == null) {
            return null;
        }
        SqlString s = new SqlString();
        s.setSql(sb.toString());
        s.getParameterList().addAll(parameterList);
        TempFieldSql tfs = new TempFieldSql();
        tfs.setSql(s);
        tfs.setAgregated(agregated);
        return tfs;
    }

    private boolean isWildcard(Object obj) {
        if (obj instanceof Object[]) {
            Object[] os;
            for (Object o : os = (Object[])obj) {
                if (!this.isWildcard(o)) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof String) {
            return "*".equals(obj);
        }
        return obj instanceof AllExpression;
    }

    private QueryDSTable fill(BeanQueryDataStructureTable dsTable) throws DashboardException {
        QueryDSTable table = this.tableList.get(dsTable.getId());
        if (table != null) {
            return table;
        }
        table = new QueryDSTable(this.getTableName(dsTable));
        this.tableList.put(dsTable.getId(), table);
        BeanQueryDataStructureTable dsParent = dsTable.getParentTable();
        if (dsParent != null) {
            QueryDSTable parent = this.fill(dsParent);
            parent.getChildList().add(table);
            BeanQueryDataStructureTableJoin join = dsTable.getJoin();
            QueryDSJoin queryJoin = new QueryDSJoin(join.getJoinType());
            table.setJoin(queryJoin);
            for (BeanQueryDataStructureTableJoinElement joinElt : join.getJoinElementList()) {
                String left = new StringBuffer().append("T").append(dsParent.getId()).append(".").append(this.sep).append(joinElt.getLeftField()).append(this.sep).toString();
                String right = new StringBuffer().append("T").append(dsTable.getId()).append(".").append(this.sep).append(joinElt.getRightField()).append(this.sep).toString();
                QueryDSJoinElement joinElement = new QueryDSJoinElement(left, right);
                queryJoin.add(joinElement);
            }
        } else {
            throw this.mediator.getDashboardException("shouldNeverOccur", null);
        }
        return table;
    }

    TempField getTempField(BeanReportAvlField avlField) throws DashboardException {
        String name = avlField.getField().getName();
        BeanQueryDataStructureTableField field = this.mediator.getTableField(name);
        if (field == null) {
            throw this.mediator.getDashboardException("unknownField", new String[]{name});
        }
        BeanQueryDataStructureTable dsTable = field.getBeanQueryDataStructureTable();
        this.fill(dsTable);
        SqlString sql = new SqlString();
        sql.setSql(new StringBuffer().append("T").append(dsTable.getId()).append(".").append(this.sep).append(field.getSqlField()).append(this.sep).toString());
        ArrayList<SqlString> groupByList = new ArrayList<SqlString>();
        groupByList.add(sql);
        TempFieldSql tf = new TempFieldSql();
        tf.setSql(sql);
        tf.setAgregated(false);
        tf.setGroupByList(groupByList);
        tf.setDatatype(avlField.getDataType());
        if (DataType.isDate((DataType)field.getDataType()) && field.getDateTruncation() != null && field.getDateTruncation() != DateTruncation.NONE) {
            FieldOperand fo = new FieldOperand();
            fo.setField(name);
            CalculatedOperand aco = new CalculatedOperand();
            aco.setAgregated(false);
            aco.setOperand((Operand)fo);
            OperandGroupElement operandGroupElement = new OperandGroupElement();
            operandGroupElement.getOperands().add(aco);
            OperandGroup operandGroup = new OperandGroup();
            operandGroup.getElementList().add(operandGroupElement);
            ArrayList<OperandGroup> operandGroups = new ArrayList<OperandGroup>();
            operandGroups.add(operandGroup);
            CalcFunctionOperand function = new CalcFunctionOperand();
            function.setOperandGroups(operandGroups);
            int functionOID = 0;
            switch (field.getDateTruncation()) {
                case DAY: {
                    functionOID = 219;
                    break;
                }
                case MONTH: {
                    functionOID = 204;
                    break;
                }
                case HOUR: {
                    functionOID = 220;
                    break;
                }
                case WEEK: {
                    functionOID = 218;
                    break;
                }
                case YEAR: {
                    functionOID = 206;
                }
            }
            DbJdbcDriverFunctionMapping mapping = this.mediator.getSqlFunctionMapping(functionOID);
            BeanSQLFunctionDefinition fct = mapping.getFunction();
            BeanSQLFctImplDefinition impl = mapping.getImplementation();
            ArrayList<TempField> fieldList = new ArrayList<TempField>();
            fieldList.add(tf);
            return this.getTempFieldSql(function, fct, impl, fieldList);
        }
        return tf;
    }
}

