/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.engine.multi;

import com.prelytis.dashboard.data.engine.CommandExpression;
import com.prelytis.dashboard.data.engine.ExecutionContext;
import com.prelytis.dashboard.data.engine.Field;
import com.prelytis.dashboard.data.engine.multi.CommandParameterMulti;
import com.prelytis.dashboard.data.engine.multi.EngineMulti;
import com.prelytis.dashboard.data.engine.multi.EngineWrapper;
import com.prelytis.dashboard.data.engine.multi.MultiCalcOperand;
import com.prelytis.dashboard.db.operation.Column;
import com.prelytis.dashboard.db.operation.ColumnAverage;
import com.prelytis.dashboard.db.operation.ColumnMedian;
import com.prelytis.dashboard.db.operation.ColumnSimple;
import com.prelytis.dashboard.db.operation.ColumnStdDev;
import com.prelytis.dashboard.db.operation.ColumnVariance;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.util.GuidFactory;
import com.prelytis.dashboard.value.data.AbstractBeanReportAvlField;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTable;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableField;
import com.prelytis.dashboard.value.data.BeanQuerySQLField;
import com.prelytis.dashboard.value.data.BeanReportAvlCalcField;
import com.prelytis.dashboard.value.data.BeanReportAvlField;
import com.prelytis.dashboard.value.data.FieldAgregation;
import com.prelytis.dashboard.value.query.BooleanExpression;
import com.prelytis.dashboard.value.query.CalcFunctionOperand;
import com.prelytis.dashboard.value.query.CalculatedOperand;
import com.prelytis.dashboard.value.query.ComparisonExpression;
import com.prelytis.dashboard.value.query.ConstantOperand;
import com.prelytis.dashboard.value.query.Expression;
import com.prelytis.dashboard.value.query.FieldOperand;
import com.prelytis.dashboard.value.query.ICalculatedOperand;
import com.prelytis.dashboard.value.query.IOperandGroup;
import com.prelytis.dashboard.value.query.IOperandGroupElement;
import com.prelytis.dashboard.value.query.LogicalExpression;
import com.prelytis.dashboard.value.query.Operand;
import com.prelytis.dashboard.value.query.OperandGroup;
import com.prelytis.dashboard.value.query.OperandGroupElement;
import com.prelytis.dashboard.value.query.PromptOperand;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.DateTruncation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class CommandFieldFilter {
    private static final int FUNCTION_OID_AND = 311;
    private static final int FUNCTION_OID_OR = 312;
    private static final int FUNCTION_OID_EQUAL = 403;
    private static final int FUNCTION_OID_DIFFERENT = 406;
    private static final int FUNCTION_OID_GREATER = 404;
    private static final int FUNCTION_OID_GREATER_OR_EQUAL = 405;
    private static final int FUNCTION_OID_SMALLER = 402;
    private static final int FUNCTION_OID_SMALLER_OR_EQUAL = 401;
    private static final int FUNCTION_OID_IN = 407;
    private static final int FUNCTION_OID_NOT_IN = 408;
    private final EngineMulti mediator;
    private final CommandParameterMulti commandParameter;
    private final CommandExpression commandExpression;
    private final Map<String, MultiCalcOperand> fieldMap = new HashMap<String, MultiCalcOperand>();
    private final Set<String> queryList = new HashSet<String>();
    private final List<Field> fieldList = new ArrayList<Field>();
    private final List<Field> fieldListH2 = new ArrayList<Field>();
    private Expression initialExpression;
    private final LogicalExpression expressionH2;
    private List<Column> columnList;

    public CommandFieldFilter(EngineMulti mediator, ExecutionContext context) {
        this.mediator = mediator;
        this.commandParameter = CommandParameterMulti.getInstance(context);
        this.commandExpression = new CommandExpression(context);
        this.expressionH2 = new LogicalExpression();
        this.expressionH2.setOperator(1);
    }

    void addField(Field field) throws DashboardException {
        this.addField(field.getName(), field.getAgregation());
        this.fieldList.add(field);
    }

    void setFilter(Expression expression) throws DashboardException {
        this.initialExpression = expression;
    }

    private MultiCalcOperand getFilterOperand(Expression expression) throws DashboardException {
        if (expression instanceof LogicalExpression) {
            LogicalExpression logicalExpression = (LogicalExpression)expression;
            boolean agregated = false;
            ArrayList<OperandGroup> operandGroups = new ArrayList<OperandGroup>();
            OperandGroup left = null;
            OperandGroup right = null;
            OperandGroup current = null;
            String queryName = null;
            for (Expression exp : logicalExpression.getExpressionList()) {
                MultiCalcOperand mco = this.getFilterOperand(exp);
                if (mco.isAgregated()) {
                    agregated = true;
                }
                queryName = this.getQueryName(queryName, mco.getQueryName());
                if (left == null) {
                    left = new OperandGroup();
                    left.setMinRepetition(1);
                    left.setMaxRepetition(1);
                    current = left;
                } else if (right == null) {
                    right = new OperandGroup();
                    right.setMinRepetition(1);
                    right.setMaxRepetition(-1);
                    current = right;
                }
                OperandGroupElement group = new OperandGroupElement();
                current.getElementList().add(group);
                List currentList = group.getOperands();
                currentList.add(mco);
            }
            operandGroups.add(left);
            operandGroups.add(right);
            CalcFunctionOperand operand = new CalcFunctionOperand();
            operand.setAgregated(agregated);
            operand.setOperandGroups(operandGroups);
            operand.setSQLFunctionOID(this.getFunctionOid(logicalExpression));
            MultiCalcOperand mco = new MultiCalcOperand();
            mco.setAgregated(agregated);
            mco.setExpectedDataType(DataType.BOOLEAN);
            mco.setResultDataType(DataType.BOOLEAN);
            mco.setOperand((Operand)operand);
            mco.setQueryName(queryName);
            mco.setName(GuidFactory.getInstance().generateGUID((Object)mco));
            return mco;
        }
        if (expression instanceof ComparisonExpression) {
            ComparisonExpression comparisonExpression = (ComparisonExpression)expression;
            boolean agregated = false;
            ArrayList<OperandGroup> operandGroups = new ArrayList<OperandGroup>();
            String queryName = null;
            MultiCalcOperand leftmco = this.addOperand(DataType.GENERIC_ANY, comparisonExpression.getLeftOperand(), FieldAgregation.AGREGATION_NONE);
            OperandGroup left = new OperandGroup();
            left.setMinRepetition(1);
            left.setMaxRepetition(1);
            OperandGroupElement leftgroup = new OperandGroupElement();
            left.getElementList().add(leftgroup);
            List leftOperands = leftgroup.getOperands();
            leftOperands.add(leftmco);
            if (leftmco.isAgregated()) {
                agregated = true;
            }
            queryName = this.getQueryName(queryName, leftmco.getQueryName());
            operandGroups.add(left);
            OperandGroup right = new OperandGroup();
            right.setMinRepetition(1);
            right.setMaxRepetition(1);
            operandGroups.add(right);
            int functionOid = this.getFunctionOid(comparisonExpression);
            Operand rightOperand = comparisonExpression.getRightOperand();
            if (rightOperand instanceof PromptOperand) {
                PromptOperand prompt = (PromptOperand)rightOperand;
                Object[] vs = prompt.getValues();
                if (vs == null || vs.length == 0) {
                    MultiCalcOperand rightmco = this.addConstantOperand(prompt.getDataType(), null);
                    OperandGroupElement rightgroup = new OperandGroupElement();
                    right.getElementList().add(rightgroup);
                    List rightOperands = rightgroup.getOperands();
                    rightOperands.add(rightmco);
                } else if (vs.length == 1) {
                    MultiCalcOperand rightmco = this.addConstantOperand(prompt.getDataType(), vs[0]);
                    OperandGroupElement rightgroup = new OperandGroupElement();
                    right.getElementList().add(rightgroup);
                    List rightOperands = rightgroup.getOperands();
                    rightOperands.add(rightmco);
                } else {
                    right.setMaxRepetition(-1);
                    switch (comparisonExpression.getOperator()) {
                        case 6: {
                            functionOid = 408;
                            break;
                        }
                        case 3: {
                            functionOid = 407;
                        }
                    }
                    boolean first = true;
                    for (Object v : vs) {
                        MultiCalcOperand rightmco = this.addConstantOperand(prompt.getDataType(), v);
                        if (first) {
                            leftOperands.add(rightmco);
                            first = false;
                            continue;
                        }
                        OperandGroupElement ng = new OperandGroupElement();
                        right.getElementList().add(ng);
                        List co = ng.getOperands();
                        co.add(rightmco);
                    }
                }
            } else {
                MultiCalcOperand rightmco = this.addOperand(leftmco.getResultDataType(), rightOperand, FieldAgregation.AGREGATION_NONE);
                OperandGroupElement rightgroup = new OperandGroupElement();
                right.getElementList().add(rightgroup);
                List rightOperands = rightgroup.getOperands();
                rightOperands.add(rightmco);
                if (rightmco.isAgregated()) {
                    agregated = true;
                }
                queryName = this.getQueryName(queryName, rightmco.getQueryName());
            }
            CalcFunctionOperand operand = new CalcFunctionOperand();
            operand.setAgregated(agregated);
            operand.setOperandGroups(operandGroups);
            operand.setSQLFunctionOID(functionOid);
            MultiCalcOperand mco = new MultiCalcOperand();
            mco.setAgregated(agregated);
            mco.setExpectedDataType(DataType.BOOLEAN);
            mco.setResultDataType(DataType.BOOLEAN);
            mco.setOperand((Operand)operand);
            mco.setQueryName(queryName);
            mco.setName(GuidFactory.getInstance().generateGUID((Object)mco));
            return mco;
        }
        throw this.mediator.getDashboardException("unknownExpression", null);
    }

    private MultiCalcOperand addConstantOperand(DataType dataType, Object value) {
        ConstantOperand constant = new ConstantOperand();
        constant.setDataType(dataType);
        constant.setValue(value);
        MultiCalcOperand mco = new MultiCalcOperand();
        mco.setExpectedDataType(constant.getDataType());
        mco.setResultDataType(constant.getDataType());
        mco.setQueryName(null);
        mco.setOperand((Operand)constant);
        mco.setName(GuidFactory.getInstance().generateGUID((Object)mco));
        this.fieldMap.put(mco.getName(), mco);
        return mco;
    }

    private String getQueryName(String queryName1, String queryName2) {
        if (queryName1 == null) {
            if ("".equals(queryName2)) {
                return "";
            }
            return queryName2;
        }
        if (queryName2 != null && !queryName1.equals(queryName2)) {
            return "";
        }
        return queryName1;
    }

    private MultiCalcOperand addField(String avlFieldName, FieldAgregation agregation) throws DashboardException {
        AbstractBeanReportAvlField avlField = this.commandParameter.getAvlField(avlFieldName);
        if (avlField instanceof BeanReportAvlCalcField) {
            BeanReportAvlCalcField fld = (BeanReportAvlCalcField)avlField;
            return this.addField(fld.getName(), agregation, fld.getOperand());
        }
        if (avlField instanceof BeanReportAvlField) {
            BeanReportAvlField fld = (BeanReportAvlField)avlField;
            return this.addField(fld, agregation);
        }
        throw this.mediator.getDashboardException("unknownFieldType", null);
    }

    private MultiCalcOperand addOperand(DataType datatype, Operand operand, FieldAgregation agregation) throws DashboardException {
        if (operand instanceof ConstantOperand) {
            ConstantOperand constant = (ConstantOperand)operand;
            MultiCalcOperand mco = new MultiCalcOperand();
            mco.setExpectedDataType(constant.getDataType());
            mco.setResultDataType(constant.getDataType());
            mco.setQueryName(null);
            ConstantOperand co = new ConstantOperand(constant.getDataType(), this.mediator.getValue(constant.getValue()));
            mco.setOperand((Operand)co);
            mco.setName(GuidFactory.getInstance().generateGUID((Object)mco));
            this.fieldMap.put(mco.getName(), mco);
            return mco;
        }
        if (operand instanceof FieldOperand) {
            FieldOperand field = (FieldOperand)operand;
            return this.addField(field.getField(), agregation);
        }
        if (operand instanceof CalcFunctionOperand) {
            EngineWrapper engine;
            CalcFunctionOperand function = (CalcFunctionOperand)operand;
            CalcFunctionOperand newFunction = new CalcFunctionOperand();
            newFunction.setAgregated(function.isAgregated());
            newFunction.getDescriptionMap().putAll(function.getDescriptionMap());
            newFunction.setSQLFunctionOID(function.getSQLFunctionOID());
            String queryName = null;
            List newGrpList = newFunction.getOperandGroups();
            for (IOperandGroup refGrp : function.getOperandGroups()) {
                OperandGroup newGrp = new OperandGroup();
                newGrp.setMaxRepetition(refGrp.getMaxRepetition());
                newGrp.setMinRepetition(refGrp.getMinRepetition());
                List newGrpEltList = newGrp.getElementList();
                for (IOperandGroupElement refElt : refGrp.getElementList()) {
                    OperandGroupElement newElt = new OperandGroupElement();
                    List newOpList = newElt.getOperands();
                    for (ICalculatedOperand refOp : refElt.getOperands()) {
                        MultiCalcOperand newOp = this.addField(GuidFactory.getInstance().generateGUID((Object)refOp), FieldAgregation.AGREGATION_NONE, refOp);
                        queryName = this.getQueryName(queryName, newOp.getQueryName());
                        newOpList.add(newOp);
                    }
                    newGrpEltList.add(newElt);
                }
                newGrpList.add(newGrp);
            }
            if (queryName != null && !"".equals(queryName) && !(engine = this.mediator.getEngine(queryName)).supportsFilter()) {
                queryName = "";
            }
            MultiCalcOperand mco = new MultiCalcOperand();
            mco.setExpectedDataType(datatype);
            mco.setResultDataType(datatype);
            mco.setQueryName(queryName);
            mco.setOperand((Operand)newFunction);
            mco.setName(GuidFactory.getInstance().generateGUID((Object)mco));
            this.fieldMap.put(mco.getName(), mco);
            return mco;
        }
        throw this.mediator.getDashboardException("unknownOperand", null);
    }

    private MultiCalcOperand addField(String name, FieldAgregation agregation, ICalculatedOperand calculatedOperand) throws DashboardException {
        MultiCalcOperand mco = this.addOperand(calculatedOperand.getResultDataType(), calculatedOperand.getOperand(), agregation);
        this.fieldMap.put(name, mco);
        return mco;
    }

    private MultiCalcOperand addField(BeanReportAvlField fld, FieldAgregation agregation) throws DashboardException {
        MultiCalcOperand resu = this.fieldMap.get(fld.getName());
        if (resu != null) {
            return resu;
        }
        String name = fld.getField().getName();
        BeanQueryDataStructureTableField dsField = this.commandParameter.getTableField(name, agregation);
        if (dsField == null) {
            throw this.mediator.getDashboardException("unknownField", new String[]{name});
        }
        BeanQueryDataStructureTable dsTable = dsField.getBeanQueryDataStructureTable();
        this.queryList.add(dsTable.getName());
        FieldOperand operand = new FieldOperand();
        operand.setField(fld.getName());
        operand.setId(fld.getId());
        operand.setDescriptionKey(fld.getDescriptionKey());
        MultiCalcOperand mco = new MultiCalcOperand();
        mco.setAgregated(fld.isAgregated());
        mco.setExpectedDataType(fld.getDataType());
        mco.setResultDataType(fld.getDataType());
        mco.setName(fld.getName());
        mco.setQueryName(dsTable.getName());
        mco.setOperand((Operand)operand);
        this.fieldMap.put(fld.getName(), mco);
        return mco;
    }

    void init() throws DashboardException {
        LogicalExpression filter = null;
        LogicalExpression contextualisation = this.commandParameter.getQueryFilter();
        if (contextualisation != null) {
            if (this.initialExpression != null) {
                contextualisation.getExpressionList().add(this.initialExpression);
                filter = contextualisation;
            } else {
                filter = contextualisation;
            }
        } else if (this.initialExpression != null) {
            filter = this.initialExpression;
        }
        Expression exp = this.commandExpression.getExpression((Expression)filter);
        MultiCalcOperand me = null;
        if (exp != null) {
            me = this.getFilterOperand(exp);
        }
        if (me != null) {
            this.addFilterEngine(me, true);
            this.addFilterH2(me, true);
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        block7: for (Field field : this.fieldList) {
            ColumnSimple cs;
            int c;
            MultiCalcOperand mco = this.fieldMap.get(field.getName());
            if (mco == null) continue;
            String fn = field.getName();
            switch (field.getAgregation()) {
                case AGREGATION_AVERAGE: {
                    this.addFieldEngine(fn, FieldAgregation.AGREGATION_SUM, mco);
                    this.addFieldEngine(fn, FieldAgregation.AGREGATION_COUNT, mco);
                    int pa1 = this.addFieldH2(this.mediator.getName(fn, FieldAgregation.AGREGATION_SUM), FieldAgregation.AGREGATION_SUM, mco);
                    int pa2 = this.addFieldH2(this.mediator.getName(fn, FieldAgregation.AGREGATION_COUNT), FieldAgregation.AGREGATION_SUM, mco);
                    ColumnAverage ca = new ColumnAverage();
                    ca.setSumCol(pa1);
                    ca.setCountCol(pa2);
                    columns.add((Column)ca);
                    continue block7;
                }
                case AGREGATION_MEDIAN: {
                    this.addFieldEngine(fn, FieldAgregation.AGREGATION_MIN, mco);
                    this.addFieldEngine(fn, FieldAgregation.AGREGATION_MAX, mco);
                    int pm1 = this.addFieldH2(this.mediator.getName(fn, FieldAgregation.AGREGATION_MIN), FieldAgregation.AGREGATION_MIN, mco);
                    int pm2 = this.addFieldH2(this.mediator.getName(fn, FieldAgregation.AGREGATION_MAX), FieldAgregation.AGREGATION_MAX, mco);
                    ColumnMedian cm = new ColumnMedian();
                    cm.setMinCol(pm1);
                    cm.setMaxCol(pm2);
                    columns.add((Column)cm);
                    continue block7;
                }
                case AGREGATION_STANDARD_DEVIATION: {
                    this.addFieldEngine(fn, FieldAgregation.AGREGATION_COUNT, mco);
                    this.addFieldEngine(fn, FieldAgregation.AGREGATION_SUM, mco);
                    this.addFieldEngine(fn, FieldAgregation.AGREGATION_SUM_SQUARRED, mco);
                    int psd1 = this.addFieldH2(this.mediator.getName(fn, FieldAgregation.AGREGATION_COUNT), FieldAgregation.AGREGATION_SUM, mco);
                    int psd2 = this.addFieldH2(this.mediator.getName(fn, FieldAgregation.AGREGATION_SUM), FieldAgregation.AGREGATION_SUM, mco);
                    int psd3 = this.addFieldH2(this.mediator.getName(fn, FieldAgregation.AGREGATION_SUM_SQUARRED), FieldAgregation.AGREGATION_SUM, mco);
                    ColumnStdDev csd = new ColumnStdDev();
                    csd.setCountCol(psd1);
                    csd.setSumCol(psd2);
                    csd.setSumSquareCol(psd3);
                    columns.add((Column)csd);
                    continue block7;
                }
                case AGREGATION_VARIANCE: {
                    this.addFieldEngine(fn, FieldAgregation.AGREGATION_COUNT, mco);
                    this.addFieldEngine(fn, FieldAgregation.AGREGATION_SUM, mco);
                    this.addFieldEngine(fn, FieldAgregation.AGREGATION_SUM_SQUARRED, mco);
                    int pv1 = this.addFieldH2(this.mediator.getName(fn, FieldAgregation.AGREGATION_COUNT), FieldAgregation.AGREGATION_SUM, mco);
                    int pv2 = this.addFieldH2(this.mediator.getName(fn, FieldAgregation.AGREGATION_SUM), FieldAgregation.AGREGATION_SUM, mco);
                    int pv3 = this.addFieldH2(this.mediator.getName(fn, FieldAgregation.AGREGATION_SUM_SQUARRED), FieldAgregation.AGREGATION_SUM, mco);
                    ColumnVariance cv = new ColumnVariance();
                    cv.setCountCol(pv1);
                    cv.setSumCol(pv2);
                    cv.setSumSquareCol(pv3);
                    columns.add((Column)cv);
                    continue block7;
                }
                case AGREGATION_COUNT: {
                    this.addFieldEngine(fn, field.getAgregation(), mco);
                    c = this.addFieldH2(this.mediator.getName(fn, field.getAgregation()), FieldAgregation.AGREGATION_SUM, mco);
                    cs = new ColumnSimple();
                    cs.setCol(c);
                    columns.add((Column)cs);
                    continue block7;
                }
            }
            this.addFieldEngine(fn, field.getAgregation(), mco);
            c = this.addFieldH2(this.mediator.getName(fn, field.getAgregation()), field.getAgregation(), mco);
            cs = new ColumnSimple();
            cs.setCol(c);
            columns.add((Column)cs);
        }
        this.columnList = columns;
    }

    private void addFieldEngine(String name, FieldAgregation agregation, MultiCalcOperand mco) throws DashboardException {
        Operand operand = mco.getOperand();
        if (operand instanceof FieldOperand) {
            FieldOperand mcf = (FieldOperand)operand;
            BeanQueryDataStructureTableField dsField = this.commandParameter.getTableField(mcf.getField(), agregation);
            BeanQueryDataStructureTable dsTable = dsField.getBeanQueryDataStructureTable();
            EngineWrapper engine = this.mediator.getEngine(dsTable);
            engine.addField(name, agregation, dsField);
        } else if (operand instanceof CalcFunctionOperand) {
            CalcFunctionOperand mcf = (CalcFunctionOperand)operand;
            if ("".equals(mco.getQueryName())) {
                for (IOperandGroup group : mcf.getOperandGroups()) {
                    for (IOperandGroupElement elt : group.getElementList()) {
                        for (ICalculatedOperand op : elt.getOperands()) {
                            MultiCalcOperand m = (MultiCalcOperand)op;
                            this.addFieldEngine(m.getName(), FieldAgregation.AGREGATION_NONE, m);
                        }
                    }
                }
            } else if (mco.getQueryName() != null) {
                EngineWrapper engine = this.mediator.getEngine(mco.getQueryName());
                BeanQueryDataStructureTableField dsField = this.commandParameter.addField(mco.getQueryName(), name, mco.getName(), mco.getResultDataType());
                BeanReportAvlCalcField avlCalcField = new BeanReportAvlCalcField();
                avlCalcField.setName(mco.getName());
                avlCalcField.setVisible(true);
                avlCalcField.setOperand(this.getCalcField(mco, agregation, false));
                ExecutionContext context = engine.getEngine().getContext();
                context.getFieldMap().put(avlCalcField.getName(), (AbstractBeanReportAvlField)avlCalcField);
                engine.addField(name, agregation, dsField);
            }
        } else if (!(operand instanceof ConstantOperand)) {
            throw this.mediator.getDashboardException("unknownExpression", null);
        }
    }

    private int addFieldH2(String name, FieldAgregation agregation, MultiCalcOperand mco) throws DashboardException {
        int pos = this.fieldListH2.size();
        Field field = new Field();
        field.setName(name);
        field.setAgregation(agregation);
        this.fieldListH2.add(field);
        Operand operand = mco.getOperand();
        if (operand instanceof FieldOperand) {
            FieldOperand mcf = (FieldOperand)operand;
            BeanQueryDataStructureTableField dsField = this.commandParameter.getTableField(mcf.getField(), agregation);
            BeanQueryDataStructureTable dsTable = dsField.getBeanQueryDataStructureTable();
            this.mediator.addFieldH2(dsTable, dsField.getSqlField(), dsField.getName(), agregation, dsField.getDescriptionKey(), dsField.getDataType(), dsField.getDateTruncation(), dsField.getFieldGroupName(), dsField.isActive(), dsField.getSize(), dsField.getDigits(), dsField.isNullable());
            BeanQuerySQLField sqlField = new BeanQuerySQLField();
            sqlField.setDataType(dsField.getDataType());
            sqlField.setName(dsField.getName());
            sqlField.setSqlField(dsField.getSqlField());
            BeanReportAvlField avlField = new BeanReportAvlField();
            avlField.setField(sqlField);
            avlField.setVisible(true);
            this.mediator.addAvlFieldH2(name, agregation, (AbstractBeanReportAvlField)avlField);
        } else if (operand instanceof CalcFunctionOperand) {
            if ("".equals(mco.getQueryName()) || mco.getQueryName() == null) {
                BeanReportAvlCalcField avlCalcField = new BeanReportAvlCalcField();
                avlCalcField.setName(mco.getName());
                avlCalcField.setVisible(true);
                avlCalcField.setOperand(this.getCalcField(mco, agregation, true));
                this.mediator.addAvlFieldH2(name, FieldAgregation.AGREGATION_NONE, (AbstractBeanReportAvlField)avlCalcField);
            } else {
                BeanQueryDataStructureTable dsTable = this.commandParameter.getTable(mco.getQueryName());
                this.mediator.addFieldH2(dsTable, mco.getName(), name, agregation, null, mco.getResultDataType(), DateTruncation.NONE, "Attribut", true, -1, -1, true);
                BeanQuerySQLField sqlField = new BeanQuerySQLField();
                sqlField.setDataType(mco.getResultDataType());
                sqlField.setName(name);
                sqlField.setSqlField(mco.getName());
                BeanReportAvlField avlField = new BeanReportAvlField();
                avlField.setField(sqlField);
                avlField.setVisible(true);
                this.mediator.addAvlFieldH2(name, agregation, (AbstractBeanReportAvlField)avlField);
            }
        } else if (operand instanceof ConstantOperand) {
            BeanReportAvlCalcField avlCalcField = new BeanReportAvlCalcField();
            avlCalcField.setName(mco.getName());
            avlCalcField.setVisible(true);
            avlCalcField.setOperand(this.getCalcField(mco, agregation, true));
            this.mediator.addAvlFieldH2(name, agregation, (AbstractBeanReportAvlField)avlCalcField);
        } else {
            throw new DashboardRuntimeException(ErrorCode.NOT_IMPLEMENTED);
        }
        return pos;
    }

    private ICalculatedOperand getCalcField(MultiCalcOperand mco, FieldAgregation agregation, boolean stop) throws DashboardException {
        Operand operand = mco.getOperand();
        if (stop && !"".equals(mco.getQueryName())) {
            CalculatedOperand calculatedOperand = new CalculatedOperand();
            calculatedOperand.setAgregated(mco.isAgregated());
            calculatedOperand.setExpectedDataType(mco.getExpectedDataType());
            calculatedOperand.setResultDataType(mco.getResultDataType());
            if (mco.getOperand() instanceof ConstantOperand) {
                calculatedOperand.setOperand(mco.getOperand());
            } else {
                FieldOperand fieldOperand = new FieldOperand();
                fieldOperand.setField(mco.getName());
                calculatedOperand.setOperand((Operand)fieldOperand);
            }
            return calculatedOperand;
        }
        if (operand instanceof FieldOperand) {
            FieldOperand fieldOperand = (FieldOperand)operand;
            BeanQueryDataStructureTableField dsField = this.commandParameter.getTableField(fieldOperand.getField(), agregation);
            BeanQueryDataStructureTable dsTable = dsField.getBeanQueryDataStructureTable();
            if (stop) {
                this.mediator.addFieldH2(dsTable, dsField.getSqlField(), dsField.getName(), agregation, dsField.getDescriptionKey(), dsField.getDataType(), dsField.getDateTruncation(), dsField.getFieldGroupName(), dsField.isActive(), dsField.getSize(), dsField.getDigits(), dsField.isNullable());
            } else {
                FieldOperand newOperand = new FieldOperand();
                newOperand.setDescriptionKey(fieldOperand.getDescriptionKey());
                newOperand.setField(dsField.getSqlField());
                fieldOperand = newOperand;
            }
            CalculatedOperand calculatedOperand = new CalculatedOperand();
            calculatedOperand.setAgregated(mco.isAgregated());
            calculatedOperand.setExpectedDataType(mco.getExpectedDataType());
            calculatedOperand.setOperand((Operand)fieldOperand);
            calculatedOperand.setResultDataType(mco.getResultDataType());
            return calculatedOperand;
        }
        if (operand instanceof CalcFunctionOperand) {
            CalcFunctionOperand mcf = (CalcFunctionOperand)operand;
            CalcFunctionOperand cfo = new CalcFunctionOperand();
            cfo.setSQLFunctionOID(mcf.getSQLFunctionOID());
            List ogList = cfo.getOperandGroups();
            for (IOperandGroup group : mcf.getOperandGroups()) {
                OperandGroup og = new OperandGroup();
                og.setMaxRepetition(group.getMaxRepetition());
                og.setMinRepetition(group.getMinRepetition());
                ogList.add(og);
                List ogeList = og.getElementList();
                for (IOperandGroupElement elt : group.getElementList()) {
                    OperandGroupElement oge = new OperandGroupElement();
                    ogeList.add(oge);
                    List opList = oge.getOperands();
                    for (ICalculatedOperand op : elt.getOperands()) {
                        opList.add(this.getCalcField((MultiCalcOperand)op, FieldAgregation.AGREGATION_NONE, stop));
                    }
                }
            }
            CalculatedOperand calculatedOperand = new CalculatedOperand();
            calculatedOperand.setAgregated(mco.isAgregated());
            calculatedOperand.setExpectedDataType(mco.getExpectedDataType());
            calculatedOperand.setResultDataType(mco.getResultDataType());
            calculatedOperand.setOperand((Operand)cfo);
            return calculatedOperand;
        }
        if (operand instanceof ConstantOperand) {
            CalculatedOperand calculatedOperand = new CalculatedOperand();
            calculatedOperand.setAgregated(mco.isAgregated());
            calculatedOperand.setExpectedDataType(mco.getExpectedDataType());
            calculatedOperand.setResultDataType(mco.getResultDataType());
            calculatedOperand.setOperand(operand);
            return calculatedOperand;
        }
        throw new DashboardRuntimeException(ErrorCode.NOT_IMPLEMENTED);
    }

    BeanQueryDataStructureTable getTable(String dsTableName) throws DashboardException {
        return this.commandParameter.getTable(dsTableName);
    }

    Expression getExpressionH2() {
        return this.expressionH2;
    }

    private int getFunctionOid(LogicalExpression expression) throws DashboardException {
        switch (expression.getOperator()) {
            case 1: {
                return 311;
            }
            case 2: {
                return 312;
            }
        }
        throw new DashboardRuntimeException(ErrorCode.NOT_IMPLEMENTED);
    }

    private int getFunctionOid(ComparisonExpression expression) throws DashboardException {
        switch (expression.getOperator()) {
            case 6: {
                return 406;
            }
            case 3: {
                return 403;
            }
            case 5: {
                return 404;
            }
            case 4: {
                return 405;
            }
            case 1: {
                return 402;
            }
            case 2: {
                return 401;
            }
        }
        throw this.mediator.getDashboardException("unknownExpression", null);
    }

    private void addFilterEngine(MultiCalcOperand mco, boolean where) throws DashboardException {
        Operand operand = mco.getOperand();
        if (operand instanceof FieldOperand) {
            if (!where) {
                this.addFieldEngine(mco.getName(), FieldAgregation.AGREGATION_NONE, mco);
            }
        } else if (operand instanceof CalcFunctionOperand) {
            CalcFunctionOperand mcf = (CalcFunctionOperand)operand;
            if ("".equals(mco.getQueryName())) {
                where = where && mcf.getSQLFunctionOID() != 312;
                for (IOperandGroup group : mcf.getOperandGroups()) {
                    for (IOperandGroupElement elt : group.getElementList()) {
                        for (ICalculatedOperand op : elt.getOperands()) {
                            MultiCalcOperand m = (MultiCalcOperand)op;
                            this.addFilterEngine(m, where);
                        }
                    }
                }
            } else if (mco.getQueryName() != null) {
                EngineWrapper engine = this.mediator.getEngine(mco.getQueryName());
                BeanReportAvlCalcField avlCalcField = new BeanReportAvlCalcField();
                avlCalcField.setName(mco.getName());
                avlCalcField.setVisible(true);
                avlCalcField.setOperand(this.getCalcField(mco, FieldAgregation.AGREGATION_NONE, false));
                ExecutionContext context = engine.getEngine().getContext();
                context.getFieldMap().put(avlCalcField.getName(), (AbstractBeanReportAvlField)avlCalcField);
                if (where && mco.getResultDataType() == DataType.BOOLEAN && mcf.getSQLFunctionOID() != 312) {
                    engine.addFilter(avlCalcField.getOperand());
                }
                this.addFieldEngine(mco.getName(), FieldAgregation.AGREGATION_NONE, mco);
            }
        } else if (!(operand instanceof ConstantOperand)) {
            throw this.mediator.getDashboardException("unknownExpression", null);
        }
    }

    private void addFilterH2(MultiCalcOperand mco, boolean where) throws DashboardException {
        Operand operand = mco.getOperand();
        if (!(operand instanceof FieldOperand)) {
            if (operand instanceof CalcFunctionOperand) {
                if ("".equals(mco.getQueryName()) || mco.getQueryName() == null) {
                    ICalculatedOperand co = this.getCalcField(mco, FieldAgregation.AGREGATION_NONE, true);
                    this.expressionH2.getExpressionList().add(new BooleanExpression(co.getOperand()));
                }
            } else {
                throw this.mediator.getDashboardException("unknownExpression", null);
            }
        }
    }

    public Collection<Field> getFieldListH2() {
        return this.fieldListH2;
    }

    public List<Column> getColumnList() {
        return this.columnList;
    }
}

