/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.engine.multi;

import com.prelytis.dashboard.data.engine.Engine;
import com.prelytis.dashboard.data.engine.Field;
import com.prelytis.dashboard.data.engine.ds.EngineDS;
import com.prelytis.dashboard.data.engine.multi.EngineMulti;
import com.prelytis.dashboard.value.data.AbstractBeanReportAvlField;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTable;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableField;
import com.prelytis.dashboard.value.data.BeanQuerySQLField;
import com.prelytis.dashboard.value.data.BeanQuerySQLFieldDataStructure;
import com.prelytis.dashboard.value.data.BeanReportAvlField;
import com.prelytis.dashboard.value.data.FieldAgregation;
import com.prelytis.dashboard.value.query.BooleanExpression;
import com.prelytis.dashboard.value.query.ICalculatedOperand;
import com.prelytis.dashboard.value.query.LogicalExpression;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.DateTruncation;
import com.prelytis.dashboard.value.util.FieldMetaData;
import java.util.HashMap;
import java.util.Map;

class EngineWrapper {
    private final EngineMulti mediator;
    private Engine engine;
    private final Map<Field, FieldMetaData> fieldSet;
    private LogicalExpression expression;
    private BeanQueryDataStructureTable dsTable;

    EngineWrapper(EngineMulti mediator) {
        this.mediator = mediator;
        this.fieldSet = new HashMap<Field, FieldMetaData>();
    }

    Engine getEngine() {
        return this.engine;
    }

    void setEngine(Engine engine) {
        this.engine = engine;
    }

    Map<Field, FieldMetaData> getFieldSet() {
        return this.fieldSet;
    }

    void addField(String name, FieldAgregation agregation, BeanQueryDataStructureTableField dsTableField) {
        String sql = dsTableField.getSqlField();
        DataType dataType = dsTableField.getDataType();
        Field field = new Field();
        field.setName(sql);
        field.setAgregation(agregation);
        if (!this.fieldSet.containsKey(field)) {
            String newSql = this.mediator.getName(sql, agregation);
            String newName = this.mediator.getName(name, agregation);
            this.mediator.addFieldH2(this.dsTable, newSql, newName, agregation, name, dataType, DateTruncation.NONE, "Attribut", dsTableField.isActive(), dsTableField.getSize(), dsTableField.getDigits(), dsTableField.isNullable());
            BeanQuerySQLFieldDataStructure sqlField = new BeanQuerySQLFieldDataStructure();
            sqlField.setBeanQueryDataStructureTableField(dsTableField);
            sqlField.setDataType(dataType);
            sqlField.setName(newName);
            sqlField.setSqlField(newSql);
            BeanReportAvlField avlField = new BeanReportAvlField();
            avlField.setField((BeanQuerySQLField)sqlField);
            this.mediator.addAvlFieldH2(name, agregation, (AbstractBeanReportAvlField)avlField);
            FieldMetaData fmd = DataType.isChar((DataType)dataType) ? new FieldMetaData(0, newSql, newSql, dataType, dsTableField.getSize()) : (DataType.isNumeric((DataType)dataType) ? new FieldMetaData(0, newSql, newSql, dataType, dsTableField.getSize(), dsTableField.getDigits()) : new FieldMetaData(0, newSql, newSql, dataType));
            this.fieldSet.put(field, fmd);
        }
    }

    LogicalExpression getExpression() {
        return this.expression;
    }

    BeanQueryDataStructureTable getDsTable() {
        return this.dsTable;
    }

    void setDsTable(BeanQueryDataStructureTable dsTable) {
        this.dsTable = dsTable;
    }

    boolean supportsFilter() {
        return this.engine instanceof EngineMulti || this.engine instanceof EngineDS;
    }

    public String toString() {
        if (this.engine == null) {
            return super.toString();
        }
        return new StringBuffer().append("EngineWrapper for ").append(this.engine.toString()).toString();
    }

    void addFilter(ICalculatedOperand mco) {
        if (this.expression == null) {
            this.expression = new LogicalExpression();
            this.expression.setOperator(1);
        }
        this.expression.getExpressionList().add(new BooleanExpression(mco.getOperand()));
    }
}

