/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.helper;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.JdbcDriverDao;
import com.prelytis.dashboard.dao.WorldDao;
import com.prelytis.dashboard.data.engine.AbstractEngine;
import com.prelytis.dashboard.data.engine.CommandParameter;
import com.prelytis.dashboard.data.engine.Engine;
import com.prelytis.dashboard.data.engine.ExecutionContext;
import com.prelytis.dashboard.data.engine.Field;
import com.prelytis.dashboard.data.engine.SortField;
import com.prelytis.dashboard.data.engine.ds.EngineDS;
import com.prelytis.dashboard.data.engine.multi.EngineMulti;
import com.prelytis.dashboard.data.engine.sql.EngineSql;
import com.prelytis.dashboard.data.engine.sql.EngineSql4Multi;
import com.prelytis.dashboard.db.QuerySQL;
import com.prelytis.dashboard.db.operation.Column;
import com.prelytis.dashboard.db.operation.ColumnConstant;
import com.prelytis.dashboard.db.operation.ColumnSimple;
import com.prelytis.dashboard.db.operation.Operation;
import com.prelytis.dashboard.db.operation.OperationCalculate;
import com.prelytis.dashboard.db.operation.OperationFinal;
import com.prelytis.dashboard.db.operation.OperationSelect;
import com.prelytis.dashboard.db.operation.OperationSort;
import com.prelytis.dashboard.db.operation.OperationUnion;
import com.prelytis.dashboard.db.operation.SortColumn;
import com.prelytis.dashboard.db.operator.AbstractOperator;
import com.prelytis.dashboard.db.operator.Operator;
import com.prelytis.dashboard.db.sql.Result;
import com.prelytis.dashboard.db.sql.ResultValue;
import com.prelytis.dashboard.db.sql.StreamedResult;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.db.value.ValueInteger;
import com.prelytis.dashboard.db.value.ValueNull;
import com.prelytis.dashboard.helper.DocumentCommandHelper;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.helper.TableHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.IQueryDefinition;
import com.prelytis.dashboard.model.helper.QueryHelper;
import com.prelytis.dashboard.util.GuidFactory;
import com.prelytis.dashboard.util.TreeNodeHelper;
import com.prelytis.dashboard.util.ValueHelper;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.AbstractBeanReportAvlField;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureFinal;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTable;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableKey;
import com.prelytis.dashboard.value.data.BeanQuerySQL;
import com.prelytis.dashboard.value.data.BeanQuerySQLField;
import com.prelytis.dashboard.value.data.BeanQueryStar;
import com.prelytis.dashboard.value.data.BeanReportAvlCalcField;
import com.prelytis.dashboard.value.data.BeanReportAvlField;
import com.prelytis.dashboard.value.data.BeanReportAvlGroup;
import com.prelytis.dashboard.value.data.BeanReportCrossTable;
import com.prelytis.dashboard.value.data.BeanReportCrossTableUsedField;
import com.prelytis.dashboard.value.data.BeanReportDataUsedField;
import com.prelytis.dashboard.value.data.BeanReportSection;
import com.prelytis.dashboard.value.data.BeanReportSortField;
import com.prelytis.dashboard.value.data.BeanReportStd;
import com.prelytis.dashboard.value.data.BeanReportStdBreak;
import com.prelytis.dashboard.value.data.BeanReportStdSection;
import com.prelytis.dashboard.value.data.BeanReportStdSortField;
import com.prelytis.dashboard.value.data.BeanReportStdUsedField;
import com.prelytis.dashboard.value.data.BeanReportUsedField;
import com.prelytis.dashboard.value.data.BeanWorldDefinition;
import com.prelytis.dashboard.value.data.FieldAgregation;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.data.SortOrder;
import com.prelytis.dashboard.value.query.CalcFunctionOperand;
import com.prelytis.dashboard.value.query.ComparisonExpression;
import com.prelytis.dashboard.value.query.ConstantOperand;
import com.prelytis.dashboard.value.query.Expression;
import com.prelytis.dashboard.value.query.FieldOperand;
import com.prelytis.dashboard.value.query.ICalculatedOperand;
import com.prelytis.dashboard.value.query.IOperandGroup;
import com.prelytis.dashboard.value.query.IOperandGroupElement;
import com.prelytis.dashboard.value.query.LogicalExpression;
import com.prelytis.dashboard.value.query.Operand;
import com.prelytis.dashboard.value.tree.TreeNode;
import com.prelytis.dashboard.value.tree.TreePath;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.FieldMetaData;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jfree.util.Log;

public class EngineHelper {
    private static final Logger log = LogManager.getLogger(EngineHelper.class);
    private final DaoFactory daoFactory;
    public static final String EVENT_ID_KEY = "EVENTID";

    private EngineHelper(DaoFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    public static final EngineHelper getInstance(DaoFactory daoFactory) {
        return new EngineHelper(daoFactory);
    }

    public ExecutionContext getExecutionContext(AbstractBeanReport report, ExpressionEvaluationData data, Map<String, ReportFilter> filterMap, boolean useFactTable) throws DashboardException {
        QueryHelper queryHelper = QueryHelper.getInstance(this.daoFactory);
        IQueryDefinition query = queryHelper.getFinal(report.getQueryName());
        return this.getExecutionContext(this.getFieldMap(report), query, data, filterMap, useFactTable);
    }

    public OperationFinal getOperation(BeanReportCrossTable ct, ExecutionContext context, TreeNode<BeanReportCrossTableUsedField> colTree, List<TreePath<BeanReportCrossTableUsedField>> colTreePath, TreeNode<BeanReportCrossTableUsedField> rowTree, List<TreePath<BeanReportCrossTableUsedField>> rowTreePath, List<BeanReportDataUsedField> dataFieldList) throws DashboardException {
        Operation op;
        int mdo = 0;
        for (TreePath<BeanReportCrossTableUsedField> treePath : rowTreePath) {
            mdo = Math.max(mdo, treePath.getPath().length);
        }
        int mda = 0;
        for (TreePath<BeanReportCrossTableUsedField> treePath : colTreePath) {
            mda = Math.max(mda, treePath.getPath().length);
        }
        int n = ct.getSectionList().size() + 2 + dataFieldList.size() + 2 * mda + 2 * mdo;
        ArrayList<OperationCalculate> arrayList = new ArrayList<OperationCalculate>();
        int o = 0;
        for (TreePath<BeanReportCrossTableUsedField> op3 : rowTreePath) {
            int a = 0;
            for (TreePath<BeanReportCrossTableUsedField> ap : colTreePath) {
                ArrayList<FieldMetaData> fmdList = new ArrayList<FieldMetaData>();
                ArrayList<Field> fl = new ArrayList<Field>();
                ArrayList<SortField> sfl = new ArrayList<SortField>();
                this.addSection(fl, sfl, fmdList, ct.getSectionList());
                this.addCols(fl, (List<FieldMetaData>)fmdList, dataFieldList);
                List<BeanReportCrossTableUsedField> al = this.getList(ap);
                this.addCols(fl, (List<FieldMetaData>)fmdList, al);
                List<BeanReportCrossTableUsedField> ol = this.getList(op3);
                this.addCols(fl, (List<FieldMetaData>)fmdList, ol);
                Engine engine = this.getEngine((AbstractBeanReport)ct, context, false);
                engine.setFieldList(fl);
                engine.setSortFieldList(sfl);
                LogicalExpression le = new LogicalExpression();
                List l = le.getExpressionList();
                this.addFilter(l, al);
                this.addFilter(l, ol);
                if (!l.isEmpty()) {
                    l.add(ct.getTopExpression());
                    engine.setFilter((Expression)le);
                } else {
                    engine.setFilter(ct.getTopExpression());
                }
                engine.setFilter(ct.getFilterList());
                Operation opData = engine.getOperation();
                ArrayList<Column> columnList = new ArrayList<Column>();
                ColumnConstant acs = new ColumnConstant();
                acs.setValue((Value)ValueInteger.valueOf((int)a));
                columnList.add((Column)acs);
                ColumnConstant ocs = new ColumnConstant();
                ocs.setValue((Value)ValueInteger.valueOf((int)o));
                columnList.add((Column)ocs);
                int c = 0;
                c = this.addCS(columnList, c, ct.getSectionList().size());
                c = this.addCS(columnList, c, dataFieldList.size());
                c = this.addCS(columnList, c, 2 * al.size());
                this.addNull(columnList, 2 * (mda - al.size()));
                c = this.addCS(columnList, c, 2 * ol.size());
                this.addNull(columnList, 2 * (mdo - ol.size()));
                OperationCalculate opCalc = new OperationCalculate();
                opCalc.setOperation(opData);
                opCalc.setColumnList(columnList);
                arrayList.add(opCalc);
                ++a;
            }
            ++o;
        }
        if (arrayList.size() == 1) {
            op = (Operation)arrayList.get(0);
        } else {
            OperationUnion union = new OperationUnion();
            union.setOperationList(arrayList);
            OperationSort os = new OperationSort();
            os.setCollator(Collator.getInstance(context.getData().getLocale()));
            os.setOperation((Operation)union);
            int c = 2;
            ArrayList<SortColumn> sortColList = new ArrayList<SortColumn>();
            for (BeanReportSection s : ct.getSectionList()) {
                SortColumn sc = new SortColumn();
                sc.setCol(c++);
                sc.setSortOrder(s.getSort());
                sortColList.add(sc);
            }
            SortColumn asc = new SortColumn();
            asc.setCol(0);
            asc.setSortOrder(SortOrder.SORT_ASCENDING);
            SortColumn osc = new SortColumn();
            osc.setCol(1);
            osc.setSortOrder(SortOrder.SORT_ASCENDING);
            sortColList.add(osc);
            sortColList.add(asc);
            os.setColumnList(sortColList);
            op = os;
        }
        OperationFinal operation = new OperationFinal();
        operation.setOperation(op);
        operation.setFieldMetaDataList(null);
        operation.setNbCols(n);
        operation.setMaxRows(context.getQuery().getMaxLines());
        return operation;
    }

    public OperationFinal getOperation(AbstractBeanReport report, ExecutionContext context) throws DashboardException {
        return this.getOperation(report, context, false);
    }

    public OperationFinal getOperation(AbstractBeanReport report, ExecutionContext context, boolean addKeyColumns) throws DashboardException {
        OperationCalculate opCalc;
        BeanQueryDataStructureFinal beanQueryDataStructureFinal;
        if (report.getReportType() == 2) {
            BeanReportCrossTable ct = (BeanReportCrossTable)report;
            TreeNodeHelper tnh = TreeNodeHelper.getInstance();
            TreeNode<BeanReportCrossTableUsedField> colTree = TableHelper.getVisible((TreeNode<BeanReportCrossTableUsedField>)ct.getColFieldList());
            List colTreePath = tnh.getPathList(colTree);
            TreeNode<BeanReportCrossTableUsedField> rowTree = TableHelper.getVisible((TreeNode<BeanReportCrossTableUsedField>)ct.getRowFieldList());
            List rowTreePath = tnh.getPathList(rowTree);
            List dataFieldList = ct.getDataFieldList();
            return this.getOperation(ct, context, colTree, colTreePath, rowTree, rowTreePath, dataFieldList);
        }
        ArrayList<FieldMetaData> fmdList = new ArrayList<FieldMetaData>();
        BeanReportStd std = (BeanReportStd)report;
        ArrayList<Field> fl = new ArrayList<Field>();
        ArrayList<SortField> sfl = new ArrayList<SortField>();
        this.addSection(fl, sfl, fmdList, std.getSectionList());
        HashMap<Integer, BeanReportStdUsedField> map = new HashMap<Integer, BeanReportStdUsedField>();
        for (BeanReportStdUsedField usedField : std.getFieldList()) {
            map.put(usedField.getId(), usedField);
        }
        this.addBreak(sfl, std.getBreakList(), map);
        if (addKeyColumns && DocumentCommandHelper.reportHasSelectedCommands(std)) {
            this.collectFieldsForCommandsExecution(std, context);
            this.collectCriteriaFields(std, DocumentCommandHelper.getCriteriaFields(std));
        }
        this.addCols(fl, fmdList, std.getFieldList());
        this.addSort(sfl, std.getSortFieldList(), map);
        Engine engine = this.getEngine((AbstractBeanReport)std, context, false);
        engine.setFieldList(fl);
        engine.setSortFieldList(sfl);
        engine.setFilter(report.getTopExpression());
        engine.setFilter(report.getFilterList());
        OperationFinal operation = new OperationFinal();
        operation.setOperation(engine.getOperation());
        operation.setFieldMetaDataList(fmdList);
        operation.setNbCols(fmdList.size());
        operation.setMaxRows(context.getQuery().getMaxLines());
        if (context.getQuery() instanceof BeanQueryDataStructureFinal && (beanQueryDataStructureFinal = (BeanQueryDataStructureFinal)context.getQuery()).isUpperCaseQuery() && operation.getOperation() instanceof OperationCalculate && (opCalc = (OperationCalculate)operation.getOperation()).getOperation() instanceof OperationSelect) {
            OperationSelect opSel = (OperationSelect)opCalc.getOperation();
            QuerySQL querySQL = opSel.getQuerySQL();
            querySQL.setQueryString(querySQL.getQueryString().toUpperCase());
        }
        return operation;
    }

    private void collectFieldsForCommandsExecution(BeanReportStd report, ExecutionContext context) throws DashboardException {
        String queryName = report.getQueryName();
        IQueryDefinition queryDefinition = QueryHelper.getInstance(this.daoFactory).getFinal(queryName);
        boolean hasKeyField = false;
        if (queryDefinition instanceof BeanQueryDataStructureFinal) {
            String eventIdFullName;
            BeanQueryDataStructureFinal queryDSF = (BeanQueryDataStructureFinal)queryDefinition;
            List tableKeysList = queryDSF.getTableFact().getDsTableKeyList();
            String tableName = queryDSF.getTableFact().getName();
            for (BeanQueryDataStructureTableKey tableKey : tableKeysList) {
                for (String tableKeyField : tableKey.getFieldList()) {
                    String keyFieldFullName = tableName + "." + tableKeyField;
                    hasKeyField = this.collectKeyField(report, keyFieldFullName) || hasKeyField;
                }
            }
            if (!hasKeyField && !(hasKeyField = this.collectKeyField(report, eventIdFullName = tableName + "." + EVENT_ID_KEY))) {
                eventIdFullName = EVENT_ID_KEY;
                hasKeyField = this.collectKeyField(report, eventIdFullName);
            }
        } else if (queryDefinition instanceof BeanQuerySQL) {
            for (BeanReportAvlGroup availableGroup : report.getAvlGroupList()) {
                for (AbstractBeanReportAvlField availableField : availableGroup.getFields()) {
                    this.collectField(report, availableField.getName(), context);
                }
            }
        }
    }

    protected boolean collectKeyField(BeanReportStd reportStd, String fieldName) {
        boolean collected;
        BeanReportStdUsedField field = this.collectField(reportStd, fieldName);
        boolean bl = collected = field != null;
        if (collected) {
            field.setKey(true);
        }
        return collected;
    }

    protected void collectCriteriaFields(BeanReportStd reportStd, Collection<String> criteriaFieldNames) throws DashboardException {
        for (String criteriaFieldName : criteriaFieldNames) {
            BeanReportStdUsedField criteriaField = this.collectField(reportStd, criteriaFieldName);
            if (criteriaField == null) continue;
            criteriaField.setCriteriaField(true);
        }
    }

    private BeanReportStdUsedField collectField(BeanReportStd reportStd, String fieldName) {
        return this.collectField(reportStd, fieldName, null);
    }

    private BeanReportStdUsedField collectField(BeanReportStd reportStd, String fieldName, ExecutionContext context) {
        AbstractBeanReportAvlField reportAvlField;
        BeanReportStdUsedField usedField = EngineHelper.findBeanReportUsedField((AbstractBeanReport)reportStd, fieldName);
        if (usedField == null && (reportAvlField = EngineHelper.findBeanReportAvlField((AbstractBeanReport)reportStd, fieldName)) != null) {
            usedField = new BeanReportStdUsedField();
            usedField.setName(reportAvlField.getName());
            usedField.setField(reportAvlField);
            usedField.setVisible(false);
            if (context != null) {
                String descriptionKey = GuidFactory.getInstance().generateGUID((Object)usedField);
                usedField.setDescriptionKey(descriptionKey);
                usedField.getDescriptionMap().put(context.getData().getLocale(), reportAvlField.getName());
            }
            reportStd.getFieldList().add(usedField);
        }
        return usedField;
    }

    public OperationFinal getOperationForCommandExecution(AbstractBeanReport report, ExecutionContext context, String[] keyNames, String[] keyValues) throws DashboardException {
        if (report.getReportType() == 0) {
            ArrayList<FieldMetaData> fmdList = new ArrayList<FieldMetaData>();
            BeanReportStd std = (BeanReportStd)report;
            ArrayList<Field> fields = new ArrayList<Field>();
            ArrayList<SortField> sfl = new ArrayList<SortField>();
            this.addSection(fields, sfl, fmdList, std.getSectionList());
            HashMap<Integer, BeanReportStdUsedField> map = new HashMap<Integer, BeanReportStdUsedField>();
            for (BeanReportStdUsedField usedField : std.getFieldList()) {
                int usedKey = usedField.getId();
                if (map.containsKey(usedKey)) continue;
                map.put(usedKey, usedField);
            }
            this.addBreak(sfl, std.getBreakList(), map);
            this.collectAllFields(report, context);
            this.addCols(fields, fmdList, std.getFieldList());
            this.addSort(sfl, std.getSortFieldList(), map);
            Engine engine = this.getEngine((AbstractBeanReport)std, context, false);
            engine.setFieldList(fields);
            engine.setSortFieldList(sfl);
            Expression filterExpression = this.buildKeyFilterExpression(report, keyNames, keyValues);
            engine.setFilter(filterExpression);
            engine.setFilter(report.getFilterList());
            OperationFinal operation = new OperationFinal();
            operation.setOperation(engine.getOperation());
            operation.setFieldMetaDataList(fmdList);
            operation.setNbCols(fmdList.size());
            if (context != null && context.getQuery() != null) {
                operation.setMaxRows(context.getQuery().getMaxLines());
            }
            return operation;
        }
        throw new DashboardException("Commands can be executed only on standard reports.");
    }

    public void collectAllFields(AbstractBeanReport report, ExecutionContext context) throws DashboardException {
        BeanReportStd reportStd = (BeanReportStd)report;
        List usedFieldsList = reportStd.getFieldList();
        IQueryDefinition queryDefinition = QueryHelper.getInstance(this.daoFactory).getFinal(reportStd.getQueryName());
        if (queryDefinition instanceof BeanQueryDataStructureFinal) {
            for (BeanReportAvlGroup avlGroup : report.getAvlGroupList()) {
                for (AbstractBeanReportAvlField reportAvlField : avlGroup.getFields()) {
                    boolean notFound = true;
                    for (BeanReportStdUsedField field : usedFieldsList) {
                        if (!field.getField().getName().equals(reportAvlField.getName())) continue;
                        notFound = false;
                        break;
                    }
                    if (!notFound) continue;
                    BeanReportStdUsedField newStdUsedField = new BeanReportStdUsedField();
                    newStdUsedField.setField(reportAvlField);
                    newStdUsedField.setVisible(false);
                    usedFieldsList.add(newStdUsedField);
                }
            }
        }
    }

    private Expression buildKeyFilterExpression(AbstractBeanReport report, String[] keyNames, String[] keyValues) throws DashboardException {
        Object fullFilterExp = null;
        for (int i = 0; i < keyNames.length; ++i) {
            AbstractBeanReportAvlField keyFieldBean = EngineHelper.findBeanReportAvlField(report, keyNames[i]);
            ComparisonExpression keyExp = EngineHelper.createExpression(keyFieldBean, 3, keyValues[i]);
            fullFilterExp = fullFilterExp == null ? keyExp : new LogicalExpression((Expression)fullFilterExp, 1, (Expression)keyExp);
        }
        return fullFilterExp;
    }

    public static AbstractBeanReportAvlField findBeanReportAvlField(AbstractBeanReport report, String field) {
        for (BeanReportAvlGroup reportAvlGroup : report.getAvlGroupList()) {
            for (AbstractBeanReportAvlField reportAvlField : reportAvlGroup.getFields()) {
                String fieldName = reportAvlField.getName();
                if (!fieldName.equalsIgnoreCase(field) && !DocumentCommandHelper.getSimpleFieldName(fieldName).equalsIgnoreCase(field)) continue;
                return reportAvlField;
            }
        }
        return null;
    }

    public static BeanReportStdUsedField findBeanReportUsedField(AbstractBeanReport report, String field) {
        if (report instanceof BeanReportStd) {
            for (BeanReportStdUsedField reportUsedField : ((BeanReportStd)report).getFieldList()) {
                String fieldName = reportUsedField.getField().getName();
                if (!fieldName.equalsIgnoreCase(field) && !DocumentCommandHelper.getSimpleFieldName(fieldName).equalsIgnoreCase(field)) continue;
                return reportUsedField;
            }
        }
        return null;
    }

    public static ComparisonExpression createExpression(AbstractBeanReportAvlField leftField, int operator, String stringValue) throws DashboardException {
        Object value = null;
        try {
            value = ValueHelper.getInstance((Locale)Locale.ENGLISH).parse(leftField.getDataType(), stringValue);
        }
        catch (Exception e) {
            Log.debug((Object)e);
            throw new DashboardException(e.getMessage());
        }
        ConstantOperand constantOperand = new ConstantOperand(leftField.getDataType(), value);
        FieldOperand leftOperand = new FieldOperand();
        leftOperand.setField(leftField.getName());
        leftOperand.setId(leftField.getId());
        leftOperand.setDescriptionKey(leftField.getDescriptionKey());
        return new ComparisonExpression((Operand)leftOperand, operator, (Operand)constantOperand);
    }

    private void addFilter(List<Expression> l, List<BeanReportCrossTableUsedField> list) {
        for (BeanReportCrossTableUsedField usedField : list) {
            if (usedField.getMode() != BeanReportCrossTableUsedField.Mode.SELECTED) continue;
            FieldOperand fld = new FieldOperand();
            fld.setDescriptionKey(usedField.getDescriptionKey());
            fld.setField(usedField.getField().getName());
            ConstantOperand co = new ConstantOperand(usedField.getDataType(), usedField.getSelectedValue());
            ComparisonExpression ce = new ComparisonExpression((Operand)fld, 3, (Operand)co);
            l.add((Expression)ce);
        }
    }

    private int addCS(List<Column> columnList, int cpt, int nb) {
        int c = cpt;
        for (int i = 0; i < nb; ++i) {
            ColumnSimple cs = new ColumnSimple();
            cs.setCol(c++);
            columnList.add((Column)cs);
        }
        return c;
    }

    private void addNull(List<Column> columnList, int nb) {
        ColumnConstant cs = new ColumnConstant();
        cs.setValue((Value)ValueNull.STRING);
        for (int i = 0; i < nb; ++i) {
            columnList.add((Column)cs);
        }
    }

    public Result getResult(OperationFinal operation) throws DashboardException {
        Operator operator = AbstractOperator.getOperator((Operation)operation.getOperation());
        int maxRows = operation.getMaxRows();
        if (operation.isStreamed()) {
            return new StreamedResult(operator, operation.getNbCols(), operation.getFieldMetaDataList(), maxRows);
        }
        ArrayList<Value[]> resultList = new ArrayList<Value[]>();
        try {
            operator.init();
            while (operator.next()) {
                resultList.add(operator.getRow());
            }
            boolean ignoredData = operator.isIgnoredData();
            ResultValue resultValue = new ResultValue(resultList, operation.getNbCols(), operation.getFieldMetaDataList(), maxRows, ignoredData);
            return resultValue;
        }
        catch (DashboardException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DashboardException((Throwable)e);
        }
        finally {
            operator.close();
        }
    }

    private List<BeanReportCrossTableUsedField> getList(TreePath<BeanReportCrossTableUsedField> treePath) {
        ArrayList<BeanReportCrossTableUsedField> list = new ArrayList<BeanReportCrossTableUsedField>();
        block4: for (TreeNode n : treePath.getPath()) {
            if (n.getUserObject() == null) continue;
            BeanReportCrossTableUsedField usedField = (BeanReportCrossTableUsedField)n.getUserObject();
            switch (usedField.getMode()) {
                case GROUPED: {
                    continue block4;
                }
                case ALL: 
                case ALL_NON_EMPTY: 
                case SELECTED: {
                    list.add(usedField);
                }
            }
        }
        return list;
    }

    public Engine getEngine(IQueryDefinition query, ExpressionEvaluationData data, Map<String, ReportFilter> filterMap, boolean useFactTable) throws DashboardException {
        HashMap<String, AbstractBeanReportAvlField> fieldMap = new HashMap<String, AbstractBeanReportAvlField>();
        int cpt = 0;
        for (BeanQuerySQLField field : query.getBeanQuerySQLFieldList()) {
            BeanReportAvlField avlField = new BeanReportAvlField();
            avlField.setField(field);
            avlField.setId(cpt++);
            avlField.setVisible(true);
            fieldMap.put(field.getName(), (AbstractBeanReportAvlField)avlField);
        }
        ExecutionContext context = this.getExecutionContext(fieldMap, query, data, filterMap, useFactTable);
        return this.getEngine(null, context, true);
    }

    public Result getResult(BeanQuerySQL query, ExpressionEvaluationData data, Map<String, ReportFilter> filterMap) throws DashboardException {
        return this.getResult(query, data, filterMap, false, query.getMaxLines());
    }

    public Result getResult(BeanQuerySQL query, ExpressionEvaluationData data, Map<String, ReportFilter> filterMap, boolean streamed, int maxRows) throws DashboardException {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        HashMap<String, AbstractBeanReportAvlField> fieldMap = new HashMap<String, AbstractBeanReportAvlField>();
        ArrayList<FieldMetaData> fmdList = new ArrayList<FieldMetaData>();
        int cpt = 0;
        for (BeanQuerySQLField field : query.getBeanQuerySQLFieldList()) {
            BeanReportAvlField avlField = new BeanReportAvlField();
            avlField.setField(field);
            avlField.setId(cpt++);
            avlField.setVisible(true);
            fieldMap.put(field.getName(), (AbstractBeanReportAvlField)avlField);
            Field f = new Field();
            f.setAgregation(FieldAgregation.AGREGATION_NONE);
            f.setName(field.getName());
            fieldList.add(f);
            FieldMetaData fmd = DataType.isChar((DataType)field.getDataType()) ? new FieldMetaData(fmdList.size(), field.getName(), "F" + cpt, field.getDataType(), field.getSize()) : (DataType.isNumeric((DataType)field.getDataType()) ? new FieldMetaData(fmdList.size(), field.getName(), "F" + cpt, field.getDataType(), field.getSize(), field.getDigits()) : new FieldMetaData(fmdList.size(), field.getName(), "F" + cpt, field.getDataType()));
            fmd.setNullable(field.isNullable());
            fmdList.add(fmd);
        }
        ExecutionContext context = this.getExecutionContext(fieldMap, (IQueryDefinition)query, data, filterMap, true);
        EngineSql engine = new EngineSql(context);
        engine.setFieldList(fieldList);
        OperationFinal operation = new OperationFinal();
        operation.setOperation(engine.getOperation());
        operation.setFieldMetaDataList(fmdList);
        operation.setNbCols(fmdList.size());
        operation.setMaxRows(maxRows);
        operation.setStreamed(streamed);
        return this.getResult(operation);
    }

    private void addBreak(List<SortField> sfl, List<BeanReportStdBreak> breakList, Map<Integer, BeanReportStdUsedField> map) throws DashboardException {
        for (int i = breakList.size() - 1; i >= 0; --i) {
            BeanReportStdBreak b = breakList.get(i);
            BeanReportStdUsedField usedField = map.get(b.getColId());
            if (usedField == null) {
                log.warn((Object)"Break ignored");
                continue;
            }
            AbstractBeanReportAvlField avlField = usedField.getField();
            this.addSort(sfl, this.getField(avlField.getName(), usedField.getAgregation(), false, usedField.isKey()), b.getSort());
        }
    }

    private void addSort(List<SortField> sfl, List<BeanReportStdSortField> sortFieldList, Map<Integer, BeanReportStdUsedField> map) throws DashboardException {
        for (BeanReportStdSortField sortField : sortFieldList) {
            BeanReportStdUsedField usedField = map.get(sortField.getColId());
            if (usedField == null) {
                log.warn((Object)"Sort ignored");
                continue;
            }
            AbstractBeanReportAvlField avlField = usedField.getField();
            this.addSort(sfl, this.getField(avlField.getName(), usedField.getAgregation(), false, usedField.isKey()), sortField.getSortOrder());
        }
    }

    private void addCols(List<Field> fl, List<FieldMetaData> fmdList, List<? extends BeanReportUsedField> fieldList) throws DashboardException {
        for (int i = 0; i < fieldList.size(); ++i) {
            BeanReportUsedField usedField = fieldList.get(i);
            FieldAgregation agregation = FieldAgregation.AGREGATION_NONE;
            boolean distinctValues = false;
            boolean isKey = usedField.isKey();
            if (usedField instanceof BeanReportStdUsedField) {
                BeanReportStdUsedField stdUsedField = (BeanReportStdUsedField)usedField;
                agregation = stdUsedField.getAgregation();
                distinctValues = stdUsedField.isDistinctValues();
            } else if (usedField instanceof BeanReportDataUsedField) {
                BeanReportDataUsedField dataUsedField = (BeanReportDataUsedField)usedField;
                agregation = dataUsedField.getAgregation();
                distinctValues = dataUsedField.isDistinctValues();
            }
            AbstractBeanReportAvlField avlField = usedField.getField();
            fl.add(this.getField(avlField.getName(), agregation, distinctValues, isKey));
            FieldMetaData fmd = new FieldMetaData(fmdList.size(), avlField.getName(), "F" + i, usedField.getDataType());
            fmd.setKey(isKey);
            fmd.setCriteriaField(usedField.isCriteriaField());
            fmdList.add(fmd);
            if (!(usedField instanceof BeanReportCrossTableUsedField)) continue;
            BeanReportCrossTableUsedField ct = (BeanReportCrossTableUsedField)usedField;
            BeanReportSortField sortField = ct.getSortField();
            AbstractBeanReportAvlField savlField = null;
            if (sortField != null) {
                savlField = sortField.getField();
            }
            if (savlField != null && sortField != null && sortField.getAgregationSort() != null) {
                fl.add(this.getField(savlField.getName(), sortField.getAgregationSort(), false, isKey));
                fmd = new FieldMetaData(fmdList.size(), savlField.getName(), "SF" + i, usedField.getDataType());
                fmd.setKey(usedField.isKey());
            } else {
                fl.add(this.getField(avlField.getName(), agregation, false, isKey));
            }
            fmdList.add(fmd);
        }
    }

    private int addSection(List<Field> fl, List<SortField> sfl, List<FieldMetaData> fmdList, List<? extends BeanReportSection> sectionList) throws DashboardException {
        int cpt = 0;
        for (BeanReportSection beanReportSection : sectionList) {
            AbstractBeanReportAvlField avlField = beanReportSection.getField();
            if (avlField == null) {
                throw ExceptionHelper.getInstance(Locale.ENGLISH).createDashboardException("unknownFieldForSection", null, null);
            }
            Field field = this.getField(avlField.getName(), FieldAgregation.AGREGATION_NONE, false, false);
            this.addField(fl, field);
            this.addSort(sfl, field, beanReportSection.getSort());
            FieldMetaData fmd = new FieldMetaData(fmdList.size(), "S" + cpt, avlField.getName(), avlField.getDataType());
            fmdList.add(fmd);
        }
        return cpt;
    }

    private void addField(Collection<Field> fieldList, Field field) throws DashboardException {
        fieldList.add(field);
    }

    private void addSort(List<SortField> sortFieldList, Field field, SortOrder sortOrder) throws DashboardException {
        SortField sortField = new SortField();
        sortField.setField(field);
        sortField.setSortOrder(sortOrder);
        if (!sortFieldList.contains(sortField)) {
            sortFieldList.add(sortField);
        }
    }

    private Field getField(String avlFieldName, FieldAgregation agregation, boolean distinctValues, boolean isKey) {
        Field field = new Field();
        field.setName(avlFieldName);
        field.setAgregation(agregation);
        field.setDistinctValues(distinctValues);
        field.setKey(isKey);
        return field;
    }

    protected Engine getEngine(AbstractBeanReport report, ExecutionContext context, boolean fromMulti) throws DashboardException {
        AbstractEngine result = null;
        switch (context.getQuery().getQueryType()) {
            case 3: {
                EngineMulti multi = new EngineMulti(this.daoFactory, context);
                multi.setContextH2(this.getContextH2(context));
                result = multi;
                break;
            }
            case 1: {
                if (fromMulti) {
                    EngineSql4Multi sql = new EngineSql4Multi(context);
                    sql.setContextH2(this.getContextH2(context));
                    result = sql;
                    break;
                }
                result = new EngineSql(context);
                break;
            }
            case 2: {
                if (!context.isUseFactTable() && report instanceof BeanReportStd) {
                    CommandParameter cp = CommandParameter.getInstance(context);
                    result = EngineDS.getInstance(context, cp, this.getTable(cp, (BeanReportStd)report));
                    break;
                }
                result = EngineDS.getInstance(context);
            }
        }
        if (result != null) {
            if (report != null) {
                result.setForceGroupBy(report.getForceGroupBy());
            }
            return result;
        }
        throw ExceptionHelper.getInstance(Locale.ENGLISH).createDashboardException("unknownQueryType", null, null);
    }

    protected ExecutionContext getContextH2(ExecutionContext orig) throws DashboardException {
        ExecutionContext context = new ExecutionContext();
        context.setData(orig.getData());
        BeanWorldDefinition worldH2 = new BeanWorldDefinition();
        worldH2.setDriverOID(16);
        worldH2.setUrl("jdbc:prelytis:h2:mem:");
        context.setWorld(worldH2);
        this.setDriverInfo(context, worldH2.getDriverOID());
        return context;
    }

    private Map<String, AbstractBeanReportAvlField> getFieldMap(AbstractBeanReport report) {
        HashMap<String, AbstractBeanReportAvlField> fieldMap = new HashMap<String, AbstractBeanReportAvlField>();
        for (BeanReportAvlGroup group : report.getAvlGroupList()) {
            for (AbstractBeanReportAvlField avlField : group.getFields()) {
                fieldMap.put(avlField.getName(), avlField);
            }
        }
        return fieldMap;
    }

    private ExecutionContext getExecutionContext(Map<String, AbstractBeanReportAvlField> fieldMap, IQueryDefinition query, ExpressionEvaluationData data, Map<String, ReportFilter> filterMap, boolean useFactTable) throws DashboardException {
        ExecutionContext context = new ExecutionContext();
        context.setData(data);
        context.setFieldMap(fieldMap);
        context.setFilterMap(filterMap);
        context.setQuery(query);
        context.setUseFactTable(useFactTable);
        switch (query.getQueryType()) {
            case 1: 
            case 2: {
                WorldDao worldDao = this.daoFactory.getWorldDao();
                BeanWorldDefinition world = (BeanWorldDefinition)worldDao.getDefinition(query.getWorldOID());
                context.setWorld(world);
                this.setDriverInfo(context, world.getDriverOID());
                break;
            }
        }
        return context;
    }

    private void setDriverInfo(ExecutionContext context, int driverOid) throws DashboardException {
        JdbcDriverDao driverDao = this.daoFactory.getJdbcDriverDao();
        context.setDriver(driverDao.getDriver(driverOid));
    }

    protected BeanQueryDataStructureTable getTable(CommandParameter cp, BeanReportStd report) {
        BeanQueryStar q = cp.getQuery();
        BeanQueryDataStructureTable t = null;
        for (BeanReportStdSection s : report.getSectionList()) {
            if ((t = this.getTable(cp, t, s.getField())) != q.getTableFact()) continue;
            return t;
        }
        for (BeanReportStdUsedField f : report.getFieldList()) {
            if ((t = this.getTable(cp, t, f.getField())) != q.getTableFact()) continue;
            return t;
        }
        t = this.getTable(cp, t, report.getTopExpression());
        return t;
    }

    private BeanQueryDataStructureTable getTable(CommandParameter cp, BeanQueryDataStructureTable t, AbstractBeanReportAvlField field) {
        if (field instanceof BeanReportAvlField) {
            BeanReportAvlField f = (BeanReportAvlField)field;
            return cp.getParentTable(t, f.getField().getName());
        }
        if (field instanceof BeanReportAvlCalcField) {
            BeanReportAvlCalcField f = (BeanReportAvlCalcField)field;
            return this.getTable(cp, t, f.getOperand());
        }
        return t;
    }

    private BeanQueryDataStructureTable getTable(CommandParameter cp, BeanQueryDataStructureTable t, ICalculatedOperand operand) {
        return this.getTable(cp, t, operand.getOperand());
    }

    private BeanQueryDataStructureTable getTable(CommandParameter cp, BeanQueryDataStructureTable t, Operand operand) {
        if (operand instanceof CalcFunctionOperand) {
            CalcFunctionOperand fct = (CalcFunctionOperand)operand;
            for (IOperandGroup grp : fct.getOperandGroups()) {
                for (IOperandGroupElement elt : grp.getElementList()) {
                    for (ICalculatedOperand op : elt.getOperands()) {
                        t = this.getTable(cp, t, op);
                    }
                }
            }
            return t;
        }
        if (operand instanceof FieldOperand) {
            FieldOperand fld = (FieldOperand)operand;
            AbstractBeanReportAvlField avlField = cp.getAvlField(fld.getField());
            if (avlField == null) {
                throw new NullPointerException(fld.getField() + " is not found in available field list");
            }
            return this.getTable(cp, t, avlField);
        }
        return t;
    }

    private BeanQueryDataStructureTable getTable(CommandParameter cp, BeanQueryDataStructureTable t, Expression e) {
        if (e instanceof LogicalExpression) {
            LogicalExpression le = (LogicalExpression)e;
            for (Expression ce : le.getExpressionList()) {
                t = this.getTable(cp, t, ce);
            }
        } else if (e instanceof ComparisonExpression) {
            ComparisonExpression ce = (ComparisonExpression)e;
            return this.getTable(cp, this.getTable(cp, t, ce.getLeftOperand()), ce.getRightOperand());
        }
        return t;
    }
}

