/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.helper;

import com.prelytis.dashboard.db.operation.Operation;
import com.prelytis.dashboard.db.operation.OperationAgregate;
import com.prelytis.dashboard.db.operation.OperationCalculate;
import com.prelytis.dashboard.db.operation.OperationFilter;
import com.prelytis.dashboard.db.operation.OperationH2;
import com.prelytis.dashboard.db.operation.OperationJoin;
import com.prelytis.dashboard.db.operation.OperationSelect;
import com.prelytis.dashboard.db.operation.OperationSort;
import com.prelytis.dashboard.value.tree.DefaultMutableTreeNode;
import com.prelytis.dashboard.value.tree.TreeNode;
import java.util.ArrayList;

public class ExecutionPlanHelper {
    private Operation operation;

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public TreeNode<String> getTreePlan() {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode();
        node.setChildren(new ArrayList());
        this.fill((TreeNode<String>)node, this.operation);
        return node;
    }

    public String getPlan() {
        StringBuffer sb = new StringBuffer();
        this.append(sb, this.getTreePlan(), 0);
        return sb.toString();
    }

    private void append(StringBuffer sb, TreeNode<String> treePlan, int level) {
        if (level != 0) {
            sb.append("\n");
            for (int i = 1; i < level; ++i) {
                sb.append(" ");
            }
            sb.append((String)treePlan.getUserObject());
        }
        if (treePlan.getChildren() != null) {
            for (TreeNode tn : treePlan.getChildren()) {
                this.append(sb, (TreeNode<String>)tn, level + 1);
            }
        }
    }

    private TreeNode<String> fill(TreeNode<String> node, Operation operation) {
        ArrayList<TreeNode<String>> nodes = node.getChildren();
        if (nodes == null) {
            nodes = new ArrayList<TreeNode<String>>();
            node.setChildren(nodes);
        }
        TreeNode<String> newNode = null;
        switch (operation.getType()) {
            case H2: {
                OperationH2 h2 = (OperationH2)operation;
                newNode = this.fill(node, h2.getResult());
                for (Operation o : h2.getOperationList()) {
                    this.fill(newNode, o);
                }
                break;
            }
            case SELECT: {
                OperationSelect select = (OperationSelect)operation;
                newNode = new TreeNode<String>();
                newNode.setUserObject((Object)select.getQuerySQL().toString());
                nodes.add(newNode);
                break;
            }
            case AGREGATE: {
                OperationAgregate agregate = (OperationAgregate)operation;
                newNode = new DefaultMutableTreeNode();
                newNode.setUserObject((Object)"");
                nodes.add(newNode);
                this.fill(node, agregate.getOperation());
                break;
            }
            case CALCULATE: {
                OperationCalculate calculate = (OperationCalculate)operation;
                newNode = new DefaultMutableTreeNode();
                newNode.setUserObject((Object)"");
                nodes.add(newNode);
                this.fill(node, calculate.getOperation());
                break;
            }
            case FILTER: {
                OperationFilter filter = (OperationFilter)operation;
                newNode = new DefaultMutableTreeNode();
                newNode.setUserObject((Object)"");
                nodes.add(newNode);
                this.fill(node, filter.getOperation());
                break;
            }
            case JOIN: {
                OperationJoin join = (OperationJoin)operation;
                newNode = new DefaultMutableTreeNode();
                newNode.setUserObject((Object)"");
                newNode.setChildren(new ArrayList());
                nodes.add(newNode);
                this.fill(newNode, join.getOperation());
                this.fill(newNode, join.getOperationToJoin());
                break;
            }
            case SORT: {
                OperationSort sort = (OperationSort)operation;
                newNode = new DefaultMutableTreeNode();
                newNode.setUserObject((Object)"");
                nodes.add(newNode);
                this.fill(node, sort.getOperation());
            }
        }
        return newNode;
    }
}

