/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.helper;

import com.lowagie.text.BadElementException;
import com.prelytis.dashboard.data.transformation.interfaces.NoDataHandler;
import com.prelytis.dashboard.data.transformation.parameter.RowCell;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.db.value.ValueString;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.util.TableFactory;
import com.prelytis.dashboard.value.chart.Cell;
import com.prelytis.dashboard.value.chart.ColRow;
import com.prelytis.dashboard.value.chart.ICellElt;
import com.prelytis.dashboard.value.chart.Table;
import com.prelytis.dashboard.value.util.ClassElement;
import com.prelytis.dashboard.value.util.Font;
import com.prelytis.dashboard.value.util.StyleElement;
import java.util.List;
import java.util.Locale;

public class NoDataHelper {
    public static final String NO_DATA_MARKER = "<nodata>";

    public static boolean isNoDataCell(Cell cell) {
        boolean result = false;
        ICellElt cellElt = TableFactory.getCellElt((Cell)cell, (int)0);
        Object val = cellElt.getValue();
        if (val instanceof String && ((String)val).startsWith(NO_DATA_MARKER)) {
            result = true;
        }
        return result;
    }

    public static Cell getFirstDataCell(Table table) {
        Cell result = null;
        result = TableFactory.getColRowInv((Table)table) ? TableFactory.getFinalCell((Table)table, (int)1, (int)0) : TableFactory.getFinalCell((Table)table, (int)0, (int)1);
        return result;
    }

    public static boolean isNoDataTable(Table table) {
        Cell firstDataCell = NoDataHelper.getFirstDataCell(table);
        return NoDataHelper.isNoDataCell(firstDataCell);
    }

    public static Object removeNoDataMarker(Object val) {
        if (val instanceof String && ((String)val).startsWith(NO_DATA_MARKER)) {
            return ((String)val).substring(NO_DATA_MARKER.length());
        }
        return val;
    }

    public static RowParameter buildNoDataRow(ClassElement ce, StyleElement bodyStyle, Locale locale, int nbCols) {
        RowParameter row = new RowParameter();
        List<RowCell> list = row.getCells();
        StyleElement style = new StyleElement((Font)bodyStyle);
        style.setBackColor("FFFFFF");
        style.setForeColor("000000");
        ce.setStyle(style);
        ValueString v = new ValueString(NO_DATA_MARKER + ExceptionHelper.getInstance(locale).getMessage("noResultsFound", null));
        list.add(new RowCell((Value)v, ce, "{0}"));
        for (int i = 1; i < nbCols; ++i) {
            list.add(new RowCell((Value)v, ce, "{0}"));
        }
        row.setRowNumber(1);
        return row;
    }

    public static void buildNoDataTable(NoDataHandler handler, Table table, int nbRows, int nbCols) throws BadElementException {
        if (TableFactory.getColRowInv((Table)table)) {
            for (int i = 0; i < nbRows; ++i) {
                ColRow row = TableFactory.getFinalRow((Table)table, (int)i);
                handler.fill(TableFactory.getFinalCell((ColRow)row, (int)0), 0, i, null, null);
                if (i != 0) continue;
                handler.fill(TableFactory.getFinalCell((ColRow)row, (int)1), 1, 0, null, nbRows);
            }
        } else {
            ColRow headerRow = TableFactory.getFinalRow((Table)table, (int)0);
            for (int j = 0; j < nbCols; ++j) {
                handler.fill(TableFactory.getFinalCell((ColRow)headerRow, (int)j), j, 0, null, null);
            }
            ColRow noDataRow = TableFactory.getFinalRow((Table)table, (int)1);
            handler.fill(TableFactory.getFinalCell((ColRow)noDataRow, (int)0), 0, 1, nbCols, null);
        }
    }
}

