/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.link;

import com.prelytis.dashboard.data.CrossTableHeader;
import com.prelytis.dashboard.data.link.LinkDefinition;
import com.prelytis.dashboard.data.link.LinkFieldParam;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.value.chart.Link;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.tree.TreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LinkHelper {
    private LinkHelper() {
    }

    public static LinkHelper getInstance() {
        return new LinkHelper();
    }

    public Map<String, ReportFilter> getReportFilterMap(List<? extends ReportFilter> filterList) {
        HashMap<String, ReportFilter> map = new HashMap<String, ReportFilter>();
        if (filterList != null) {
            for (ReportFilter reportFilter : filterList) {
                map.put(reportFilter.getName(), reportFilter);
            }
        }
        return map;
    }

    public Link getLink(LinkDefinition ld, Map<String, Object[]> valuesMap) {
        ReportFilter filter;
        Link link = new Link();
        link.setName(ld.getName());
        link.setDescription(ld.getDescription());
        link.setSessionType(ld.getSessionType());
        link.setDocumentName(ld.getDocumentName());
        link.setDstInNewWnd(ld.isDstInNewWnd());
        link.setFrmValRefresh(ld.isFrmValRefresh());
        link.setPreview(ld.isPreview());
        ArrayList<ReportFilter> filterList = new ArrayList<ReportFilter>();
        HashMap<String, ReportFilter> map = new HashMap<String, ReportFilter>();
        for (ReportFilter ref : ld.getReportFilterList()) {
            filter = this.getFilter(ref);
            filterList.add(filter);
            map.put(filter.getName(), filter);
        }
        LinkFieldParam[] fields = ld.getFields();
        for (int i = 0; i < fields.length; ++i) {
            filter = (ReportFilter)map.get(fields[i].getDstName());
            filter.setUseFilter(true);
            filter.setValues(valuesMap.get(fields[i].getDstName()));
        }
        link.setReportFilterList(filterList);
        return link;
    }

    public Link getLink(LinkDefinition ld) {
        Link link = new Link();
        link.setName(ld.getName());
        link.setDescription(ld.getDescription());
        link.setSessionType(ld.getSessionType());
        link.setDocumentName(ld.getDocumentName());
        link.setDstInNewWnd(ld.isDstInNewWnd());
        link.setFrmValRefresh(ld.isFrmValRefresh());
        link.setPreview(ld.isPreview());
        ArrayList<ReportFilter> filterList = new ArrayList<ReportFilter>();
        for (ReportFilter ref : ld.getReportFilterList()) {
            ReportFilter filter = this.getFilter(ref);
            filterList.add(filter);
        }
        link.setReportFilterList(filterList);
        return link;
    }

    private ReportFilter getFilter(ReportFilter ref) {
        ReportFilter filter = new ReportFilter();
        filter.setDatatype(ref.getDatatype());
        filter.setDescription(ref.getDescription());
        filter.setLinkable(ref.isLinkable());
        filter.setMandatory(ref.getMandatory());
        filter.setName(ref.getName());
        filter.setPromptType(ref.getPromptType());
        filter.setUseFilter(ref.getUseFilter());
        filter.setValues(ref.getValues());
        return filter;
    }

    public Value getHeaderValue(TreeNode<CrossTableHeader> node, int offset) {
        if (node == null || offset < 0) {
            return null;
        }
        if (offset == 0) {
            CrossTableHeader h = (CrossTableHeader)node.getUserObject();
            if (h == null) {
                return null;
            }
            return h.getValue();
        }
        return this.getHeaderValue((TreeNode<CrossTableHeader>)node.getParent(), offset - 1);
    }

    public Object[] getObjects(Value value) {
        if (value == null) {
            return null;
        }
        Object resu = value.getObject();
        if (resu instanceof Object[]) {
            return (Object[])resu;
        }
        if (resu == null) {
            return null;
        }
        return new Object[]{resu};
    }
}

