/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.link;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbLinkFilter;
import com.prelytis.dashboard.data.CrossTableHeaderDefinition;
import com.prelytis.dashboard.data.CrossTableValue;
import com.prelytis.dashboard.data.link.LinkDefinition;
import com.prelytis.dashboard.data.link.LinkDefinitionComparator;
import com.prelytis.dashboard.data.link.LinkFieldParam;
import com.prelytis.dashboard.data.link.LinkHelper;
import com.prelytis.dashboard.data.link.RefField;
import com.prelytis.dashboard.data.link.RefType;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.model.helper.DashBoardHelper;
import com.prelytis.dashboard.model.helper.ExtSessionHelper;
import com.prelytis.dashboard.model.helper.FormHelper;
import com.prelytis.dashboard.model.helper.ReportHelper;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.BeanDashBoardDefinition;
import com.prelytis.dashboard.value.data.BeanExtSessionDefinition;
import com.prelytis.dashboard.value.data.BeanFormDefinition;
import com.prelytis.dashboard.value.data.BeanLinkDefinition;
import com.prelytis.dashboard.value.data.BeanLinkField;
import com.prelytis.dashboard.value.data.BeanReportCrossTable;
import com.prelytis.dashboard.value.data.BeanReportCrossTableUsedField;
import com.prelytis.dashboard.value.data.BeanReportDataUsedField;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.tree.TreeNode;
import com.prelytis.dashboard.value.tree.TreePath;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class LinkHelperCrossTable {
    private static final Logger log = LogManager.getLogger(LinkHelperCrossTable.class);
    private final LinkHelper linkHelper = LinkHelper.getInstance();
    private final Map<String, List<LinkDefinition>> links = new HashMap<String, List<LinkDefinition>>();

    public LinkHelperCrossTable(DaoFactory daoFactory, BeanReportCrossTable report, List<? extends ReportFilter> srcFilterList, ExpressionEvaluationData data) throws DashboardException {
        LinkDefinitionComparator comparator = new LinkDefinitionComparator(data.getLocale());
        try {
            WorkspaceDao workspaceDao = daoFactory.getWorkspaceDao();
            com.prelytis.dashboard.model.helper.LinkHelper linkDao = com.prelytis.dashboard.model.helper.LinkHelper.getInstance(daoFactory);
            FormHelper formHelper = FormHelper.getInstance(daoFactory);
            Map<String, ReportFilter> srcFilterMap = this.linkHelper.getReportFilterMap(srcFilterList);
            DashBoardHelper dashboardHelper = DashBoardHelper.getInstance(daoFactory);
            ExtSessionHelper externSessionHelper = ExtSessionHelper.getInstance(daoFactory);
            ReportHelper reportHelper = ReportHelper.getInstance(daoFactory);
            DbLinkFilter linkFilter = new DbLinkFilter();
            linkFilter.setSrcReport(Integer.valueOf(report.getObjectID()));
            List<Element> list = linkDao.list(linkFilter, 2, null, null, data);
            for (int i = 0; i < list.size(); ++i) {
                try {
                    ReportFilter dstFilter;
                    int j;
                    BeanLinkDefinition linkDef = (BeanLinkDefinition)list.get(i);
                    LinkFieldParam[] fields = null;
                    boolean valid = true;
                    SessionType dstSessionType = SessionType.NONE;
                    String dstDocumentName = null;
                    List<ReportFilter> dstFilterList = null;
                    if (linkDef.getDstReportOID() != null) {
                        AbstractBeanReport dstReport = reportHelper.getDefinition(linkDef.getDstReportName());
                        dstDocumentName = dstReport.getName();
                        dstSessionType = SessionType.DOCUMENT;
                        dstFilterList = reportHelper.getLinkableFilterList(dstReport, data);
                    } else if (linkDef.getDstDashBoardOID() != null) {
                        BeanDashBoardDefinition dstDashboard = dashboardHelper.getDefinition(linkDef.getDstDashBoardName());
                        dstDocumentName = dstDashboard.getName();
                        dstSessionType = SessionType.DASHBOARD;
                        dstFilterList = dashboardHelper.getFilterList(dstDashboard.getFilterList(), data);
                    } else if (linkDef.getDstExtSessionOID() != null) {
                        BeanExtSessionDefinition dstExtSession = externSessionHelper.getDefinition(linkDef.getDstExtSessionName());
                        dstDocumentName = dstExtSession.getName();
                        dstSessionType = SessionType.EXTERN;
                        dstFilterList = externSessionHelper.getLinkableFilterList(dstExtSession.getParameterList(), null, data);
                    } else if (linkDef.getDstFormOID() != null) {
                        BeanFormDefinition dstForm = formHelper.getDefinition(linkDef.getDstFormName());
                        dstDocumentName = dstForm.getName();
                        dstSessionType = SessionType.FORM;
                        dstFilterList = formHelper.getFilterList(dstForm.getUsedFields());
                    } else {
                        valid = false;
                    }
                    if (valid) {
                        if (data.getUserOid() != null && data.getExecutionContextOid() != null) {
                            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), dstSessionType, dstDocumentName).getAccessLevel();
                            if (accessLevel == 0) {
                                valid = false;
                            }
                        } else {
                            valid = false;
                        }
                    }
                    Map<String, ReportFilter> dstFilterMap = this.linkHelper.getReportFilterMap(dstFilterList);
                    if (valid) {
                        List filterFilterList = linkDef.getBeanLinkFilterFilterList();
                        for (j = 0; j < filterFilterList.size() && valid; ++j) {
                            BeanLinkField filterFilter = (BeanLinkField)filterFilterList.get(j);
                            dstFilter = dstFilterMap.get(filterFilter.getDst());
                            ReportFilter srcFilter = srcFilterMap.get(filterFilter.getSrc());
                            if (dstFilter != null && srcFilter != null) {
                                if (srcFilter.getUseFilter()) {
                                    dstFilter.setUseFilter(true);
                                    dstFilter.setValues(srcFilter.getValues());
                                    continue;
                                }
                                dstFilter.setUseFilter(false);
                                dstFilter.setValues(null);
                                continue;
                            }
                            valid = false;
                        }
                    }
                    if (valid) {
                        List fieldFilterList = linkDef.getBeanLinkFieldFilterList();
                        fields = new LinkFieldParam[fieldFilterList.size()];
                        for (j = 0; j < fieldFilterList.size(); ++j) {
                            BeanLinkField fieldFilter = (BeanLinkField)fieldFilterList.get(j);
                            dstFilter = dstFilterMap.get(fieldFilter.getDst());
                            if (dstFilter == null) {
                                valid = false;
                                break;
                            }
                            fields[j] = new LinkFieldParam(fieldFilter.getSrc(), fieldFilter.getDst(), null);
                        }
                    }
                    if (!valid) continue;
                    LinkDefinition link = new LinkDefinition();
                    link.setSessionType(dstSessionType);
                    link.setDocumentName(dstDocumentName);
                    link.setName(linkDef.getName());
                    link.setDescription((String)linkDef.getDescriptionMap().get(data.getLocale()));
                    link.setFields(fields);
                    link.setReportFilterList(dstFilterList);
                    link.setDstInNewWnd(linkDef.isDstInNewWindow());
                    link.setFrmValRefresh(linkDef.isFrmValRefresh());
                    link.setPreview(linkDef.isPreview());
                    List<LinkDefinition> ll = this.links.get(linkDef.getLinkedFieldName());
                    if (ll == null) {
                        ll = new ArrayList<LinkDefinition>();
                        this.links.put(linkDef.getLinkedFieldName(), ll);
                    }
                    ll.add(link);
                    continue;
                }
                catch (Exception linkDef) {
                    // empty catch block
                }
            }
            for (List<LinkDefinition> ll : this.links.values()) {
                Collections.sort(ll, comparator);
            }
        }
        catch (Exception e) {
            throw this.getDashboardException(e);
        }
    }

    private DashboardException getDashboardException(Exception e) {
        DashboardException de = e instanceof DashboardException ? (DashboardException)((Object)e) : new DashboardException((Throwable)e);
        de.log(log);
        return de;
    }

    public CrossTableValue[] getLinkDefinition(TreePath<BeanReportCrossTableUsedField> colPath, TreePath<BeanReportCrossTableUsedField> rowPath, List<BeanReportDataUsedField> dataFieldList) {
        CrossTableValue[] cv = new CrossTableValue[dataFieldList.size()];
        HashMap<String, RefField> linkableFieldMap = new HashMap<String, RefField>();
        this.fill(linkableFieldMap, colPath, RefType.COL);
        this.fill(linkableFieldMap, rowPath, RefType.ROW);
        for (int i = 0; i < dataFieldList.size(); ++i) {
            BeanReportDataUsedField field = dataFieldList.get(i);
            linkableFieldMap.put(field.getName(), new RefField(RefType.DATA, i));
        }
        int dataId = 0;
        for (BeanReportDataUsedField usedField : dataFieldList) {
            List<LinkDefinition> ll = this.links.get(usedField.getName());
            List<LinkDefinition> ls = this.getLinkList(ll, linkableFieldMap);
            CrossTableValue ctv = cv[dataId];
            if (ctv == null) {
                cv[dataId] = ctv = new CrossTableValue();
            }
            ctv.setLinks(ls);
            ++dataId;
        }
        return cv;
    }

    public void update(CrossTableHeaderDefinition def, TreeNode<BeanReportCrossTableUsedField> node, RefType type) {
        if (node.getUserObject() != null) {
            List<LinkDefinition> ll = this.links.get(((BeanReportCrossTableUsedField)node.getUserObject()).getName());
            HashMap<String, RefField> linkableFieldMap = new HashMap<String, RefField>();
            this.fill(linkableFieldMap, node, 0, type);
            def.setLinks(this.getLinkList(ll, linkableFieldMap));
        }
    }

    private void fill(Map<String, RefField> linkableFieldMap, TreeNode<BeanReportCrossTableUsedField> node, int id, RefType type) {
        if (node.getUserObject() != null) {
            BeanReportCrossTableUsedField usedField = (BeanReportCrossTableUsedField)node.getUserObject();
            linkableFieldMap.put(usedField.getName(), new RefField(type, id));
        }
        if (node.getParent() != null) {
            this.fill(linkableFieldMap, (TreeNode<BeanReportCrossTableUsedField>)node.getParent(), id + 1, type);
        }
    }

    private List<LinkDefinition> getLinkList(List<LinkDefinition> ll, Map<String, RefField> linkableFieldMap) {
        if (ll == null) {
            return null;
        }
        ArrayList<LinkDefinition> ls = new ArrayList<LinkDefinition>();
        for (LinkDefinition ld : ll) {
            boolean valid = true;
            LinkFieldParam[] newFields = null;
            if (ld.getFields() != null) {
                newFields = new LinkFieldParam[ld.getFields().length];
                int cpt = 0;
                for (LinkFieldParam p : ld.getFields()) {
                    RefField rf = linkableFieldMap.get(p.getSrcName());
                    if (rf == null) {
                        valid = false;
                        break;
                    }
                    newFields[cpt] = new LinkFieldParam(p.getSrcName(), p.getDstName(), rf);
                    ++cpt;
                }
            }
            if (!valid) continue;
            LinkDefinition newLD = new LinkDefinition();
            newLD.setName(ld.getName());
            newLD.setDescription(ld.getDescription());
            newLD.setDstInNewWnd(ld.isDstInNewWnd());
            newLD.setFrmValRefresh(ld.isFrmValRefresh());
            newLD.setPreview(ld.isPreview());
            newLD.setReportFilterList(ld.getReportFilterList());
            newLD.setSessionType(ld.getSessionType());
            newLD.setDocumentName(ld.getDocumentName());
            newLD.setSortOrder(ld.getSortOrder());
            newLD.setFields(newFields);
            ls.add(newLD);
        }
        return ls.isEmpty() ? null : ls;
    }

    private void fill(Map<String, RefField> linkableFieldMap, TreePath<BeanReportCrossTableUsedField> path, RefType type) {
        int cpt = path.getPath().length;
        for (TreeNode node : path.getPath()) {
            --cpt;
            if (node.getUserObject() == null) continue;
            linkableFieldMap.put(((BeanReportCrossTableUsedField)node.getUserObject()).getName(), new RefField(type, cpt));
        }
    }
}

