/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.transformation.CalculationHelper;
import com.prelytis.dashboard.data.transformation.DefaultDataFilter;
import com.prelytis.dashboard.data.transformation.parameter.ContainerParameter;
import com.prelytis.dashboard.data.transformation.parameter.RowCell;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.data.transformation.parameter.RuptureParameter;
import com.prelytis.dashboard.data.transformation.parameter.SectionParameter;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.db.value.ValueNull;
import com.prelytis.dashboard.interfaces.DashboardException;
import java.util.Map;
import java.util.Stack;

public class CalculationDataFilter
extends DefaultDataFilter {
    private static final RowCell EMPTY_ROW_CELL = new RowCell((Value)ValueNull.DEFAULT, null, null);
    private int nbSections;
    private Stack<RowCell> sectionStack = new Stack();
    private CalculationHelper global;
    private Map<Integer, CalculationHelper> sections;
    private Map<Integer, CalculationHelper> ruptures;

    public CalculationHelper getGlobal() {
        return this.global;
    }

    public void setGlobal(CalculationHelper global) {
        this.global = global;
    }

    public Map<Integer, CalculationHelper> getSections() {
        return this.sections;
    }

    public void setSections(Map<Integer, CalculationHelper> sections) {
        this.sections = sections;
    }

    public Map<Integer, CalculationHelper> getRuptures() {
        return this.ruptures;
    }

    public void setRuptures(Map<Integer, CalculationHelper> breaks) {
        this.ruptures = breaks;
    }

    @Override
    public void startContainer(ContainerParameter container) throws DashboardException {
        if (this.global != null) {
            this.global.resetCalculation();
        }
        if (this.sections != null) {
            for (CalculationHelper helper : this.sections.values()) {
                helper.resetCalculation();
            }
        }
        if (this.ruptures != null) {
            for (CalculationHelper helper : this.ruptures.values()) {
                helper.resetCalculation();
            }
        }
        super.startContainer(container);
    }

    @Override
    public void endContainer(ContainerParameter container) throws DashboardException {
        if (this.global != null) {
            this.global.addCalculatedRows(container, this.getSectionStack());
            this.global.resetCalculation();
        }
        super.endContainer(container);
    }

    private Stack<RowCell> getSectionStack() {
        Stack<RowCell> stack = new Stack<RowCell>();
        stack.addAll(this.sectionStack);
        while (stack.size() < this.nbSections) {
            stack.add(EMPTY_ROW_CELL);
        }
        return stack;
    }

    @Override
    public void endRow(RowParameter row) throws DashboardException {
        if (this.global != null) {
            this.global.updateCalculation(row);
        }
        if (this.sections != null) {
            for (CalculationHelper helper : this.sections.values()) {
                helper.updateCalculation(row);
            }
        }
        if (this.ruptures != null) {
            for (CalculationHelper helper : this.ruptures.values()) {
                helper.updateCalculation(row);
            }
        }
        super.endRow(row);
    }

    @Override
    public void endRupture(RuptureParameter rupture) throws DashboardException {
        CalculationHelper helper;
        if (this.ruptures != null && (helper = this.ruptures.get(rupture.getRuptureLevel())) != null) {
            helper.addCalculatedRows(rupture, this.getSectionStack());
            helper.resetCalculation();
        }
        super.endRupture(rupture);
    }

    @Override
    public void endSection(SectionParameter section) throws DashboardException {
        CalculationHelper helper;
        if (this.sections != null && (helper = this.sections.get(section.getSectionLevel())) != null) {
            helper.addCalculatedRows(section, this.getSectionStack());
            helper.resetCalculation();
        }
        this.sectionStack.pop();
        super.endSection(section);
    }

    @Override
    public void startSection(SectionParameter section) throws DashboardException {
        RowCell rc = new RowCell(section.getValue(), section.getClassElement(), section.getFormat());
        this.sectionStack.push(rc);
        super.startSection(section);
    }

    public int getNbSections() {
        return this.nbSections;
    }

    public void setNbSections(int nbSections) {
        this.nbSections = nbSections;
    }
}

