/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.transformation.CalculationDefinition;
import com.prelytis.dashboard.data.transformation.ConditionalFormatDefinition;
import com.prelytis.dashboard.data.transformation.ConditionalFormatHelper;
import com.prelytis.dashboard.data.transformation.LabelDefinition;
import com.prelytis.dashboard.data.transformation.PrevColumnCalculationHelper;
import com.prelytis.dashboard.data.transformation.parameter.AbstractRowParameter;
import com.prelytis.dashboard.data.transformation.parameter.CalculatedRowParameter;
import com.prelytis.dashboard.data.transformation.parameter.CalculationParameter;
import com.prelytis.dashboard.data.transformation.parameter.RowCell;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.db.value.ValueNull;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.value.util.ClassElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class CalculationHelper {
    private int decal;
    private int nbCols;
    private int nbRows;
    private List<List<ConditionalFormatDefinition>> conditionalFormatList;
    private ClassElement defaultClassElement;
    private List<CalculationDefinition> calculationList;
    private final List<CalculationDefinition> calculationWithCdtFmtList = new ArrayList<CalculationDefinition>();
    private List<LabelDefinition> labelList;
    private List<PrevColumnCalculationHelper> prevColCalcList;
    private String defaultFormat = "{0}";
    private ConditionalFormatHelper cfh;

    public List<PrevColumnCalculationHelper> getPrevColCalcList() {
        return this.prevColCalcList;
    }

    public void setPrevColCalcList(List<PrevColumnCalculationHelper> prevColCalcList) {
        this.prevColCalcList = prevColCalcList;
    }

    public int getDecal() {
        return this.decal;
    }

    public void setDecal(int decal) {
        this.decal = decal;
    }

    public int getNbRows() {
        return this.nbRows;
    }

    public void setNbRows(int nbRows) {
        this.nbRows = nbRows;
    }

    public int getNbCols() {
        return this.nbCols;
    }

    public void setNbCols(int nbCols) {
        this.nbCols = nbCols;
    }

    public List<LabelDefinition> getLabelList() {
        return this.labelList;
    }

    public void setLabelList(List<LabelDefinition> labelList) {
        this.labelList = labelList;
    }

    public List<CalculationDefinition> getCalculationList() {
        return this.calculationList;
    }

    public void setCalculationList(List<CalculationDefinition> calculationList) {
        this.calculationList = calculationList;
        this.calculationWithCdtFmtList.clear();
        if (calculationList != null && this.calculationWithCdtFmtList.isEmpty()) {
            for (CalculationDefinition def : calculationList) {
                if (!def.isApplyConditionalFormat()) continue;
                this.calculationWithCdtFmtList.add(def);
            }
        }
    }

    public void addCalculatedRows(CalculationParameter parameter, Stack<RowCell> sections) {
        if (this.calculationList == null) {
            return;
        }
        AbstractRowParameter[] rows = new CalculatedRowParameter[this.nbRows];
        for (int i = 0; i < this.nbRows; ++i) {
            rows[i] = new CalculatedRowParameter(this.nbCols, this.defaultClassElement, this.defaultFormat);
        }
        this.addOnRows(rows);
        int nbSections = sections == null ? 0 : sections.size();
        for (CalculationDefinition calculation : this.calculationWithCdtFmtList) {
            ArrayList<RowCell> rowCells = new ArrayList<RowCell>();
            rowCells.addAll(sections);
            rowCells.addAll(rows[calculation.getRow()].getCells());
            List<ConditionalFormatDefinition> def = this.conditionalFormatList.get(nbSections + calculation.getCol());
            if (def == null || def.isEmpty()) continue;
            RowCell cell = (RowCell)rowCells.get(nbSections + calculation.getCol());
            this.cfh.update(def, cell, rowCells);
        }
        for (AbstractRowParameter row : rows) {
            if (this.prevColCalcList != null) {
                for (PrevColumnCalculationHelper h : this.prevColCalcList) {
                    h.updateCalculation(row);
                }
            }
            parameter.addCalculatedRow((CalculatedRowParameter)row);
        }
    }

    public RowParameter[] getCalculatedRows() {
        if (this.calculationList == null) {
            return null;
        }
        AbstractRowParameter[] rows = new RowParameter[this.nbRows];
        for (int i = 0; i < this.nbRows; ++i) {
            rows[i] = new RowParameter();
            List<RowCell> list = rows[i].getCells();
            for (int col = 0; col < this.nbCols; ++col) {
                list.add(new RowCell((Value)ValueNull.STRING, this.defaultClassElement, this.defaultFormat));
            }
        }
        this.addOnRows(rows);
        return rows;
    }

    private void addOnRows(AbstractRowParameter[] rows) {
        for (CalculationDefinition calculation : this.calculationList) {
            Value value = calculation.getCalculation().getValue();
            List<RowCell> list = rows[calculation.getRow()].getCells();
            RowCell rc = list.get(calculation.getCol());
            rc.setValue(value);
            rc.setClassElement(calculation.getClassElement());
            rc.setFormat(calculation.getFormat());
        }
        for (LabelDefinition label : this.labelList) {
            List<RowCell> list = rows[label.getRow()].getCells();
            RowCell rowCell = list.get(label.getCol());
            rowCell.setValue(label.getValue());
            rowCell.setClassElement(label.getClassElement());
            rowCell.setFormat(label.getFormat());
        }
        for (Iterator<Object> iterator : rows) {
            for (RowCell cell : ((AbstractRowParameter)((Object)iterator)).getCells()) {
                if (cell.getClassElement() != null) continue;
                cell.setClassElement(this.defaultClassElement);
            }
        }
    }

    public void updateCalculation(RowParameter row) throws DashboardException {
        if (this.calculationList != null) {
            List<RowCell> list = row.getCells();
            for (CalculationDefinition calculation : this.calculationList) {
                RowCell cell = list.get(this.decal + calculation.getCol());
                Value value = calculation.isCalculationOnRawData() ? cell.getRawValue() : cell.getValue();
                if (value == null) continue;
                calculation.getCalculation().addValue(value);
            }
        }
    }

    public void resetCalculation() {
        if (this.calculationList != null) {
            for (CalculationDefinition calculation : this.calculationList) {
                calculation.getCalculation().reset();
            }
        }
    }

    public ClassElement getDefaultClassElement() {
        return this.defaultClassElement;
    }

    public void setDefaultClassElement(ClassElement defaultClassElement) {
        this.defaultClassElement = defaultClassElement;
    }

    public List<List<ConditionalFormatDefinition>> getConditionalFormatList() {
        return this.conditionalFormatList;
    }

    public void setConditionalFormatList(List<List<ConditionalFormatDefinition>> conditionalFormatList) {
        this.conditionalFormatList = conditionalFormatList;
    }

    public ConditionalFormatHelper getConditionalFormatHelper() {
        return this.cfh;
    }

    public void setConditionalFormatHelper(ConditionalFormatHelper cfh) {
        this.cfh = cfh;
    }
}

