/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.transformation.parameter.RowCell;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.value.chart.Cell;
import com.prelytis.dashboard.value.chart.CellHeader;
import com.prelytis.dashboard.value.chart.CellHeaderElt;
import com.prelytis.dashboard.value.chart.CellValue;
import com.prelytis.dashboard.value.chart.CellValueElt;
import com.prelytis.dashboard.value.chart.LinkList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class CellEltFactory {
    private String numericFormat;
    private String dateFormat;
    private String defaultFormat;
    private String percentFormat;
    private Map<CellHeaderElt, CellHeaderElt> headerMap = new HashMap<CellHeaderElt, CellHeaderElt>();

    public void setCellValue(Cell cell, RowCell rowCell) {
        if (cell instanceof CellHeader) {
            CellHeader cellHeader = (CellHeader)cell;
            CellHeaderElt elt = null;
            CellHeaderElt cellElt = new CellHeaderElt();
            cellElt.setCell((Cell)cellHeader);
            cellElt.setCellEltNum((byte)0);
            cellElt.setClassElement(rowCell.getClassElement());
            cellElt.setFormat(this.getFormat(rowCell));
            cellElt.setValue(this.getObject(rowCell.getValue()));
            cellElt.setParent(elt);
            if (rowCell.isCalculated()) {
                cellElt.setLinkList((List)LinkList.NOLINK);
            }
            cellElt.setNbReferences(1);
            cellHeader.setCellHeaderElt(elt);
        } else if (cell instanceof CellValue) {
            CellValue cellValue = (CellValue)cell;
            CellValueElt cellElt = new CellValueElt();
            cellElt.setCell((Cell)cellValue);
            cellElt.setCellEltNum((byte)0);
            cellElt.setClassElement(rowCell.getClassElement());
            cellElt.setFormat(this.getFormat(rowCell));
            cellElt.setValue(this.getObject(rowCell.getValue()));
            if (rowCell.isCalculated()) {
                cellElt.setLinkList((List)LinkList.NOLINK);
            }
            CellValueElt[] elt = new CellValueElt[]{cellElt};
            cellValue.setCellValueElt(elt);
        }
    }

    private Object getObject(Value value) {
        if (value == null) {
            return null;
        }
        Object resu = value.getObject();
        if (resu instanceof Object[]) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Object o : (Object[])resu) {
                if (first) {
                    first = false;
                } else {
                    sb.append("/");
                }
                sb.append(o == null ? "null" : o.toString());
            }
            return sb.toString();
        }
        return resu;
    }

    private String getFormat(RowCell rce) {
        String format = rce.getFormat();
        if (format != null && !"".equals(format.trim())) {
            return format;
        }
        Value value = rce.getValue();
        if (value != null && value.getType() != null) {
            switch (value.getType()) {
                case BIG_DECIMAL: 
                case DOUBLE: 
                case FLOAT: 
                case INTEGER: 
                case LONG: {
                    if (rce.isPercent()) {
                        return this.percentFormat;
                    }
                    return this.numericFormat;
                }
                case DATE: 
                case DATETIME: 
                case TIME: {
                    return this.dateFormat;
                }
            }
        }
        return this.defaultFormat;
    }

    public String getNumericFormat() {
        return this.numericFormat;
    }

    public void setNumericFormat(String numericFormat) {
        this.numericFormat = numericFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getDefaultFormat() {
        return this.defaultFormat;
    }

    public void setDefaultFormat(String defaultFormat) {
        this.defaultFormat = defaultFormat;
    }

    public String getPercentFormat() {
        return this.percentFormat;
    }

    public void setPercentFormat(String percentFormat) {
        this.percentFormat = percentFormat;
    }
}

