/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.transformation.ConditionalFormatDefinition;
import com.prelytis.dashboard.data.transformation.parameter.RowCell;
import com.prelytis.dashboard.db.ValueComparator;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.db.value.ValueNull;
import com.prelytis.dashboard.helper.ClassElementHelper;
import com.prelytis.dashboard.value.data.Operator;
import com.prelytis.dashboard.value.util.ClassElement;
import com.prelytis.dashboard.value.util.Font;
import com.prelytis.dashboard.value.util.StyleElement;
import java.util.EnumSet;
import java.util.List;

public class ConditionalFormatHelper {
    private final EnumSet<Operator> es = EnumSet.of(Operator.GREATER, Operator.GREATER_OR_EQUALS, Operator.SMALLER, Operator.SMALLER_OR_EQUALS);
    private final ClassElementHelper ceh;
    private final ValueComparator comparator;

    private ConditionalFormatHelper(ClassElementHelper ceh, ValueComparator comparator) {
        this.ceh = ceh;
        this.comparator = comparator;
    }

    public static ConditionalFormatHelper getInstance(ClassElementHelper ceh, ValueComparator comparator) {
        return new ConditionalFormatHelper(ceh, comparator);
    }

    public void update(List<ConditionalFormatDefinition> def, RowCell cell, List<RowCell> data) {
        if (def == null) {
            return;
        }
        for (ConditionalFormatDefinition d : def) {
            this.update(d, cell, data);
        }
    }

    public boolean isTrue(ConditionalFormatDefinition def, Value v) {
        if ((v instanceof ValueNull || def.getValue() instanceof ValueNull) && this.es.contains(def.getOperator())) {
            return false;
        }
        int comp = this.comparator.compare(v, def.getValue());
        switch (def.getOperator()) {
            case DIFFERENT: {
                return comp != 0;
            }
            case EQUALS: {
                return comp == 0;
            }
            case GREATER: {
                return comp > 0;
            }
            case GREATER_OR_EQUALS: {
                return comp >= 0;
            }
            case SMALLER: {
                return comp < 0;
            }
            case SMALLER_OR_EQUALS: {
                return comp <= 0;
            }
        }
        return false;
    }

    public void update(ConditionalFormatDefinition def, RowCell cell, List<RowCell> data) {
        Value v = data.get(def.getField().getIndex()).getValue();
        if (this.isTrue(def, v)) {
            this.update(def, cell);
        }
    }

    private void update(ConditionalFormatDefinition def, RowCell elt) {
        if (def.getFormat() != null) {
            elt.setFormat(def.getFormat());
        }
        elt.setClassElement(this.getClassElement(def, elt.getClassElement()));
    }

    public ClassElement getClassElement(ConditionalFormatDefinition def, ClassElement classElement) {
        if (def.getClassElement() != null && def.getClassElement().getStyle() != null) {
            StyleElement style = new StyleElement((Font)(classElement == null ? null : classElement.getStyle()));
            style.override((Font)def.getClassElement().getStyle());
            return this.ceh.getClassElement(def.getClassElement().getName(), style);
        }
        return classElement;
    }

    public ClassElementHelper getClassElementHelper() {
        return this.ceh;
    }
}

