/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.transformation.DefaultDataFilter;
import com.prelytis.dashboard.data.transformation.parameter.DataParameter;
import com.prelytis.dashboard.data.transformation.parameter.RowCell;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.helper.ClassElementHelper;
import com.prelytis.dashboard.helper.SeverityHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.value.util.Severity;
import com.prelytis.dashboard.value.util.Thresholds;
import java.util.List;

public class ControlCrossTableDataFilter
extends DefaultDataFilter {
    private Thresholds thresholds;
    private int cellEltNum;
    private boolean firstRow;
    private ClassElementHelper classElementHelper;

    public Thresholds getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(Thresholds thresholds) {
        this.thresholds = thresholds;
    }

    @Override
    public void startRow(RowParameter row) throws DashboardException {
        List<RowCell> list = row.getCells();
        for (RowCell cell : list) {
            Value value = cell.getValue();
            Severity severity = SeverityHelper.getSeverity(this.thresholds, value);
            if (severity.getSeverity() == 0 || this.firstRow) continue;
            cell.setClassElement(this.classElementHelper.create(cell.getClassElement(), severity.getStringColor()));
        }
        if (this.firstRow) {
            this.firstRow = false;
        }
        super.startRow(row);
    }

    @Override
    public void startData(DataParameter data) throws DashboardException {
        super.startData(data);
        this.firstRow = true;
    }

    public int getCellEltNum() {
        return this.cellEltNum;
    }

    public void setCellEltNum(int cellEltNum) {
        this.cellEltNum = cellEltNum;
    }

    public ClassElementHelper getClassElementHelper() {
        return this.classElementHelper;
    }

    public void setClassElementHelper(ClassElementHelper classElementHelper) {
        this.classElementHelper = classElementHelper;
    }
}

