/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.transformation.AbstractDataHandler;
import com.prelytis.dashboard.data.transformation.parameter.ContainerParameter;
import com.prelytis.dashboard.data.transformation.parameter.DataParameter;
import com.prelytis.dashboard.data.transformation.parameter.RowCell;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.data.transformation.parameter.RuptureParameter;
import com.prelytis.dashboard.data.transformation.parameter.SectionParameter;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.helper.SeverityHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.value.util.Thresholds;

public class ControlDataHandler
extends AbstractDataHandler {
    private Thresholds[] thresholds;
    private int[] severities;
    private int col;

    @Override
    public void startContainer(ContainerParameter container) throws DashboardException {
        this.severities = new int[this.thresholds.length];
    }

    @Override
    public void endContainer(ContainerParameter container) throws DashboardException {
    }

    @Override
    public void startSection(SectionParameter section) throws DashboardException {
    }

    @Override
    public void endSection(SectionParameter section) throws DashboardException {
    }

    @Override
    public void startData(DataParameter data) throws DashboardException {
    }

    @Override
    public void endData(DataParameter data) throws DashboardException {
    }

    @Override
    public void startRow(RowParameter row) throws DashboardException {
        RowCell cell = row.getCells().get(this.getCol());
        Value value = cell.getValue();
        if (value != null) {
            SeverityHelper.updateSeverities(this.severities, this.thresholds, value.getObject());
        }
    }

    @Override
    public void endRow(RowParameter row) throws DashboardException {
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public int[] getSeverities() {
        return this.severities;
    }

    public Thresholds[] getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(Thresholds[] thresholds) {
        this.thresholds = thresholds;
    }

    @Override
    public void startRupture(RuptureParameter rupture) throws DashboardException {
    }

    @Override
    public void endRupture(RuptureParameter rupture) throws DashboardException {
    }
}

