/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.transformation.DefaultDataFilter;
import com.prelytis.dashboard.data.transformation.parameter.RowCell;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.data.transformation.parameter.RuptureParameter;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.helper.SeverityHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.value.util.Severity;
import com.prelytis.dashboard.value.util.Thresholds;

public class ControlStdDataFilter
extends DefaultDataFilter {
    private Thresholds thresholds;
    private boolean removeInfo;
    private int col;

    @Override
    public void startRow(RowParameter row) throws DashboardException {
        RowCell cell = row.getCells().get(this.col);
        Value value = cell.getValue();
        Severity severity = SeverityHelper.getSeverity(this.thresholds, value);
        if (severity.getSeverity() != 0) {
            row.setBackgroundColor(severity.getStringColor());
            super.startRow(row);
            super.endRow(row);
        } else if (!this.removeInfo) {
            super.startRow(row);
            super.endRow(row);
        }
    }

    @Override
    public void endRow(RowParameter row) throws DashboardException {
    }

    @Override
    public void endRupture(RuptureParameter rupture) throws DashboardException {
    }

    @Override
    public void startRupture(RuptureParameter rupture) throws DashboardException {
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public Thresholds getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(Thresholds thresholds) {
        this.thresholds = thresholds;
    }

    public boolean isRemoveInfo() {
        return this.removeInfo;
    }

    public void setRemoveInfo(boolean removeInfo) {
        this.removeInfo = removeInfo;
    }
}

