/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.transformation.interfaces.DataFilter;
import com.prelytis.dashboard.data.transformation.interfaces.DataHandler;
import com.prelytis.dashboard.data.transformation.interfaces.DataReader;
import com.prelytis.dashboard.data.transformation.parameter.ContainerParameter;
import com.prelytis.dashboard.data.transformation.parameter.DataParameter;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.data.transformation.parameter.RuptureParameter;
import com.prelytis.dashboard.data.transformation.parameter.SectionParameter;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.ErrorCode;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class DefaultDataFilter
implements DataHandler,
DataFilter {
    protected DataReader dataReader;
    protected DataHandler dataHandler;
    protected static final Logger log = LogManager.getLogger(DefaultDataFilter.class);

    @Override
    public DataReader getParent() {
        return this.dataReader;
    }

    @Override
    public void setParent(DataReader dataReader) {
        this.dataReader = dataReader;
        dataReader.setDataHandler(this);
    }

    @Override
    public void read() throws DashboardException {
        this.dataReader.read();
    }

    @Override
    public void setDataHandler(DataHandler dataHandler) {
        this.dataHandler = dataHandler;
    }

    @Override
    public void startContainer(ContainerParameter container) throws DashboardException {
        this.dataHandler.startContainer(container);
    }

    @Override
    public void endContainer(ContainerParameter container) throws DashboardException {
        this.dataHandler.endContainer(container);
    }

    @Override
    public void startSection(SectionParameter section) throws DashboardException {
        this.dataHandler.startSection(section);
    }

    @Override
    public void endSection(SectionParameter section) throws DashboardException {
        this.dataHandler.endSection(section);
    }

    @Override
    public void startRow(RowParameter row) throws DashboardException {
        this.dataHandler.startRow(row);
    }

    @Override
    public void endRow(RowParameter row) throws DashboardException {
        this.dataHandler.endRow(row);
    }

    @Override
    public void startData(DataParameter data) throws DashboardException {
        this.dataHandler.startData(data);
    }

    @Override
    public void endData(DataParameter data) throws DashboardException {
        this.dataHandler.endData(data);
    }

    protected void handleException(Exception e) throws DashboardException {
        if (e instanceof DashboardException) {
            throw (DashboardException)((Object)e);
        }
        if (e instanceof DashboardRuntimeException) {
            throw (DashboardRuntimeException)((Object)e);
        }
        log.error((Object)e);
        throw new DashboardRuntimeException(ErrorCode.INSIGHT_UNKNOWN, "unknown", (Throwable)e);
    }

    @Override
    public void endRupture(RuptureParameter rupture) throws DashboardException {
        this.dataHandler.endRupture(rupture);
    }

    @Override
    public void startRupture(RuptureParameter rupture) throws DashboardException {
        this.dataHandler.startRupture(rupture);
    }
}

