/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.transformation.AbstractDataReader;
import com.prelytis.dashboard.data.transformation.parameter.ContainerParameter;
import com.prelytis.dashboard.data.transformation.parameter.DataParameter;
import com.prelytis.dashboard.data.transformation.parameter.RowCell;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.db.value.ValueBigDecimal;
import com.prelytis.dashboard.db.value.ValueBoolean;
import com.prelytis.dashboard.db.value.ValueDateTime;
import com.prelytis.dashboard.db.value.ValueNull;
import com.prelytis.dashboard.db.value.ValueString;
import com.prelytis.dashboard.helper.FieldMetaDataHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.value.data.BeanImportColumn;
import com.prelytis.dashboard.value.data.BeanImportDefinition;
import com.prelytis.dashboard.value.data.BeanImportWorksheet;
import com.prelytis.dashboard.value.util.ClassElement;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.FieldMetaData;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.POIXMLProperties;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelDataReader
extends AbstractDataReader {
    private BeanImportDefinition definition;
    private String tableDescription;
    private String documentTitle;

    public ExcelDataReader(BeanImportDefinition definition) {
        this.definition = definition;
    }

    @Override
    public void read() throws DashboardException {
        try {
            POIXMLProperties.CoreProperties cp;
            POIXMLProperties p;
            HSSFWorkbook w;
            ArrayList<FieldMetaData> list = new ArrayList<FieldMetaData>();
            boolean hasData = false;
            List worksheetList = this.definition.getWorksheetList();
            if (worksheetList != null) {
                for (BeanImportWorksheet worksheet : worksheetList) {
                    if (!worksheet.isImportWorksheet() || worksheet.getColumnList() == null) continue;
                    hasData = true;
                    int cpt = 0;
                    if (this.tableDescription == null) {
                        this.tableDescription = worksheet.getName();
                    }
                    for (int c = worksheet.getStartCol(); c <= worksheet.getEndCol(); ++c) {
                        BeanImportColumn column = (BeanImportColumn)worksheet.getColumnList().get(c);
                        FieldMetaData fmd = new FieldMetaData();
                        fmd.setObjectID(cpt++);
                        fmd.setName(column.getName());
                        fmd.setDataType(column.getDatatype());
                        fmd.setFieldPrecision(column.getFieldPrecision());
                        fmd.setFieldScale(column.getFieldScale());
                        fmd.setFieldSize(column.getFieldSize());
                        fmd.setNullable(true);
                        fmd.setAutoIncrement(false);
                        list.add(fmd);
                    }
                }
            }
            ArrayList<FieldMetaData> newList = new ArrayList<FieldMetaData>();
            for (FieldMetaData fmd : list) {
                newList.add(FieldMetaDataHelper.getCopy(fmd));
            }
            DataParameter def = new DataParameter();
            def.setNbCols(list.size());
            def.setMetaDataList(newList);
            Workbook workbook = WorkbookFactory.create((InputStream)new ByteArrayInputStream(this.definition.getData()));
            FormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
            if (workbook instanceof HSSFWorkbook) {
                w = (HSSFWorkbook)workbook;
                SummaryInformation si = w.getSummaryInformation();
                if (si != null) {
                    this.documentTitle = si.getTitle();
                }
            } else if (workbook instanceof XSSFWorkbook && (p = (w = (XSSFWorkbook)workbook).getProperties()) != null && (cp = p.getCoreProperties()) != null) {
                this.documentTitle = cp.getTitle();
            }
            ClassElement defaultClassElement = new ClassElement();
            defaultClassElement.setName("tbl-body");
            String defaultFormat = "{0}";
            int rowNum = 0;
            DataFormatter df = new DataFormatter();
            ContainerParameter container = new ContainerParameter();
            this.dataHandler.startContainer(container);
            if (hasData && worksheetList != null) {
                this.dataHandler.startData(def);
                for (BeanImportWorksheet worksheet : worksheetList) {
                    Sheet sheet;
                    if (!worksheet.isImportWorksheet() || worksheet.getColumnList() == null || (sheet = workbook.getSheet(worksheet.getName())) == null) continue;
                    int endRow = worksheet.getEndRow();
                    endRow = endRow == -1 ? sheet.getLastRowNum() : Math.min(endRow, sheet.getLastRowNum());
                    ArrayList<CellRangeAddress> ranges = new ArrayList<CellRangeAddress>();
                    for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
                        ranges.add(sheet.getMergedRegion(i));
                    }
                    int firstRow = worksheet.getStartRow();
                    if (worksheet.isFirstRowTitle()) {
                        // empty if block
                    }
                    for (int r = ++firstRow; r <= endRow; ++r) {
                        Row row = sheet.getRow(r);
                        if (row == null) continue;
                        ++rowNum;
                        RowParameter rp = new RowParameter();
                        List<RowCell> colList = rp.getCells();
                        for (int c = worksheet.getStartCol(); c <= worksheet.getEndCol(); ++c) {
                            BeanImportColumn column = (BeanImportColumn)worksheet.getColumnList().get(c);
                            int col = column.getColumnIndex();
                            Cell cell = null;
                            for (CellRangeAddress range : ranges) {
                                Row rr;
                                if (col < range.getFirstColumn() || col > range.getLastColumn() || r < range.getFirstRow() || r > range.getLastRow() || (rr = r == range.getFirstRow() ? row : sheet.getRow(range.getFirstRow())) == null) continue;
                                cell = rr.getCell(range.getFirstColumn());
                                break;
                            }
                            if (cell == null) {
                                cell = row.getCell(col);
                            }
                            ValueBoolean value = null;
                            if (cell != null) {
                                try {
                                    evaluator.evaluateInCell(cell);
                                }
                                catch (Exception e) {
                                    cell = null;
                                }
                            }
                            if (cell != null) {
                                switch (cell.getCellType()) {
                                    case 3: {
                                        break;
                                    }
                                    case 5: {
                                        break;
                                    }
                                    case 4: {
                                        value = cell.getBooleanCellValue() ? ValueBoolean.TRUE : ValueBoolean.FALSE;
                                        break;
                                    }
                                    case 0: {
                                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                            value = new ValueDateTime(cell.getDateCellValue().getTime());
                                            break;
                                        }
                                        value = new ValueBigDecimal(BigDecimal.valueOf(cell.getNumericCellValue()));
                                        break;
                                    }
                                    case 1: {
                                        value = new ValueString(cell.getRichStringCellValue().getString());
                                    }
                                }
                            }
                            if (value == null) {
                                value = DataType.isDate((DataType)column.getDatatype()) ? ValueNull.DATETIME : (DataType.isNumeric((DataType)column.getDatatype()) ? ValueNull.BIG_DECIMAL : ValueNull.STRING);
                            } else if (DataType.isDate((DataType)column.getDatatype())) {
                                if (!(value instanceof ValueDateTime)) {
                                    value = ValueNull.DATETIME;
                                }
                            } else if (DataType.isNumeric((DataType)column.getDatatype())) {
                                if (!(value instanceof ValueBigDecimal)) {
                                    value = ValueNull.BIG_DECIMAL;
                                }
                            } else if (!(value instanceof ValueString)) {
                                value = new ValueString(df.formatCellValue(cell));
                            }
                            colList.add(new RowCell((Value)value, defaultClassElement, "{0}"));
                        }
                        this.dataHandler.startRow(rp);
                        this.dataHandler.endRow(rp);
                        rp.setRowNumber(rowNum);
                    }
                }
                this.dataHandler.endData(def);
            }
            container.setIgnoredData(false);
            this.dataHandler.endContainer(container);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public String getTableDescription() {
        return this.tableDescription;
    }

    public String getDocumentTitle() {
        return this.documentTitle;
    }
}

