/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.calculation.CalculationSimple;
import com.prelytis.dashboard.data.transformation.InlineCalculationDefinition;
import com.prelytis.dashboard.data.transformation.parameter.RowCell;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.interfaces.DashboardException;
import java.util.List;

public class InlineCalculationHelper {
    private int decal;
    private List<InlineCalculationDefinition> calculationList;

    public List<InlineCalculationDefinition> getCalculationList() {
        return this.calculationList;
    }

    public void setCalculationList(List<InlineCalculationDefinition> calculationList) {
        this.calculationList = calculationList;
    }

    public void updateCalculation(RowParameter row) throws DashboardException {
        if (this.calculationList != null) {
            List<RowCell> list = row.getCells();
            for (InlineCalculationDefinition calculation : this.calculationList) {
                RowCell cell = list.get(this.decal + calculation.getCol());
                Value value = cell.getValue();
                if (value == null) continue;
                CalculationSimple cs = calculation.getCalculation();
                cs.addValue(value);
                cell.setValue(cs.getValue());
                if (!calculation.isPercent()) continue;
                cell.setPercent(true);
            }
        }
    }

    public void resetCalculation() {
        if (this.calculationList != null) {
            for (InlineCalculationDefinition calculation : this.calculationList) {
                calculation.getCalculation().reset();
            }
        }
    }

    public int getDecal() {
        return this.decal;
    }

    public void setDecal(int decal) {
        this.decal = decal;
    }
}

