/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.transformation.AbstractDataHandler;
import com.prelytis.dashboard.data.transformation.parameter.ContainerParameter;
import com.prelytis.dashboard.data.transformation.parameter.DataParameter;
import com.prelytis.dashboard.data.transformation.parameter.RowCell;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.data.transformation.parameter.RuptureParameter;
import com.prelytis.dashboard.data.transformation.parameter.SectionParameter;
import com.prelytis.dashboard.db.value.ValueDecimalNumber;
import com.prelytis.dashboard.interfaces.DashboardException;
import java.math.BigDecimal;
import java.math.MathContext;

public class MetricDataHandler
extends AbstractDataHandler {
    private int calcMode;
    private int calcExtent;
    private int col;
    private BigDecimal metric;
    private long rows;

    @Override
    public void startContainer(ContainerParameter container) throws DashboardException {
        this.rows = 0L;
    }

    @Override
    public void endContainer(ContainerParameter container) throws DashboardException {
    }

    @Override
    public void startSection(SectionParameter section) throws DashboardException {
    }

    @Override
    public void endSection(SectionParameter section) throws DashboardException {
    }

    @Override
    public void startData(DataParameter data) throws DashboardException {
    }

    @Override
    public void endData(DataParameter data) throws DashboardException {
    }

    @Override
    public void startRow(RowParameter row) throws DashboardException {
        if (this.rows >= (long)this.calcExtent && this.calcExtent > 0) {
            return;
        }
        RowCell rowCell = row.getCells().get(this.col);
        ValueDecimalNumber value = null;
        if (rowCell.getValue() instanceof ValueDecimalNumber) {
            value = (ValueDecimalNumber)rowCell.getValue();
        }
        if (value != null) {
            if (this.metric == null) {
                this.metric = value.getDecimalValue();
            } else {
                switch (this.calcMode) {
                    case 1: {
                        this.metric = this.metric.add(value.getDecimalValue());
                        break;
                    }
                    case 2: {
                        this.metric = this.metric.add(value.getDecimalValue());
                        break;
                    }
                    case 3: {
                        this.metric = this.metric.min(value.getDecimalValue());
                        break;
                    }
                    case 4: {
                        this.metric = this.metric.max(value.getDecimalValue());
                    }
                }
            }
            ++this.rows;
        }
    }

    @Override
    public void endRow(RowParameter row) throws DashboardException {
    }

    public BigDecimal getMetric() {
        if (this.metric == null) {
            return null;
        }
        if (this.calcMode == 2) {
            return this.metric.divide(BigDecimal.valueOf(this.rows), MathContext.DECIMAL32);
        }
        return this.metric;
    }

    public int getCalcMode() {
        return this.calcMode;
    }

    public void setCalcMode(int calcMode) {
        this.calcMode = calcMode;
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public int getCalcExtent() {
        return this.calcExtent;
    }

    public void setCalcExtent(int calcExtent) {
        this.calcExtent = calcExtent;
    }

    @Override
    public void startRupture(RuptureParameter rupture) throws DashboardException {
    }

    @Override
    public void endRupture(RuptureParameter rupture) throws DashboardException {
    }
}

