/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.transformation.CalculationHelper;
import com.prelytis.dashboard.data.transformation.DefaultDataFilter;
import com.prelytis.dashboard.data.transformation.parameter.DataParameter;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.interfaces.DashboardException;
import java.util.LinkedList;
import java.util.List;

public class RankDataFilter
extends DefaultDataFilter {
    private int rows;
    private int topRows;
    private int bottomRows;
    private CalculationHelper calculationHelper;
    private List<RowParameter> fifoList = new LinkedList<RowParameter>();

    @Override
    public void endRow(RowParameter row) throws DashboardException {
        if (this.topRows > this.rows) {
            this.dataHandler.endRow(row);
            ++this.rows;
        } else if (this.fifoList.size() > this.bottomRows) {
            RowParameter deletedRow = this.fifoList.remove(0);
            if (this.calculationHelper != null) {
                this.calculationHelper.updateCalculation(deletedRow);
            }
        }
    }

    @Override
    public void startRow(RowParameter row) throws DashboardException {
        if (this.topRows > this.rows) {
            this.dataHandler.startRow(row);
        } else {
            this.fifoList.add(row);
        }
    }

    @Override
    public void endData(DataParameter data) throws DashboardException {
        if (this.calculationHelper != null) {
            RowParameter[] rs = this.calculationHelper.getCalculatedRows();
            if (rs != null) {
                for (RowParameter r : rs) {
                    this.dataHandler.startRow(r);
                    this.dataHandler.endRow(r);
                }
            }
            this.calculationHelper.resetCalculation();
        }
        if (!this.fifoList.isEmpty()) {
            for (RowParameter row : this.fifoList) {
                this.dataHandler.startRow(row);
                this.dataHandler.endRow(row);
            }
        }
        super.endData(data);
    }

    @Override
    public void startData(DataParameter data) throws DashboardException {
        this.fifoList.clear();
        this.rows = 0;
        super.startData(data);
    }

    public int getTopRows() {
        return this.topRows;
    }

    public void setTopRows(int topRows) {
        this.topRows = topRows;
    }

    public int getBottomRows() {
        return this.bottomRows;
    }

    public void setBottomRows(int bottomRows) {
        this.bottomRows = bottomRows;
    }

    public CalculationHelper getCalculationHelper() {
        return this.calculationHelper;
    }

    public void setCalculationHelper(CalculationHelper calculationHelper) {
        this.calculationHelper = calculationHelper;
    }
}

