/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.transformation.PrevColumnCalculationHelper;
import com.prelytis.dashboard.data.transformation.parameter.AbstractRowParameter;
import com.prelytis.dashboard.data.transformation.parameter.RowCell;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.db.value.ValueBigDecimal;
import com.prelytis.dashboard.db.value.ValueDecimalNumber;
import com.prelytis.dashboard.db.value.ValueNull;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;

public class RatioCalculationHelper
implements PrevColumnCalculationHelper {
    private int decal;
    private List<Integer> calculationList;

    @Override
    public List<Integer> getCalculationList() {
        return this.calculationList;
    }

    @Override
    public void setCalculationList(List<Integer> calculationList) {
        this.calculationList = calculationList;
    }

    @Override
    public void updateCalculation(AbstractRowParameter row) {
        if (this.calculationList != null) {
            List<RowCell> list = row.getCells();
            for (Integer col : this.calculationList) {
                if (col <= 0) continue;
                RowCell cell1 = list.get(this.decal + col - 1);
                Value value1 = cell1.getValue();
                RowCell cell2 = list.get(this.decal + col);
                Value value2 = cell2.getValue();
                if (value1 instanceof ValueDecimalNumber && value2 instanceof ValueDecimalNumber) {
                    BigDecimal d = ((ValueDecimalNumber)value1).getDecimalValue();
                    BigDecimal n = ((ValueDecimalNumber)value2).getDecimalValue();
                    if (d.signum() == 0) {
                        cell2.setValue((Value)ValueNull.BIG_DECIMAL);
                        continue;
                    }
                    cell2.setValue((Value)new ValueBigDecimal(n.divide(d, MathContext.DECIMAL32)));
                    continue;
                }
                cell2.setValue((Value)ValueNull.BIG_DECIMAL);
            }
        }
    }
}

