/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.helper.NoDataHelper;
import com.prelytis.dashboard.data.link.LinkHelperStd;
import com.prelytis.dashboard.data.transformation.AbstractDataHandler;
import com.prelytis.dashboard.data.transformation.CellEltFactory;
import com.prelytis.dashboard.data.transformation.parameter.CalculatedRowParameter;
import com.prelytis.dashboard.data.transformation.parameter.CalculationParameter;
import com.prelytis.dashboard.data.transformation.parameter.ContainerParameter;
import com.prelytis.dashboard.data.transformation.parameter.DataParameter;
import com.prelytis.dashboard.data.transformation.parameter.RowCell;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.data.transformation.parameter.RuptureParameter;
import com.prelytis.dashboard.data.transformation.parameter.SectionParameter;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.db.value.ValueDecimalNumber;
import com.prelytis.dashboard.helper.ClassElementHelper;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.util.Compare;
import com.prelytis.dashboard.util.DataExpressionParser;
import com.prelytis.dashboard.util.ExpressionEvaluationHelper;
import com.prelytis.dashboard.util.GuidFactory;
import com.prelytis.dashboard.util.TableFactory;
import com.prelytis.dashboard.value.chart.Cell;
import com.prelytis.dashboard.value.chart.CellHeader;
import com.prelytis.dashboard.value.chart.CellHeaderElt;
import com.prelytis.dashboard.value.chart.CellValue;
import com.prelytis.dashboard.value.chart.CellValueElt;
import com.prelytis.dashboard.value.chart.ColRow;
import com.prelytis.dashboard.value.chart.DisplayProperties;
import com.prelytis.dashboard.value.chart.LinkList;
import com.prelytis.dashboard.value.chart.Table;
import com.prelytis.dashboard.value.data.BeanColorListElement;
import com.prelytis.dashboard.value.data.BeanDisplayType;
import com.prelytis.dashboard.value.data.BeanReportStd;
import com.prelytis.dashboard.value.data.BeanReportStdHeader;
import com.prelytis.dashboard.value.data.BeanReportStdUsedField;
import com.prelytis.dashboard.value.data.BeanStyleDefinition;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.structure.Document;
import com.prelytis.dashboard.value.structure.ReportDocument;
import com.prelytis.dashboard.value.structure.SectionDocument;
import com.prelytis.dashboard.value.structure.TableDocument;
import com.prelytis.dashboard.value.util.ClassElement;
import com.prelytis.dashboard.value.util.ColorList;
import com.prelytis.dashboard.value.util.ConstantExpression;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.Expression;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.StyleElement;
import com.prelytis.dashboard.value.util.Thresholds;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.TimeZone;

public abstract class TableContainerStdDataHandler
extends AbstractDataHandler {
    private final ExpressionEvaluationHelper helper = ExpressionEvaluationHelper.getInstance();
    private final DataExpressionParser ep = DataExpressionParser.getInstance();
    private BeanReportStd report;
    private Stack<SectionDocument> sectionStack;
    private final ReportDocument document = new ReportDocument();
    protected Table currentTable;
    private Table defaultTable;
    private Locale locale;
    private TimeZone timeZone;
    protected CellEltFactory cellEltFactory;
    private ClassElementHelper ceh;
    private LinkHelperStd linkHelper;
    private Thresholds thresholds;
    private BeanStyleDefinition style;
    protected ColRow previousRow;
    private boolean[] eraseOnCols;
    private String[] rowHeights = null;
    protected String[] calcRowHeights = null;
    private boolean startRowCalled = false;
    private ExpressionEvaluationData data;
    private Map<String, ReportFilter> filterMap;
    private boolean directLink;
    private List<BeanColorListElement> colorList;
    private final GuidFactory guidFactory = GuidFactory.getInstance();
    private boolean pageBreakOnSection;

    @Override
    public void startContainer(ContainerParameter container) throws DashboardException {
        this.cellEltFactory = new CellEltFactory();
        this.cellEltFactory.setDateFormat(this.style.getFormatDate());
        this.cellEltFactory.setNumericFormat(this.style.getFormatNumeric());
        this.cellEltFactory.setDefaultFormat(this.style.getFormatString());
        this.cellEltFactory.setPercentFormat(this.style.getFormatPercent());
        this.ceh = new ClassElementHelper();
        try {
            String description;
            CellHeaderElt elt;
            List fieldList = this.report.getFieldList();
            this.defaultTable = TableFactory.getStdTable((TimeZone)this.timeZone, (Locale)this.locale, (int)fieldList.size());
            ColRow header = TableFactory.addRow((Table)this.defaultTable);
            Object[] hs = new String[this.report.getHeaderLineList().size() + 1];
            Arrays.fill(hs, this.report.getHeaderSize());
            header.setSize((String[])hs);
            this.rowHeights = new String[]{this.report.getBodySize()};
            this.calcRowHeights = new String[]{this.report.getCalculationLineSize()};
            for (int i = 0; i < fieldList.size(); ++i) {
                BeanReportStdUsedField field = (BeanReportStdUsedField)fieldList.get(i);
                ColRow col = (ColRow)this.defaultTable.getCols().get(i);
                col.setDataType(field.getDataType());
                String[] widths = new String[]{field.getSize()};
                col.setSize(widths);
                elt = new CellHeaderElt();
                description = (String)field.getDescriptionMap().get(this.locale);
                elt.setValue((Object)this.getDescription(description));
                elt.setClassElement(this.ceh.getClassElement("tbl-header", field.getHeaderStyle()));
                elt.setFormat("{0}");
                elt.setNbReferences(1);
                elt.setCellEltNum(this.report.getHeaderLineList().isEmpty() ? (byte)0 : 1);
                CellHeader cellHeader = (CellHeader)header.get(i);
                cellHeader.setCellHeaderElt(elt);
                cellHeader.setProperty("fieldName", field.getField().getName());
            }
            for (List stdHeaders : this.report.getHeaderLineList()) {
                for (BeanReportStdHeader stdHeader : stdHeaders) {
                    elt = new CellHeaderElt();
                    description = (String)stdHeader.getDescriptionMap().get(this.locale);
                    elt.setValue((Object)this.getDescription(description));
                    elt.setClassElement(this.ceh.getClassElement("tbl-header", stdHeader.getStyle()));
                    elt.setFormat("{0}");
                    int span = stdHeader.getSpan();
                    elt.setLinkList((List)LinkList.NOLINK);
                    elt.setCellEltNum((byte)0);
                    for (int i = 0; i < stdHeader.getSpan(); ++i) {
                        int col = stdHeader.getFirstColId() + i;
                        Cell cell = (Cell)header.get(col);
                        BeanReportStdUsedField field = (BeanReportStdUsedField)fieldList.get(col);
                        if (!field.isVisible()) {
                            --span;
                        }
                        if (!(cell instanceof CellHeader)) continue;
                        CellHeader cellHeader = (CellHeader)cell;
                        CellHeaderElt c = cellHeader.getCellHeaderElt();
                        c.setParent(elt);
                    }
                    elt.setNbReferences(span);
                }
            }
            int finalNbCols = 0;
            for (int j = 0; j < fieldList.size(); ++j) {
                BeanReportStdUsedField field = (BeanReportStdUsedField)fieldList.get(j);
                if (!field.isVisible()) continue;
                ++finalNbCols;
            }
            this.fillFinalStdTable(this.defaultTable, finalNbCols, this.colorList);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private String getDescription(String description) throws DashboardException {
        if (description == null) {
            return "";
        }
        Expression expression = this.ep.parseExpression(DataType.VARCHAR, description);
        if (expression != null) {
            if (expression instanceof ConstantExpression) {
                return ((ConstantExpression)expression).getValue();
            }
            Object v = this.helper.evaluateExpression(expression, this.data, this.filterMap);
            if (v instanceof String) {
                return (String)v;
            }
            if (v instanceof Object[]) {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (Object o : (Object[])v) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append("/");
                    }
                    sb.append(o);
                }
                return sb.toString();
            }
            if (v != null) {
                return v.toString();
            }
        }
        return description;
    }

    @Override
    public void endContainer(ContainerParameter container) throws DashboardException {
        try {
            BeanDisplayType displayType;
            DisplayProperties displayProps;
            if (container.getNbCalculatedRows() > 0) {
                if (this.currentTable == null) {
                    if (this.document.size() == 1 && this.document.get(0) instanceof TableDocument) {
                        TableDocument td = (TableDocument)this.document.get(0);
                        this.currentTable = td.getTable();
                        if (this.report.getColRowInversion()) {
                            TableFactory.transpose((Table)this.currentTable);
                        }
                        this.sendData(container);
                        if (this.report.getColRowInversion()) {
                            TableFactory.transpose((Table)this.currentTable);
                        }
                    } else if (!this.document.isEmpty()) {
                        this.currentTable = this.getClonedDefaultTable();
                        this.sendData(container);
                        TableDocument td = new TableDocument();
                        td.setName(this.guidFactory.generateGUID((Object)td));
                        td.setTable(this.currentTable);
                        this.document.add((Document)td);
                        if (this.report.getColRowInversion()) {
                            TableFactory.transpose((Table)this.currentTable);
                        }
                    }
                }
            } else if (this.document.size() == 0 && (displayProps = this.report.getDisplayProperties()) != null && (BeanDisplayType.TABLE == (displayType = displayProps.getDisplayType()) || BeanDisplayType.SEARCH == displayType)) {
                StyleElement bs;
                this.currentTable = this.getClonedDefaultTable();
                TableDocument td = new TableDocument();
                td.setName(this.guidFactory.generateGUID((Object)td));
                td.setTable(this.currentTable);
                ClassElement ce = this.ceh.getClassElement("tbl-body");
                StyleElement bodyStyle = new StyleElement();
                List fieldList = this.report.getFieldList();
                if (fieldList.size() > 0 && (bs = ((BeanReportStdUsedField)fieldList.get(0)).getBodyStyle()) != null) {
                    bodyStyle = bs;
                }
                RowParameter row = NoDataHelper.buildNoDataRow(ce, bodyStyle, this.locale, this.currentTable.getCols().size());
                this.startRow(row);
                this.endRow(row);
                if (this.report.getColRowInversion()) {
                    TableFactory.transpose((Table)this.currentTable);
                }
                this.document.add((Document)td);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.document.setIgnoredDatas(container.isIgnoredData());
        this.ceh.clear();
        this.ceh = null;
    }

    @Override
    public void startSection(SectionParameter section) throws DashboardException {
        try {
            this.currentTable = this.getClonedDefaultTable();
            SectionDocument s = new SectionDocument();
            Value value = section.getValue();
            s.setData((Serializable)value.getObject());
            s.setPattern(section.getFormat());
            s.setClassElement(section.getClassElement());
            s.setPageBreakBefore(this.pageBreakOnSection);
            this.document.add((Document)s);
            if (this.sectionStack == null) {
                this.sectionStack = new Stack();
            }
            this.sectionStack.push(s);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void endSection(SectionParameter section) throws DashboardException {
        try {
            if (section.getNbCalculatedRows() > 0) {
                if (this.currentTable == null) {
                    this.currentTable = this.getClonedDefaultTable();
                }
                this.sendData(section);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (this.currentTable != null) {
            if (this.report.getColRowInversion()) {
                TableFactory.transpose((Table)this.currentTable);
            }
            TableDocument td = new TableDocument();
            td.setName(this.guidFactory.generateGUID((Object)this));
            td.setTable(this.currentTable);
            this.document.add((Document)td);
            if (this.linkHelper != null) {
                this.linkHelper.setLinks(this.currentTable, this.sectionStack);
            }
        }
        this.sectionStack.pop();
        this.currentTable = null;
        this.previousRow = null;
    }

    @Override
    public void startRow(RowParameter row) throws DashboardException {
        try {
            List<RowCell> list = row.getCells();
            if (this.currentTable.getCols().size() != list.size()) {
                throw ExceptionHelper.getInstance(this.locale).createDashboardException("invalidNumberOfRow", new String[]{String.valueOf(this.currentTable.getCols().size()), String.valueOf(list.size())}, null);
            }
            if (!this.startRowCalled) {
                this.startRowCalled = true;
            }
            ColRow tableRow = TableFactory.addRow((Table)this.currentTable);
            tableRow.setSize(this.rowHeights);
            Map keyValues = row.getAttributeAs("primaryKeyValues", Map.class);
            tableRow.setPrimaryKeyValues(keyValues);
            Integer rowNumber = row.getAttributeAs("rowNumber", Integer.class);
            tableRow.setRowNumber(rowNumber);
            Map criteriaFieldValues = row.getAttributeAs("criteriaFieldValues", Map.class);
            tableRow.setCriteriaFieldValues(criteriaFieldValues);
            for (int i = 0; i < list.size(); ++i) {
                CellValue cell = (CellValue)tableRow.get(i);
                RowCell rowCell = list.get(i);
                this.cellEltFactory.setCellValue((Cell)cell, rowCell);
                if (!this.eraseOnCols[i] || this.previousRow == null) continue;
                try {
                    CellValue previousCell = (CellValue)this.previousRow.get(i);
                    CellValueElt[] curCellElt = cell.getCellValueElt();
                    CellValueElt[] previousCellElt = previousCell.getCellValueElt();
                    for (int j = 0; j < previousCellElt.length; ++j) {
                        CellValueElt previousValElt = previousCellElt[j];
                        CellValueElt curValElt = curCellElt[j];
                        if (Compare.compare((Object)previousValElt.getValue(), (Object)curValElt.getValue()) != 0) continue;
                        curCellElt[j] = previousValElt;
                        previousValElt.setNbReferences(previousValElt.getNbReferences() + 1);
                    }
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
            this.previousRow = tableRow;
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void endRow(RowParameter row) {
    }

    @Override
    public void startData(DataParameter data) throws DashboardException {
        this.startRowCalled = false;
        try {
            if (this.currentTable == null) {
                this.currentTable = this.getClonedDefaultTable();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void endData(DataParameter data) throws DashboardException {
        if (this.currentTable != null && this.sectionStack == null && this.startRowCalled) {
            if (this.report.getColRowInversion()) {
                TableFactory.transpose((Table)this.currentTable);
            }
            if (TableFactory.hasData((Table)this.currentTable)) {
                TableDocument td = new TableDocument();
                td.setName(this.guidFactory.generateGUID((Object)td));
                td.setTable(this.currentTable);
                this.document.add((Document)td);
                if (this.linkHelper != null) {
                    this.linkHelper.setLinks(this.currentTable, null);
                }
            }
            this.currentTable = null;
            this.previousRow = null;
        }
    }

    @Override
    public void startRupture(RuptureParameter rupture) throws DashboardException {
    }

    @Override
    public void endRupture(RuptureParameter rupture) throws DashboardException {
        this.sendData(rupture);
    }

    private Table getClonedDefaultTable() throws CloneNotSupportedException {
        Table table = TableFactory.getCopy((Table)this.defaultTable);
        ColRow row = (ColRow)table.getRows().get(0);
        for (int i = 0; i < table.getCols().size(); ++i) {
            Cell cell = (Cell)row.get(i);
            TableFactory.getCellElt((Cell)cell, (int)0).setLinkList((List)LinkList.NOLINK);
        }
        return table;
    }

    abstract void sendData(CalculationParameter var1) throws DashboardException;

    private void fillFinalStdTable(Table table, int finalNbCols, List<BeanColorListElement> colorList) throws Exception {
        int j;
        ColorList chartColorList = new ColorList();
        table.setColorList(chartColorList);
        int pos = 0;
        int[] colNum = new int[finalNbCols];
        List fieldList = this.report.getFieldList();
        for (j = 0; j < fieldList.size(); ++j) {
            BeanReportStdUsedField field = (BeanReportStdUsedField)fieldList.get(j);
            if (!field.isVisible()) continue;
            colNum[pos++] = j;
        }
        table.getCols().getColRowType().setFinalColRowNum(colNum);
        table.setThresholds(this.thresholds);
        table.setDirectLink(this.directLink);
        if (colorList != null) {
            for (j = 0; j < colorList.size(); ++j) {
                chartColorList.addColor((Object)colorList.get(j).getColor());
            }
        }
    }

    public LinkHelperStd getLinkHelper() {
        return this.linkHelper;
    }

    public void setLinkHelper(LinkHelperStd linkHelper) {
        this.linkHelper = linkHelper;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public BeanReportStd getReport() {
        return this.report;
    }

    public void setReport(BeanReportStd report) {
        this.report = report;
    }

    public Thresholds getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(Thresholds thresholds) {
        this.thresholds = thresholds;
    }

    public void setStyle(BeanStyleDefinition style) {
        this.style = style;
    }

    public BeanStyleDefinition getStyle() {
        return this.style;
    }

    public boolean[] getEraseOnCols() {
        return this.eraseOnCols;
    }

    public void setEraseOnCols(boolean[] eraseOnCols) {
        this.eraseOnCols = eraseOnCols;
    }

    public void setData(ExpressionEvaluationData data) {
        this.data = data;
    }

    public void setFilterMap(Map<String, ReportFilter> filterMap) {
        this.filterMap = filterMap;
    }

    public boolean isDirectLink() {
        return this.directLink;
    }

    public void setDirectLink(boolean directLink) {
        this.directLink = directLink;
    }

    public List<BeanColorListElement> getColorList() {
        return this.colorList;
    }

    public void setColorList(List<BeanColorListElement> colorList) {
        this.colorList = colorList;
    }

    public ReportDocument getDocument() {
        return this.document;
    }

    public boolean isPageBreakOnSection() {
        return this.pageBreakOnSection;
    }

    public void setPageBreakOnSection(boolean pageBreakOnSection) {
        this.pageBreakOnSection = pageBreakOnSection;
    }

    public static class MarkerHandler
    extends TableContainerStdDataHandler {
        private final int[] cols;
        private final int[] rows;

        public MarkerHandler(int[] cols, int[] rows) {
            this.cols = cols;
            this.rows = rows;
        }

        @Override
        void sendData(CalculationParameter definition) throws DashboardException {
            try {
                this.previousRow = null;
                ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
                int nb = this.cols.length;
                for (int i = 0; i < nb; ++i) {
                    CalculatedRowParameter row = definition.getCalculatedRow(this.rows[i]);
                    List<RowCell> cells = row.getCells();
                    RowCell x = cells.get(this.cols[i]);
                    BigDecimal n = x.getValue() instanceof ValueDecimalNumber ? ((ValueDecimalNumber)x.getValue()).getDecimalValue() : null;
                    list.add(n);
                }
                this.currentTable.setMarkerValues(list);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    public static class ChartHandler
    extends TableContainerStdDataHandler {
        @Override
        void sendData(CalculationParameter definition) throws DashboardException {
            this.previousRow = null;
        }
    }

    public static class DefaultHandler
    extends TableContainerStdDataHandler {
        @Override
        void sendData(CalculationParameter definition) throws DashboardException {
            try {
                this.previousRow = null;
                for (int i = 0; i < definition.getNbCalculatedRows(); ++i) {
                    CalculatedRowParameter row = definition.getCalculatedRow(i);
                    ColRow tableRow = TableFactory.addRow((Table)this.currentTable);
                    tableRow.setSize(this.calcRowHeights);
                    List<RowCell> cells = row.getCells();
                    int decal = cells.size() - tableRow.size();
                    for (int j = 0; j < tableRow.size(); ++j) {
                        CellValue cell = (CellValue)tableRow.get(j);
                        RowCell rowCell = cells.get(decal + j);
                        this.cellEltFactory.setCellValue((Cell)cell, rowCell);
                        CellValueElt[] cellValueElt = cell.getCellValueElt();
                        if (cellValueElt == null || cellValueElt.length == 0) continue;
                        CellValueElt valueElt = cellValueElt[0];
                        valueElt.setLinkList((List)LinkList.NOLINK);
                    }
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }
}

