/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.transformation.AbstractDataHandler;
import com.prelytis.dashboard.data.transformation.parameter.ContainerParameter;
import com.prelytis.dashboard.data.transformation.parameter.DataParameter;
import com.prelytis.dashboard.data.transformation.parameter.RowCell;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.data.transformation.parameter.RuptureParameter;
import com.prelytis.dashboard.data.transformation.parameter.SectionParameter;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.value.data.ValueListElt;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class ValueListDataHandler
extends AbstractDataHandler {
    private List<ValueListElt> list;
    private boolean oneCol;
    private MessageFormat mf;
    private final Locale locale;

    public ValueListDataHandler(String format, Locale locale, TimeZone tz) {
        this.locale = locale;
        String fmt = format == null || "".equals(format) ? "{0}" : format;
        try {
            this.mf = new MessageFormat(fmt, locale);
        }
        catch (Exception e) {
            this.mf = new MessageFormat("{0}", locale);
        }
        for (Format f : this.mf.getFormats()) {
            if (!(f instanceof DateFormat)) continue;
            ((DateFormat)f).setTimeZone(tz);
        }
    }

    @Override
    public void startContainer(ContainerParameter container) throws DashboardException {
        this.list = new ArrayList<ValueListElt>();
    }

    @Override
    public void endContainer(ContainerParameter container) throws DashboardException {
    }

    @Override
    public void startSection(SectionParameter section) throws DashboardException {
        throw ExceptionHelper.getInstance(this.locale).createDashboardException("notImplemented", null, null);
    }

    @Override
    public void endSection(SectionParameter section) throws DashboardException {
        throw ExceptionHelper.getInstance(this.locale).createDashboardException("notImplemented", null, null);
    }

    @Override
    public void startData(DataParameter data) throws DashboardException {
        switch (data.getNbCols()) {
            case 0: {
                throw ExceptionHelper.getInstance(this.locale).createDashboardException("noValidData", null, null);
            }
            case 1: {
                this.oneCol = true;
                break;
            }
            default: {
                this.oneCol = false;
            }
        }
    }

    @Override
    public void endData(DataParameter data) throws DashboardException {
    }

    @Override
    public void startRow(RowParameter row) throws DashboardException {
        RowCell rowCell = row.getCells().get(0);
        if (rowCell == null) {
            return;
        }
        Value v = rowCell.getValue();
        ValueListElt elt = new ValueListElt();
        if (this.oneCol) {
            elt.setValue(v.getObject());
            elt.setDescription(this.mf.format(new Object[]{v.getObject()}));
        } else {
            elt.setValue(v.getObject());
            rowCell = row.getCells().get(1);
            if (rowCell != null) {
                v = rowCell.getValue();
            }
            elt.setDescription(this.mf.format(new Object[]{v.getObject()}));
        }
        if (elt != null && elt.getValue() != null && elt.getDescription() != null) {
            this.list.add(elt);
        }
    }

    @Override
    public void endRow(RowParameter row) throws DashboardException {
    }

    public List<ValueListElt> getValueList() {
        return this.list;
    }

    @Override
    public void startRupture(RuptureParameter rupture) throws DashboardException {
    }

    @Override
    public void endRupture(RuptureParameter rupture) throws DashboardException {
    }
}

