/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.document.factory;

import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.value.structure.AbstractDocument;
import com.prelytis.dashboard.value.structure.ImageDocument;
import java.awt.HeadlessException;
import java.util.Locale;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AbstractFactoryTable {
    protected final AbstractDocument document;
    protected final Locale locale;

    public AbstractFactoryTable(AbstractDocument document, Locale locale) {
        this.locale = locale;
        this.document = document;
    }

    protected DashboardException getException(Exception e) {
        if (e instanceof DashboardException) {
            return (DashboardException)((Object)e);
        }
        Logger log = LogManager.getLogger(this.getClass());
        log.error((Object)e);
        if (e instanceof HeadlessException) {
            return new DashboardException((Throwable)e, "Missing -Djava.awt.headless=true JVM option ?");
        }
        return new DashboardException((Throwable)e);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public abstract ImageDocument getImageDocument() throws DashboardException;
}

