/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.document.factory;

import com.prelytis.dashboard.chart.IPaintable;
import com.prelytis.dashboard.chart.ScalePaintableWrapper;
import com.prelytis.dashboard.document.factory.GIFFactory;
import com.prelytis.dashboard.document.factory.JPEGFactory;
import com.prelytis.dashboard.document.factory.PDFiTextFactory;
import com.prelytis.dashboard.document.factory.PNGFactory;
import com.prelytis.dashboard.document.factory.SVGFactory;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.OutputFormat;
import com.prelytis.dashboard.value.structure.ImageDocument;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AbstractImageFactory {
    public static AbstractImageFactory getInstance(OutputFormat format) {
        switch (format) {
            default: {
                return new PNGFactory();
            }
            case JPEG: {
                return new JPEGFactory();
            }
            case GIF: {
                return new GIFFactory();
            }
            case SVG: {
                return new SVGFactory();
            }
            case PDF: 
        }
        return new PDFiTextFactory();
    }

    public static ImageDocument getImageDocument(OutputFormat format, BufferedImage image, String name) throws IOException {
        switch (format) {
            default: {
                return new PNGFactory().getImageDocument(image, null, name);
            }
            case JPEG: {
                return new JPEGFactory().getImageDocument(image, null, name);
            }
            case GIF: 
        }
        return new GIFFactory().getImageDocument(image, null, name);
    }

    public abstract ImageDocument getImageDocument(I18nElement var1, IPaintable var2, Dimension var3, double var4, Integer var6, boolean var7) throws DashboardException;

    protected DashboardException getException(Exception e) {
        if (e instanceof DashboardException) {
            return (DashboardException)((Object)e);
        }
        Logger log = LogManager.getLogger(this.getClass());
        log.error((Object)e);
        if (e instanceof HeadlessException) {
            return new DashboardException((Throwable)e, "Missing -Djava.awt.headless=true JVM option ?");
        }
        return new DashboardException((Throwable)e);
    }

    protected IPaintable getPaintable(IPaintable paintable, Dimension size, double scale) {
        IPaintable p;
        Object object = p = scale == 1.0 ? paintable : new ScalePaintableWrapper(paintable, scale);
        if (size != null) {
            p.setSize(size);
        }
        p.init();
        return p;
    }
}

