/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.document.factory;

import com.prelytis.dashboard.canvas.Age;
import com.prelytis.dashboard.canvas.Area;
import com.prelytis.dashboard.canvas.AxisGauge;
import com.prelytis.dashboard.canvas.Bar;
import com.prelytis.dashboard.canvas.BarLine;
import com.prelytis.dashboard.canvas.Bubble;
import com.prelytis.dashboard.canvas.Canvas;
import com.prelytis.dashboard.canvas.Column;
import com.prelytis.dashboard.canvas.Funnel;
import com.prelytis.dashboard.canvas.Gantt;
import com.prelytis.dashboard.canvas.Gauge;
import com.prelytis.dashboard.canvas.Kiviat;
import com.prelytis.dashboard.canvas.Line;
import com.prelytis.dashboard.canvas.LineLine;
import com.prelytis.dashboard.canvas.Maps;
import com.prelytis.dashboard.canvas.Pareto;
import com.prelytis.dashboard.canvas.Pie;
import com.prelytis.dashboard.canvas.Radar;
import com.prelytis.dashboard.canvas.ScatterPlot;
import com.prelytis.dashboard.canvas.StackedArea;
import com.prelytis.dashboard.canvas.StackedColumn;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.MapDefinitionDao;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.model.helper.StrokeTypeHelper;
import com.prelytis.dashboard.value.chart.DisplayProperties;
import com.prelytis.dashboard.value.chart.map.MapDefinition;
import com.prelytis.dashboard.value.chart.properties.AreaChartProperties;
import com.prelytis.dashboard.value.chart.properties.AxisGaugeChartProperties;
import com.prelytis.dashboard.value.chart.properties.BarLineChartProperties;
import com.prelytis.dashboard.value.chart.properties.BubbleChartProperties;
import com.prelytis.dashboard.value.chart.properties.DistributionProperties;
import com.prelytis.dashboard.value.chart.properties.GanttChartProperties;
import com.prelytis.dashboard.value.chart.properties.GaugeChartProperties;
import com.prelytis.dashboard.value.chart.properties.KiviatChartProperties;
import com.prelytis.dashboard.value.chart.properties.LineChartProperties;
import com.prelytis.dashboard.value.chart.properties.LineLineChartProperties;
import com.prelytis.dashboard.value.chart.properties.MapChartProperties;
import com.prelytis.dashboard.value.chart.properties.ParetoChartProperties;
import com.prelytis.dashboard.value.chart.properties.PieChartProperties;
import com.prelytis.dashboard.value.chart.properties.RadarChartProperties;
import com.prelytis.dashboard.value.chart.properties.ScatterPlotChartProperties;
import com.prelytis.dashboard.value.chart.properties.StackedChartProperties;
import com.prelytis.dashboard.value.chart.properties.StackedColumnPercProperties;
import com.prelytis.dashboard.value.data.BeanDisplayType;
import com.prelytis.dashboard.value.data.BeanStrokeTypeDefinition;
import com.prelytis.dashboard.value.data.BeanStyleDefinition;
import com.prelytis.dashboard.value.util.StyleElement;

public final class CanvasFactory {
    private final DaoFactory daoFactory;

    public static CanvasFactory getInstance(DaoFactory daoFactory) {
        return new CanvasFactory(daoFactory);
    }

    private CanvasFactory(DaoFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    public Canvas createCanvas(DisplayProperties dp, BeanStyleDefinition style) throws DashboardException {
        BeanDisplayType dt = dp == null ? null : dp.getDisplayType();
        StyleElement se = style == null ? null : style.getChart();
        Age res = null;
        switch (dt) {
            case AGE_CHART: {
                if (!(dp instanceof AreaChartProperties)) break;
                res = Age.getInstance((AreaChartProperties)((AreaChartProperties)dp), (StyleElement)se);
                break;
            }
            case AREA_CHART: 
            case AREA_CHART_TA: 
            case STEP_CHART_TA: {
                if (!(dp instanceof AreaChartProperties)) break;
                res = Area.getInstance((AreaChartProperties)((AreaChartProperties)dp), (StyleElement)se, (dt.equals((Object)BeanDisplayType.AREA_CHART_TA) || dt.equals((Object)BeanDisplayType.STEP_CHART_TA) ? 1 : 0) != 0);
                break;
            }
            case BAR_CHART_3D: 
            case BAR_CHART: 
            case HORIZONTAL_BAR_CHART: {
                if (!(dp instanceof AreaChartProperties)) break;
                res = Bar.getInstance((AreaChartProperties)((AreaChartProperties)dp), (StyleElement)se);
                break;
            }
            case STACKED_BAR_LINE: 
            case BAR_LINE_CHART: {
                if (!(dp instanceof BarLineChartProperties)) break;
                BarLineChartProperties p = (BarLineChartProperties)dp;
                BeanStrokeTypeDefinition s = this.getStroke(p.getStrokeTypeName());
                res = BarLine.getInstance((BarLineChartProperties)p, (StyleElement)se, (BeanStrokeTypeDefinition)s, (boolean)dt.equals((Object)BeanDisplayType.STACKED_BAR_LINE));
                break;
            }
            case BUBBLE_PLOT_CHART: {
                if (!(dp instanceof BubbleChartProperties)) break;
                res = Bubble.getInstance((BubbleChartProperties)((BubbleChartProperties)dp), (StyleElement)se);
                break;
            }
            case COLUMN_CHART: {
                if (!(dp instanceof AreaChartProperties)) break;
                res = Column.getInstance((AreaChartProperties)((AreaChartProperties)dp), (StyleElement)se);
                break;
            }
            case FUNNEL_CHART: {
                if (!(dp instanceof DistributionProperties)) break;
                res = Funnel.getInstance((DistributionProperties)((DistributionProperties)dp), (StyleElement)se);
                break;
            }
            case GANTT_VIEW_CHART: {
                if (!(dp instanceof GanttChartProperties)) break;
                GanttChartProperties p = (GanttChartProperties)dp;
                BeanStrokeTypeDefinition s = this.getStroke(p.getStrokeTypeName());
                res = Gantt.getInstance((GanttChartProperties)p, (StyleElement)se, (BeanStrokeTypeDefinition)s);
                break;
            }
            case GAUGE_CHART: 
            case GAUGE_CHART2: {
                if (!(dp instanceof GaugeChartProperties)) break;
                res = Gauge.getInstance((GaugeChartProperties)((GaugeChartProperties)dp), (StyleElement)se);
                break;
            }
            case VERTICAL_GAUGE_CHART: 
            case HORIZONTAL_GAUGE_CHART: {
                if (!(dp instanceof AxisGaugeChartProperties)) break;
                res = AxisGauge.getInstance((AxisGaugeChartProperties)((AxisGaugeChartProperties)dp), (StyleElement)se, (boolean)dt.equals((Object)BeanDisplayType.HORIZONTAL_GAUGE_CHART));
                break;
            }
            case LINE_CHART: 
            case LINE_CHART_TA: {
                if (!(dp instanceof LineChartProperties)) break;
                LineChartProperties p = (LineChartProperties)dp;
                BeanStrokeTypeDefinition s = this.getStroke(p.getStrokeTypeName());
                res = Line.getInstance((LineChartProperties)p, (StyleElement)se, (BeanStrokeTypeDefinition)s, (boolean)dt.equals((Object)BeanDisplayType.LINE_CHART_TA));
                break;
            }
            case LINE_LINE_CHART_TA: 
            case LINE_LINE_CHART: {
                if (!(dp instanceof LineLineChartProperties)) break;
                LineLineChartProperties p = (LineLineChartProperties)dp;
                BeanStrokeTypeDefinition s1 = this.getStroke(p.getStrokeTypeName());
                BeanStrokeTypeDefinition s2 = this.getStroke(p.getStrokeTypeBName());
                res = LineLine.getInstance((LineLineChartProperties)p, (StyleElement)se, (BeanStrokeTypeDefinition)s1, (BeanStrokeTypeDefinition)s2, (boolean)dt.equals((Object)BeanDisplayType.LINE_LINE_CHART_TA));
                break;
            }
            case MAP_CHART: {
                if (!(dp instanceof MapChartProperties)) break;
                MapChartProperties mcp = (MapChartProperties)dp;
                MapDefinitionDao mapDefinitionDao = this.daoFactory.getMapDefinitionDao();
                MapDefinition def = mapDefinitionDao.getMapDefinition(mcp.getMapType().intValue());
                if (!def.getMapInfo().isCanvasSupported()) {
                    return null;
                }
                res = Maps.getInstance((MapChartProperties)mcp, (StyleElement)se, (MapDefinition)def);
                break;
            }
            case PARETO_CHART: {
                if (!(dp instanceof ParetoChartProperties)) break;
                ParetoChartProperties p = (ParetoChartProperties)dp;
                BeanStrokeTypeDefinition s = this.getStroke(p.getStrokeTypeName());
                res = Pareto.getInstance((ParetoChartProperties)p, (StyleElement)se, (BeanStrokeTypeDefinition)s);
                break;
            }
            case DONUT_CHART: 
            case PIE_CHART: {
                if (!(dp instanceof PieChartProperties)) break;
                res = Pie.getInstance((PieChartProperties)((PieChartProperties)dp), (StyleElement)se, (boolean)dt.equals((Object)BeanDisplayType.DONUT_CHART));
                break;
            }
            case RADAR_CHART: {
                if (!(dp instanceof RadarChartProperties)) break;
                RadarChartProperties p = (RadarChartProperties)dp;
                BeanStrokeTypeDefinition s = this.getStroke(p.getStrokeTypeName());
                res = Radar.getInstance((RadarChartProperties)p, (StyleElement)se, (BeanStrokeTypeDefinition)s);
                break;
            }
            case KIVIAT: {
                if (!(dp instanceof KiviatChartProperties)) break;
                KiviatChartProperties p = (KiviatChartProperties)dp;
                BeanStrokeTypeDefinition s = this.getStroke(p.getStrokeTypeName());
                res = Kiviat.getInstance((KiviatChartProperties)p, (StyleElement)se, (BeanStrokeTypeDefinition)s);
                break;
            }
            case SCATTER_PLOT_CHART: {
                if (!(dp instanceof ScatterPlotChartProperties)) break;
                res = ScatterPlot.getInstance((ScatterPlotChartProperties)((ScatterPlotChartProperties)dp), (StyleElement)se);
                break;
            }
            case STACKED_STEP_CHART_TA: 
            case STACKED_AREA_CHART_TA: 
            case STACKED_AREA_CHART: {
                if (!(dp instanceof StackedChartProperties)) break;
                res = StackedArea.getInstance((StackedChartProperties)((StackedChartProperties)dp), (StyleElement)se, (dt.equals((Object)BeanDisplayType.STACKED_STEP_CHART_TA) || dt.equals((Object)BeanDisplayType.STACKED_AREA_CHART_TA) ? 1 : 0) != 0);
                break;
            }
            case STACKED_COLUMN_CHART_PERC: {
                if (!(dp instanceof StackedColumnPercProperties)) break;
                res = StackedColumn.getInstance((StackedColumnPercProperties)((StackedColumnPercProperties)dp), (StyleElement)se);
                break;
            }
            case STACKED_COLUMN_CHART: {
                if (!(dp instanceof StackedChartProperties)) break;
                res = StackedColumn.getInstance((StackedChartProperties)((StackedChartProperties)dp), (StyleElement)se);
            }
        }
        return res;
    }

    BeanStrokeTypeDefinition getStroke(String strokeType) throws DashboardException {
        if (strokeType == null) {
            return null;
        }
        StrokeTypeHelper dao = StrokeTypeHelper.getInstance(this.daoFactory);
        return dao.getDefinition(strokeType);
    }
}

