/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.document.factory;

import com.prelytis.dashboard.chart.AbstractChart;
import com.prelytis.dashboard.chart.AgeChart;
import com.prelytis.dashboard.chart.AreaChart;
import com.prelytis.dashboard.chart.AreaChartTA;
import com.prelytis.dashboard.chart.BarChart;
import com.prelytis.dashboard.chart.BarChart3D;
import com.prelytis.dashboard.chart.BarChartInRows;
import com.prelytis.dashboard.chart.BarLineChart;
import com.prelytis.dashboard.chart.BubbleChart;
import com.prelytis.dashboard.chart.ColorTableChart;
import com.prelytis.dashboard.chart.ColumnChart;
import com.prelytis.dashboard.chart.ColumnChart3D;
import com.prelytis.dashboard.chart.FunnelChart;
import com.prelytis.dashboard.chart.GanttViewChart;
import com.prelytis.dashboard.chart.GaugeChart;
import com.prelytis.dashboard.chart.GaugeChart2;
import com.prelytis.dashboard.chart.HorizontalBarChart;
import com.prelytis.dashboard.chart.HorizontalLinearGaugeChart;
import com.prelytis.dashboard.chart.IChart;
import com.prelytis.dashboard.chart.KiviatChart;
import com.prelytis.dashboard.chart.LineChart;
import com.prelytis.dashboard.chart.LineChart3D;
import com.prelytis.dashboard.chart.LineChart3DTA;
import com.prelytis.dashboard.chart.LineChartTA;
import com.prelytis.dashboard.chart.LineLineChart;
import com.prelytis.dashboard.chart.LineLineChartTA;
import com.prelytis.dashboard.chart.MapChart;
import com.prelytis.dashboard.chart.ParetoChart;
import com.prelytis.dashboard.chart.PieChart;
import com.prelytis.dashboard.chart.PieChart3D;
import com.prelytis.dashboard.chart.PieChartInBar;
import com.prelytis.dashboard.chart.RadarChart;
import com.prelytis.dashboard.chart.RotationChartWrapper;
import com.prelytis.dashboard.chart.ScatterPlotChart;
import com.prelytis.dashboard.chart.StackedAreaChart;
import com.prelytis.dashboard.chart.StackedAreaChartTA;
import com.prelytis.dashboard.chart.StackedColumnChart;
import com.prelytis.dashboard.chart.StackedColumnChart3D;
import com.prelytis.dashboard.chart.StackedColumnChartPerc;
import com.prelytis.dashboard.chart.VerticalLinearGaugeChart;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.MapDefinitionDao;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.model.helper.StrokeTypeHelper;
import com.prelytis.dashboard.util.FontHelper;
import com.prelytis.dashboard.value.chart.PaintableProperties;
import com.prelytis.dashboard.value.chart.Table;
import com.prelytis.dashboard.value.chart.properties.AreaChartProperties;
import com.prelytis.dashboard.value.chart.properties.AxisGaugeChartProperties;
import com.prelytis.dashboard.value.chart.properties.BarChartInRowsProperties;
import com.prelytis.dashboard.value.chart.properties.BarLineChartProperties;
import com.prelytis.dashboard.value.chart.properties.BubbleChartProperties;
import com.prelytis.dashboard.value.chart.properties.ColorTableChartProperties;
import com.prelytis.dashboard.value.chart.properties.Common;
import com.prelytis.dashboard.value.chart.properties.DistributionProperties;
import com.prelytis.dashboard.value.chart.properties.GanttChartProperties;
import com.prelytis.dashboard.value.chart.properties.GaugeChartProperties;
import com.prelytis.dashboard.value.chart.properties.KiviatChartProperties;
import com.prelytis.dashboard.value.chart.properties.Line3DChartProperties;
import com.prelytis.dashboard.value.chart.properties.LineChartProperties;
import com.prelytis.dashboard.value.chart.properties.LineLineChartProperties;
import com.prelytis.dashboard.value.chart.properties.MapChartProperties;
import com.prelytis.dashboard.value.chart.properties.ParetoChartProperties;
import com.prelytis.dashboard.value.chart.properties.PieChartProperties;
import com.prelytis.dashboard.value.chart.properties.RadarChartProperties;
import com.prelytis.dashboard.value.chart.properties.ScatterPlotChartProperties;
import com.prelytis.dashboard.value.chart.properties.StackedChartProperties;
import com.prelytis.dashboard.value.chart.properties.StackedColumnPercProperties;
import com.prelytis.dashboard.value.data.BeanDisplayType;
import com.prelytis.dashboard.value.data.BeanStrokeTypeDefinition;
import com.prelytis.dashboard.value.data.BeanStyleDefinition;
import com.prelytis.dashboard.value.util.Font;

public final class ChartFactory {
    private DaoFactory daoFactory;

    private ChartFactory(DaoFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    public static final ChartFactory getInstance(DaoFactory daoFactory) {
        return new ChartFactory(daoFactory);
    }

    public IChart getChart(BeanDisplayType displayType, PaintableProperties chartProperties, Table table, BeanStyleDefinition style) throws DashboardException {
        AgeChart chart = null;
        switch (displayType) {
            case AGE_CHART: {
                if (!(chartProperties instanceof AreaChartProperties)) break;
                chart = new AgeChart((AreaChartProperties)chartProperties, table);
                break;
            }
            case AREA_CHART: {
                if (!(chartProperties instanceof AreaChartProperties)) break;
                chart = new AreaChart((AreaChartProperties)chartProperties, table);
                break;
            }
            case AREA_CHART_TA: {
                if (!(chartProperties instanceof AreaChartProperties)) break;
                chart = new AreaChartTA((AreaChartProperties)chartProperties, table);
                break;
            }
            case BAR_CHART: {
                if (!(chartProperties instanceof AreaChartProperties)) break;
                chart = new BarChart((AreaChartProperties)chartProperties, table);
                break;
            }
            case BAR_CHART_3D: {
                if (!(chartProperties instanceof AreaChartProperties)) break;
                chart = new BarChart3D((AreaChartProperties)chartProperties, table);
                break;
            }
            case BAR_CHART_IN_ROWS: {
                if (!(chartProperties instanceof BarChartInRowsProperties)) break;
                chart = new BarChartInRows((BarChartInRowsProperties)chartProperties, table);
                break;
            }
            case COLOR_TABLE_CHART: {
                if (!(chartProperties instanceof ColorTableChartProperties)) break;
                chart = new ColorTableChart((ColorTableChartProperties)chartProperties, table);
                break;
            }
            case COLUMN_CHART: {
                if (!(chartProperties instanceof AreaChartProperties)) break;
                chart = new ColumnChart((AreaChartProperties)chartProperties, table);
                break;
            }
            case COLUMN_CHART_3D: {
                if (!(chartProperties instanceof AreaChartProperties)) break;
                chart = new ColumnChart3D((AreaChartProperties)chartProperties, table);
                break;
            }
            case PIE_CHART: {
                if (!(chartProperties instanceof PieChartProperties)) break;
                chart = new PieChart((PieChartProperties)chartProperties, table);
                break;
            }
            case PIE_CHART_3D: {
                if (!(chartProperties instanceof DistributionProperties)) break;
                chart = new PieChart3D((DistributionProperties)chartProperties, table);
                break;
            }
            case PIE_CHART_IN_BAR: {
                if (!(chartProperties instanceof StackedChartProperties)) break;
                chart = new PieChartInBar((StackedChartProperties)chartProperties, table);
                break;
            }
            case RADAR_CHART: {
                if (!(chartProperties instanceof RadarChartProperties)) break;
                RadarChartProperties rcp = (RadarChartProperties)chartProperties;
                RadarChart radarChart = new RadarChart(rcp, table);
                radarChart.setBeanStrokeTypeDefinition(this.getStroke(rcp.getStrokeTypeName()));
                chart = radarChart;
                break;
            }
            case KIVIAT: {
                if (!(chartProperties instanceof KiviatChartProperties)) break;
                KiviatChartProperties kcp = (KiviatChartProperties)chartProperties;
                KiviatChart kiviatChart = new KiviatChart(kcp, table);
                kiviatChart.setBeanStrokeTypeDefinition(this.getStroke(kcp.getStrokeTypeName()));
                chart = kiviatChart;
                break;
            }
            case SCATTER_PLOT_CHART: {
                if (!(chartProperties instanceof ScatterPlotChartProperties)) break;
                chart = new ScatterPlotChart((ScatterPlotChartProperties)chartProperties, table);
                break;
            }
            case STACKED_AREA_CHART: {
                if (!(chartProperties instanceof StackedChartProperties)) break;
                chart = new StackedAreaChart((StackedChartProperties)chartProperties, table);
                break;
            }
            case STACKED_AREA_CHART_TA: {
                if (!(chartProperties instanceof StackedChartProperties)) break;
                chart = new StackedAreaChartTA((StackedChartProperties)chartProperties, table);
                break;
            }
            case STACKED_COLUMN_CHART: {
                if (!(chartProperties instanceof StackedChartProperties)) break;
                chart = new StackedColumnChart((StackedChartProperties)chartProperties, table);
                break;
            }
            case STACKED_COLUMN_CHART_3D: {
                if (!(chartProperties instanceof StackedChartProperties)) break;
                chart = new StackedColumnChart3D((StackedChartProperties)chartProperties, table);
                break;
            }
            case STACKED_COLUMN_CHART_PERC: {
                if (!(chartProperties instanceof StackedColumnPercProperties)) break;
                chart = new StackedColumnChartPerc((StackedColumnPercProperties)chartProperties, table);
                break;
            }
            case STACKED_BAR_LINE: 
            case BAR_LINE_CHART: {
                if (!(chartProperties instanceof BarLineChartProperties)) break;
                BarLineChartProperties blcp = (BarLineChartProperties)chartProperties;
                BarLineChart blChart = new BarLineChart(blcp, table, displayType.equals((Object)BeanDisplayType.STACKED_BAR_LINE));
                blChart.setBeanStrokeTypeDefinition(this.getStroke(blcp.getStrokeTypeName()));
                chart = blChart;
                break;
            }
            case BUBBLE_PLOT_CHART: {
                if (!(chartProperties instanceof BubbleChartProperties)) break;
                chart = new BubbleChart((BubbleChartProperties)chartProperties, table);
                break;
            }
            case GANTT_VIEW_CHART: {
                if (!(chartProperties instanceof GanttChartProperties)) break;
                GanttChartProperties gcp = (GanttChartProperties)chartProperties;
                GanttViewChart gvChart = new GanttViewChart((GanttChartProperties)chartProperties, table);
                gvChart.setBeanStrokeTypeDefinition(this.getStroke(gcp.getStrokeTypeName()));
                chart = gvChart;
                break;
            }
            case GAUGE_CHART: {
                if (!(chartProperties instanceof GaugeChartProperties)) break;
                chart = new GaugeChart((GaugeChartProperties)chartProperties, table);
                break;
            }
            case GAUGE_CHART2: {
                if (!(chartProperties instanceof GaugeChartProperties)) break;
                chart = new GaugeChart2((GaugeChartProperties)chartProperties, table);
                break;
            }
            case LINE_CHART_3D: {
                if (!(chartProperties instanceof Line3DChartProperties)) break;
                chart = new LineChart3D((Line3DChartProperties)chartProperties, table);
                break;
            }
            case LINE_CHART_3D_TA: {
                if (!(chartProperties instanceof Line3DChartProperties)) break;
                chart = new LineChart3DTA((Line3DChartProperties)chartProperties, table);
                break;
            }
            case LINE_CHART: {
                if (!(chartProperties instanceof LineChartProperties)) break;
                LineChartProperties lcp = (LineChartProperties)chartProperties;
                LineChart lChart = new LineChart(lcp, table);
                lChart.setBeanStrokeTypeDefinition(this.getStroke(lcp.getStrokeTypeName()));
                chart = lChart;
                break;
            }
            case LINE_CHART_TA: {
                if (!(chartProperties instanceof LineChartProperties)) break;
                LineChartProperties lcp = (LineChartProperties)chartProperties;
                LineChartTA ltChart = new LineChartTA(lcp, table);
                ltChart.setBeanStrokeTypeDefinition(this.getStroke(lcp.getStrokeTypeName()));
                chart = ltChart;
                break;
            }
            case LINE_LINE_CHART: {
                if (!(chartProperties instanceof LineLineChartProperties)) break;
                LineLineChartProperties llcp = (LineLineChartProperties)chartProperties;
                LineLineChart llChart = new LineLineChart(llcp, table);
                llChart.setLeftBeanStrokeTypeDefinition(this.getStroke(llcp.getStrokeTypeName()));
                llChart.setRightBeanStrokeTypeDefinition(this.getStroke(llcp.getStrokeTypeBName()));
                chart = llChart;
                break;
            }
            case LINE_LINE_CHART_TA: {
                if (!(chartProperties instanceof LineLineChartProperties)) break;
                LineLineChartProperties llcp = (LineLineChartProperties)chartProperties;
                LineLineChart llChart = new LineLineChartTA(llcp, table);
                llChart.setLeftBeanStrokeTypeDefinition(this.getStroke(llcp.getStrokeTypeName()));
                llChart.setRightBeanStrokeTypeDefinition(this.getStroke(llcp.getStrokeTypeBName()));
                chart = llChart;
                break;
            }
            case MAP_CHART: {
                if (!(chartProperties instanceof MapChartProperties)) break;
                MapChart mapChart = new MapChart((MapChartProperties)chartProperties, table);
                Integer mapType = ((MapChartProperties)chartProperties).getMapType();
                if (mapType != null) {
                    MapDefinitionDao mapDefinitionDao = this.daoFactory.getMapDefinitionDao();
                    mapChart.setMapDefinition(mapDefinitionDao.getMapDefinition(mapType.intValue()));
                }
                chart = mapChart;
                break;
            }
            case PARETO_CHART: {
                if (!(chartProperties instanceof ParetoChartProperties)) break;
                ParetoChartProperties pcp = (ParetoChartProperties)chartProperties;
                ParetoChart pChart = new ParetoChart(pcp, table);
                pChart.setBeanStrokeTypeDefinition(this.getStroke(pcp.getStrokeTypeName()));
                chart = pChart;
                break;
            }
            case HORIZONTAL_GAUGE_CHART: {
                if (!(chartProperties instanceof AxisGaugeChartProperties)) break;
                chart = new HorizontalLinearGaugeChart((AxisGaugeChartProperties)chartProperties, table);
                break;
            }
            case VERTICAL_GAUGE_CHART: {
                if (!(chartProperties instanceof AxisGaugeChartProperties)) break;
                chart = new VerticalLinearGaugeChart((AxisGaugeChartProperties)chartProperties, table);
                break;
            }
            case FUNNEL_CHART: {
                if (!(chartProperties instanceof DistributionProperties)) break;
                chart = new FunnelChart((DistributionProperties)chartProperties, table);
                break;
            }
            case HORIZONTAL_BAR_CHART: {
                if (!(chartProperties instanceof AreaChartProperties)) break;
                chart = new HorizontalBarChart((AreaChartProperties)chartProperties, table);
                break;
            }
            case DONUT_CHART: {
                if (!(chartProperties instanceof PieChartProperties)) break;
                chart = new PieChart((PieChartProperties)chartProperties, table, true);
                break;
            }
            case STACKED_STEP_CHART_TA: {
                if (!(chartProperties instanceof StackedChartProperties)) break;
                chart = new StackedAreaChartTA((StackedChartProperties)chartProperties, table, true);
                break;
            }
            case STEP_CHART_TA: {
                if (!(chartProperties instanceof AreaChartProperties)) break;
                chart = new AreaChartTA((AreaChartProperties)chartProperties, table, true);
            }
        }
        if (chart != null) {
            Common common;
            if (chart instanceof AbstractChart) {
                AbstractChart aChart = (AbstractChart)chart;
                java.awt.Font defaultFont = new java.awt.Font("Arial", 0, 12);
                if (style != null) {
                    aChart.setFont(FontHelper.getAwtFont((Font)style.getChart(), (java.awt.Font)defaultFont));
                    aChart.setLegendFont(FontHelper.getAwtFont((Font)style.getLegend(), (java.awt.Font)defaultFont));
                } else {
                    aChart.setFont(defaultFont);
                    aChart.setLegendFont(defaultFont);
                }
            }
            boolean rotate = false;
            if (chart.getPaintableProperties() instanceof Common && (common = (Common)chart.getPaintableProperties()).getRotate() != null) {
                rotate = common.getRotate();
            }
            if (rotate) {
                return new RotationChartWrapper((IChart)chart);
            }
        }
        return chart;
    }

    private BeanStrokeTypeDefinition getStroke(String strokeTypeName) throws DashboardException {
        if (strokeTypeName == null) {
            return null;
        }
        StrokeTypeHelper strokeTypeHelper = StrokeTypeHelper.getInstance(this.daoFactory);
        return strokeTypeHelper.getDefinition(strokeTypeName);
    }
}

