/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.document.factory;

import com.lowagie.text.Document;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.prelytis.dashboard.document.factory.PDFiTextHelper;
import com.prelytis.dashboard.document.factory.PageLayout;
import com.prelytis.dashboard.util.GuidFactory;
import com.prelytis.dashboard.value.data.BeanPageLayout;
import com.prelytis.dashboard.value.data.BeanThemeDefinition;
import com.prelytis.dashboard.value.data.ThemeImageBundle;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class DocumentPageEvent
extends PdfPageEventHelper {
    private static Logger log = LogManager.getLogger(DocumentPageEvent.class);
    private PdfContentByte cb;
    private Area[] area;
    private String date;
    private String dateTime;
    private String time;
    private String prelytisVersion;
    private PageLayout pageLayout;

    public DocumentPageEvent(PageLayout pageLayout, Locale locale) {
        this.pageLayout = pageLayout;
        this.area = new Area[6];
        Date currentDate = new Date();
        try {
            this.date = DateFormat.getDateInstance(3, locale).format(currentDate);
            this.dateTime = DateFormat.getDateTimeInstance(3, 3, locale).format(currentDate);
            this.time = DateFormat.getTimeInstance(3, locale).format(currentDate);
            this.prelytisVersion = pageLayout.getPrelytisVersion();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void onOpenDocument(PdfWriter writer, Document document) {
        this.cb = writer.getDirectContent();
        posX = new float[]{this.pageLayout.unitToPt(this.pageLayout.getLeftMargin()), this.pageLayout.unitToPt(this.pageLayout.getLeftMargin())};
        posY = new float[]{this.pageLayout.unitToPt(this.pageLayout.getPageHeight() - this.pageLayout.getTopMargin() - this.pageLayout.getHeaderHeight()), this.pageLayout.unitToPt(this.pageLayout.getBottomMargin())};
        block21: for (i = 0; i < 6; ++i) {
            try {
                if (i < 3) {
                    content = this.pageLayout.getHeaderContent(i);
                    align = content.getFont().getTextAlign() - 1;
                    this.area[i] = new Area(this.cb, content.getType(), align, 0);
                } else {
                    content = this.pageLayout.getFooterContent(i - 3);
                    align = content.getFont().getTextAlign() - 1;
                    this.area[i] = new Area(this.cb, content.getType(), align, 2);
                }
                newArea = this.area[i];
                newArea.setFont(PDFiTextHelper.getFont(content.getFont(), this.pageLayout.getFontSize()));
                newArea.setBaseFont(PDFiTextHelper.getBaseFont(content.getFont()));
                newArea.setBackColor(new Color(Integer.parseInt(content.getFont().getBackColor(), 16)));
                if (i < 3) {
                    newArea.setBounds(posX[0], posY[0], this.pageLayout.unitToPt(this.pageLayout.getHeaderWidth(i)), this.pageLayout.unitToPt(this.pageLayout.getHeaderHeight()));
                    posX[0] = posX[0] + this.pageLayout.unitToPt(this.pageLayout.getHeaderWidth(i));
                } else {
                    newArea.setBounds(posX[1], posY[1], this.pageLayout.unitToPt(this.pageLayout.getFooterWidth(i - 3)), this.pageLayout.unitToPt(this.pageLayout.getFooterHeight()));
                    posX[1] = posX[1] + this.pageLayout.unitToPt(this.pageLayout.getFooterWidth(i - 3));
                }
                switch (1.$SwitchMap$com$prelytis$dashboard$value$data$BeanPageLayout$ContentType[content.getType().ordinal()]) {
                    case 1: 
                    case 2: {
                        bounds = newArea.getBounds();
                        bundle = this.getImageBundle(content.getContent());
                        if (bundle == null) break;
                        if (bundle.getVectorImage() == null || bundle.getVectorImage().getData() == null) ** GOTO lbl74
                        userAgent = new UserAgentAdapter();
                        loader = new DocumentLoader((UserAgent)userAgent);
                        ctx = new BridgeContext((UserAgent)userAgent, loader);
                        builder = new GVTBuilder();
                        tmpFile = File.createTempFile(GuidFactory.getInstance().generateGUID((Object)bundle), null);
                        try {
                            fos = new FileOutputStream(tmpFile);
                            try {
                                data = bundle.getVectorImage().getData();
                                fos.write(data, 0, data.length);
                            }
                            finally {
                                fos.close();
                            }
                            svgDoc = loader.loadDocument(tmpFile.toURI().toString());
                            svg = builder.build(ctx, svgDoc);
                            svgBounds = svg.getBounds();
                            width = svgBounds.getWidth();
                            height = svgBounds.getHeight();
                            if (width > bounds.getWidth()) {
                                height *= bounds.getWidth() / width;
                                width = bounds.getWidth() - 2.0;
                                height -= 2.0;
                            }
                            if (height > bounds.getHeight()) {
                                width *= bounds.getHeight() / height;
                                height = bounds.getHeight() - 2.0;
                                width -= 2.0;
                            }
                            at = new AffineTransform(width / svgBounds.getWidth(), 0.0, 0.0, height / svgBounds.getHeight(), 0.0, 0.0);
                            template = this.cb.createTemplate((float)width, (float)height);
                            g2d = template.createGraphics((float)width, (float)height);
                            try {
                                g2d.setTransform(at);
                                svg.paint(g2d);
                            }
                            finally {
                                g2d.dispose();
                            }
                            newArea.setTemplate(template);
                            newArea.setSize(width, height);
                            continue block21;
                        }
                        finally {
                            tmpFile.delete();
                        }
lbl74:
                        // 1 sources

                        data = null;
                        if (bundle.getHighDpiImage() != null) {
                            data = bundle.getHighDpiImage().getData();
                        }
                        if (data == null && bundle.getLowDpiImage() != null) {
                            data = bundle.getLowDpiImage().getData();
                        }
                        if (data == null) continue block21;
                        image = Image.getInstance((byte[])data);
                        width = image.getPlainWidth();
                        height = image.getPlainHeight();
                        if (width > bounds.getWidth()) {
                            height *= bounds.getWidth() / width;
                            width = bounds.getWidth();
                        }
                        if (height > bounds.getHeight()) {
                            width *= bounds.getHeight() / height;
                            height = bounds.getHeight();
                        }
                        newArea.setImage(image, width, height);
                        break;
                    }
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 5: {
                        newArea.setTemplate(this.cb.createTemplate(50.0f, 50.0f));
                        break;
                    }
                    case 6: {
                        newArea.setTextContent(content.getContent());
                        break;
                    }
                    case 7: {
                        newArea.setTextContent(this.date);
                        break;
                    }
                    case 8: {
                        newArea.setTextContent(this.dateTime);
                        break;
                    }
                    case 9: {
                        newArea.setTextContent(this.time);
                        break;
                    }
                    case 10: {
                        newArea.setTextContent(this.prelytisVersion);
                    }
                }
                continue;
            }
            catch (Exception e) {
                DocumentPageEvent.log.error((Object)e);
            }
        }
    }

    public void onEndPage(PdfWriter writer, Document document) {
        try {
            for (int i = 0; i < 6; ++i) {
                this.area[i].paint(writer.getPageNumber());
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        try {
            for (int i = 0; i < 6; ++i) {
                this.area[i].setNbPage(writer.getPageNumber() - 1);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private ThemeImageBundle getImageBundle(String name) {
        BeanThemeDefinition theme = this.pageLayout.getTheme();
        if (theme == null) {
            return null;
        }
        if ("logo".equals(name)) {
            return theme.getLogo();
        }
        List imageList = theme.getImageList();
        if (imageList == null || imageList.isEmpty()) {
            return null;
        }
        for (ThemeImageBundle image : imageList) {
            if (!image.getName().equals(name)) continue;
            return image;
        }
        return null;
    }

    private static class Area {
        private final PdfContentByte cb;
        private final BeanPageLayout.ContentType contentType;
        private String textContent;
        private Image image;
        private Font font;
        private Color backColor;
        private PdfTemplate template;
        private BaseFont baseFont;
        private Rectangle2D bounds = new Rectangle2D.Float();
        private double posX;
        private double posY;
        private final int horizontalAlign;
        private final int verticalAlign;

        public Area(PdfContentByte cb, BeanPageLayout.ContentType contentType, int horizontalAlign, int verticalAlign) {
            this.cb = cb;
            this.contentType = contentType;
            this.horizontalAlign = horizontalAlign;
            this.verticalAlign = verticalAlign;
        }

        public void setTemplate(PdfTemplate template) {
            this.template = template;
        }

        public void setImage(Image image, double width, double height) {
            image.scaleAbsolute((float)width, (float)height);
            image.setAbsolutePosition((float)((int)this.getPosX(width)), (float)((int)this.getPosY(height)));
            this.image = image;
        }

        public void setTextContent(String textContent) {
            this.textContent = textContent;
        }

        public BeanPageLayout.ContentType getContentType() {
            return this.contentType;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public void setBaseFont(BaseFont baseFont) {
            this.baseFont = baseFont;
        }

        public void setBounds(float x, float y, float w, float h) {
            this.bounds.setRect(x, y, w, h);
        }

        public Rectangle2D getBounds() {
            return this.bounds;
        }

        public Color getBackColor() {
            return this.backColor;
        }

        public void setBackColor(Color backColor) {
            this.backColor = backColor;
        }

        public void setSize(double width, double height) {
            this.posX = this.getPosX(width);
            this.posY = this.getPosY(height);
        }

        private double getPosX(double aWidth) {
            switch (this.horizontalAlign) {
                default: {
                    return this.bounds.getX();
                }
                case 1: {
                    return this.bounds.getX() + (this.bounds.getWidth() - aWidth) / 2.0;
                }
                case 2: 
            }
            return this.bounds.getX() + this.bounds.getWidth() - aWidth;
        }

        private double getPosY(double aHeight) {
            switch (this.verticalAlign) {
                default: {
                    return this.bounds.getY() + this.bounds.getHeight() - aHeight;
                }
                case 1: {
                    return this.bounds.getY() + (this.bounds.getHeight() - aHeight) / 2.0;
                }
                case 2: 
            }
            return this.bounds.getY();
        }

        public void setNbPage(int nbPage) {
            if (this.getContentType() == BeanPageLayout.ContentType.PAGENUM_TOTAL && this.template != null) {
                this.template.beginText();
                this.template.setFontAndSize(this.baseFont, this.font.getSize());
                this.template.showText(String.valueOf(nbPage));
                this.template.endText();
            }
        }

        public void paint(int pageNumber) {
            try {
                if (this.bounds.getWidth() == 0.0 || this.bounds.getHeight() == 0.0) {
                    return;
                }
                this.cb.rectangle((float)this.bounds.getX(), (float)this.bounds.getY(), (float)this.bounds.getWidth(), (float)this.bounds.getHeight());
                this.cb.setColorFill(this.getBackColor());
                this.cb.fill();
                switch (this.getContentType()) {
                    case IMAGE: {
                        if (this.image == null) break;
                        this.cb.addImage(this.image);
                        break;
                    }
                    case PAGENUM_TOTAL: {
                        this.textContent = String.valueOf(pageNumber) + "/";
                        this.cb.beginText();
                        float width = this.baseFont.getWidthPoint(this.textContent, this.font.getSize());
                        this.posX = this.getPosX(2.0f * width);
                        this.posY = this.getPosY(this.font.getSize());
                        this.cb.setFontAndSize(this.baseFont, this.font.getSize());
                        this.cb.setTextMatrix((float)this.posX, (float)this.posY);
                        this.cb.setColorFill(this.font.getColor());
                        this.cb.showText(this.textContent);
                        this.cb.endText();
                        this.posX += (double)width;
                        break;
                    }
                    case PAGENUM: {
                        this.textContent = String.valueOf(pageNumber);
                    }
                    case FIXED: 
                    case DATE: 
                    case DATE_TIME: 
                    case TIME: 
                    case VERSION: {
                        this.cb.beginText();
                        float width = this.baseFont.getWidthPoint(this.textContent, this.font.getSize());
                        this.posX = this.getPosX(width);
                        this.posY = this.getPosY(this.font.getSize());
                        this.cb.setFontAndSize(this.baseFont, this.font.getSize());
                        this.cb.setTextMatrix((float)this.posX, (float)this.posY);
                        this.cb.setColorFill(this.font.getColor());
                        this.cb.showText(this.textContent);
                        this.cb.endText();
                    }
                }
                if (this.template != null) {
                    this.cb.addTemplate(this.template, (float)this.posX, (float)this.posY);
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }
}

