/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.document.factory;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.prelytis.dashboard.chart.IPaintable;
import com.prelytis.dashboard.document.factory.AbstractImageFactory;
import com.prelytis.dashboard.document.factory.DocumentPageEvent;
import com.prelytis.dashboard.document.factory.PDFiTextHelper;
import com.prelytis.dashboard.document.factory.PageLayout;
import com.prelytis.dashboard.document.util.ClippingGraphics2D;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.util.GuidFactory;
import com.prelytis.dashboard.value.data.BeanPageLayout;
import com.prelytis.dashboard.value.structure.Commentable;
import com.prelytis.dashboard.value.structure.DashboardComment;
import com.prelytis.dashboard.value.structure.ImageDocument;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;

public final class PDFiTextFactory
extends AbstractImageFactory {
    private static final String PDF = "application/pdf";
    private String fileName = "export.pdf";
    private String title = "unknown";
    private String subject = "unknown";
    private PageLayout pageLayout;
    private boolean shapes = true;
    private Locale locale;

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubject() {
        return this.subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageDocument getImageDocument(I18nElement elt, IPaintable paintable, Dimension size, double scale, Integer dpi, boolean scaletofit) throws DashboardException {
        try {
            IPaintable p = this.getPaintable(paintable, size, scale);
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                Document document;
                float top;
                float left;
                float height;
                float width;
                if (this.pageLayout == null) {
                    if (p.getSize() != null) {
                        width = (int)p.getSize().getWidth();
                        height = (int)p.getSize().getHeight();
                    } else {
                        width = 800.0f;
                        height = 600.0f;
                        p.setSize(new Dimension((int)width, (int)height));
                    }
                    left = 0.0f;
                    top = height;
                    document = new Document(new Rectangle(width, height));
                } else {
                    width = this.pageLayout.unitToPt(this.pageLayout.getPageWidth() - this.pageLayout.getLeftMargin() - this.pageLayout.getRightMargin());
                    height = this.pageLayout.unitToPt(this.pageLayout.getPageHeight() - this.pageLayout.getTopMargin() - this.pageLayout.getBottomMargin());
                    left = this.pageLayout.unitToPt(this.pageLayout.getLeftMargin());
                    top = this.pageLayout.unitToPt(this.pageLayout.getPageHeight() - this.pageLayout.getTopMargin() - this.pageLayout.getHeaderHeight());
                    document = new Document(new Rectangle(this.pageLayout.unitToPt(this.pageLayout.getPageWidth()), this.pageLayout.unitToPt(this.pageLayout.getPageHeight())), this.pageLayout.unitToPt(this.pageLayout.getLeftMargin()), this.pageLayout.unitToPt(this.pageLayout.getRightMargin()), this.pageLayout.unitToPt(this.pageLayout.getTopMargin() + this.pageLayout.getHeaderHeight()), this.pageLayout.unitToPt(this.pageLayout.getBottomMargin() + this.pageLayout.getFooterHeight()));
                }
                try {
                    PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)out);
                    writer.setPdfVersion(this.pageLayout == null ? (char)'6' : PDFiTextHelper.getPdfVersion(this.pageLayout.getPdfVersion()));
                    if (this.pageLayout == null || this.pageLayout.isFullCompression()) {
                        writer.setFullCompression();
                    }
                    if (this.pageLayout != null && this.pageLayout.getEncrypt() != BeanPageLayout.Encryption.NONE) {
                        byte[] uPwd = null;
                        if (this.pageLayout.getUserPassword() != null) {
                            uPwd = this.pageLayout.getUserPassword().getBytes("UTF-8");
                        }
                        byte[] oPwd = null;
                        if (this.pageLayout.getOwnerPassword() != null) {
                            oPwd = this.pageLayout.getOwnerPassword().getBytes("UTF-8");
                        }
                        writer.setEncryption(uPwd, oPwd, PDFiTextHelper.getPermissions(this.pageLayout.getPerms()), PDFiTextHelper.getEncryption(this.pageLayout.getEncrypt()));
                    }
                    document.addCreator("Axway Sentinel Web Dashboard");
                    document.addAuthor("Axway Sentinel Web Dashboard");
                    document.addTitle(this.title);
                    document.addSubject(this.subject);
                    if (this.pageLayout != null) {
                        writer.setPageEvent((PdfPageEvent)new DocumentPageEvent(this.pageLayout, this.locale));
                    }
                    document.open();
                    for (int i = 0; i < paintable.getPages(); ++i) {
                        Commentable commentable;
                        List list;
                        if (i != 0) {
                            document.newPage();
                        }
                        paintable.setCurrentPage(i);
                        PdfContentByte pdfCB = writer.getDirectContent();
                        PdfTemplate pdfT = pdfCB.createTemplate(width, height);
                        Graphics2D graphics = null;
                        graphics = this.shapes ? pdfT.createGraphicsShapes(width, height) : pdfT.createGraphics(width, height);
                        try {
                            if (this.pageLayout != null && this.pageLayout.isClip()) {
                                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, width, height);
                                graphics = new ClippingGraphics2D(graphics, rect);
                            }
                            graphics.setStroke(new BasicStroke(0.25f));
                            paintable.init();
                            paintable.paint(graphics);
                        }
                        finally {
                            graphics.dispose();
                        }
                        pdfCB.addTemplate(pdfT, left, top - height);
                        if (!(paintable instanceof Commentable) || (list = (commentable = (Commentable)paintable).getComments()) == null || list.isEmpty()) continue;
                        document.newPage();
                        Font font = new Font(1, this.pageLayout == null ? 10.0f : (float)this.pageLayout.getFontSize()[2], 0, Color.black);
                        for (int j = 0; j < list.size(); ++j) {
                            DashboardComment pc = (DashboardComment)list.get(j);
                            if (pc.getComment() == null || pc.getCommentAuthor() == null || pc.getCommentDate() == null) continue;
                            DateFormat df = SimpleDateFormat.getDateTimeInstance(3, 3, this.locale);
                            StringBuffer titleBuffer = new StringBuffer(pc.getCommentAuthor());
                            titleBuffer.append(" (" + df.format(pc.getCommentDate()) + ")");
                            Chunk titleChunk = new Chunk(titleBuffer.toString(), font);
                            titleChunk.setUnderline(0.2f, -2.0f);
                            Paragraph title = new Paragraph(titleChunk);
                            document.add((Element)title);
                            document.add((Element)new Paragraph(pc.getComment(), font));
                        }
                    }
                }
                finally {
                    document.close();
                }
            }
            ImageDocument imageDocument = new ImageDocument();
            imageDocument.setObjectID(elt.getObjectID());
            imageDocument.setName(elt.getName());
            imageDocument.getDescriptionMap().putAll(elt.getDescriptionMap());
            imageDocument.setData(out.toByteArray());
            imageDocument.setContentType(PDF);
            imageDocument.setFileName(elt.getName() + ".pdf");
            imageDocument.setReference(GuidFactory.getInstance().generateGUID((Object)imageDocument));
            return imageDocument;
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    public PageLayout getPageLayout() {
        return this.pageLayout;
    }

    public void setPageLayout(PageLayout pageLayout) {
        this.pageLayout = pageLayout;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

