/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.document.factory;

import com.prelytis.dashboard.value.data.BeanLengthUnit;
import com.prelytis.dashboard.value.data.BeanPageLayout;
import com.prelytis.dashboard.value.data.BeanThemeDefinition;
import java.io.Serializable;
import java.util.EnumSet;

public class PageLayout
implements Serializable {
    private static final long serialVersionUID = 5995679234434049194L;
    private final BeanPageLayout pageLayout;
    private final BeanLengthUnit lengthUnit;
    private final BeanThemeDefinition theme;
    private String prelytisVersion;
    private float pageWidth;
    private float pageHeight;

    public PageLayout(BeanPageLayout pageLayout, BeanLengthUnit lengthUnit, BeanThemeDefinition theme) {
        this.pageLayout = pageLayout;
        this.lengthUnit = lengthUnit;
        this.theme = theme;
        this.pageWidth = pageLayout.getPageWidth();
        this.pageHeight = pageLayout.getPageHeight();
        if (pageLayout.getOrientation() == 2 && this.pageWidth > this.pageHeight || pageLayout.getOrientation() == 1 && this.pageWidth < this.pageHeight) {
            float tmp = this.pageWidth;
            this.pageWidth = this.pageHeight;
            this.pageHeight = tmp;
        }
    }

    public float unitToPt(float lengthInUnit) {
        return lengthInUnit * (float)this.lengthUnit.getConvFactor() / 254.0f * 72.0f;
    }

    public float getBottomMargin() {
        return this.pageLayout.getBottomMargin();
    }

    public float getTopMargin() {
        return this.pageLayout.getTopMargin();
    }

    public float getLeftMargin() {
        return this.pageLayout.getLeftMargin();
    }

    public float getRightMargin() {
        return this.pageLayout.getRightMargin();
    }

    public BeanPageLayout.Encryption getEncrypt() {
        return this.pageLayout.getEncrypt();
    }

    public float getPageWidth() {
        return this.pageWidth;
    }

    public float getPageHeight() {
        return this.pageHeight;
    }

    public float getFooterHeight() {
        return this.pageLayout.getFooterHeight();
    }

    public float getHeaderHeight() {
        return this.pageLayout.getHeaderHeight();
    }

    public int[] getFontSize() {
        return this.pageLayout.getFontSize();
    }

    public String getOwnerPassword() {
        return this.pageLayout.getOwnerPassword();
    }

    public EnumSet<BeanPageLayout.Permission> getPerms() {
        return this.pageLayout.getPerms();
    }

    public String getUserPassword() {
        return this.pageLayout.getUserPassword();
    }

    public String getPrelytisVersion() {
        return this.prelytisVersion;
    }

    public BeanPageLayout.Content getHeaderContent(int i) {
        return this.pageLayout.getHeaderContent(i);
    }

    public BeanPageLayout.Content getFooterContent(int i) {
        return this.pageLayout.getFooterContent(i);
    }

    public float getFooterWidth(int i) {
        return this.pageLayout.getFooterWidth(i);
    }

    public float getHeaderWidth(int i) {
        return this.pageLayout.getHeaderWidth(i);
    }

    public boolean getPageBreakOnSection() {
        return this.pageLayout.getPageBreakOnSection();
    }

    public boolean isClip() {
        return this.pageLayout.isClip();
    }

    public BeanPageLayout.PdfVersion getPdfVersion() {
        return this.pageLayout.getPdfVersion();
    }

    public boolean isFullCompression() {
        return this.pageLayout.isFullCompression();
    }

    public BeanThemeDefinition getTheme() {
        return this.theme;
    }
}

