/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.ext;

import com.prelytis.dashboard.ext.AbstractFacade;
import com.prelytis.dashboard.interfaces.DashboardFacade;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.LogManager;

public abstract class AbstractAuthenticationFacade
extends AbstractFacade {
    private static final String OEM = "oem";
    private static final String MOBILITY = "mobility";
    private static final String WEB = "web";
    private static final String CONNECTION_TYPE = "connectionType";
    private static final String WS = "ws";
    private static final String FORCE_CONNECTION = "forceConnection";
    protected Boolean forceConnection;
    protected Set<Integer> connectionTypeSet = new HashSet<Integer>();

    public AbstractAuthenticationFacade(DashboardFacade facade) {
        super(facade);
    }

    @Override
    public void init(Map<String, String> properties) {
        String ct = properties.get(CONNECTION_TYPE);
        String[] connectionTypes = ct == null ? new String[]{WEB} : ct.split(",");
        for (String connectionType : connectionTypes) {
            if (WEB.equalsIgnoreCase(connectionType)) {
                this.connectionTypeSet.add(1);
                continue;
            }
            if (MOBILITY.equalsIgnoreCase(connectionType)) {
                this.connectionTypeSet.add(3);
                continue;
            }
            if (OEM.equalsIgnoreCase(connectionType)) {
                this.connectionTypeSet.add(4);
                continue;
            }
            if (!WS.equalsIgnoreCase(connectionType)) continue;
            this.connectionTypeSet.add(5);
        }
        try {
            String value = properties.get(FORCE_CONNECTION);
            if (value != null) {
                this.forceConnection = Boolean.valueOf(value);
            }
        }
        catch (Exception e) {
            LogManager.getLogger(this.getClass()).warn((Object)"Invalid value for init parameter forceConnection");
        }
    }
}

