/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.chart.IPaintable;
import com.prelytis.dashboard.chart.StrategyMapChart;
import com.prelytis.dashboard.document.factory.PageLayout;
import com.prelytis.dashboard.value.area.IArea;
import com.prelytis.dashboard.value.chart.PaintableProperties;
import com.prelytis.dashboard.value.structure.ControlGroup;
import com.prelytis.dashboard.value.structure.ControlResult;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Document;

public class ControlPanel
implements IPaintable {
    private final List<ControlGroup> groups;
    private final PaintableProperties paintableProperties;
    private final PageLayout pagelayout;
    private final String controlLabel;
    private final String controlSummaryLabel;
    private final String controlSeverityLabel;
    private Dimension size = null;
    private double scale = 1.0;
    private int space = 1;
    private int leftWidth = 0;
    private int centerWidth = 0;
    private int rightWidth = 0;
    private int padding = 1;
    private int lineHeight;
    private int logoWidth;
    private Object[] icons = new Object[9];
    private boolean option = true;
    private static final String PATH = "/com/prelytis/dashboard/resources/img/";

    public ControlPanel(List<ControlGroup> groups, Locale locale, PageLayout pagelayout) {
        this.pagelayout = pagelayout;
        this.groups = groups;
        this.paintableProperties = new PaintableProperties();
        ResourceBundle bundle = ResourceBundle.getBundle("com.prelytis.dashboard.resources.Messages", locale);
        this.controlLabel = bundle.getString("controlPanel.control");
        this.controlSummaryLabel = bundle.getString("controlPanel.summary");
        this.controlSeverityLabel = bundle.getString("controlPanel.severity");
    }

    public void init() {
    }

    private void init(Graphics2D g2D) {
        Font defaultFont = g2D.getFont();
        g2D.setFont(defaultFont.deriveFont((float)this.pagelayout.getFontSize()[2]));
        FontMetrics fontMetrics = g2D.getFontMetrics();
        this.lineHeight = fontMetrics.getHeight() + 2 * this.padding;
        this.logoWidth = fontMetrics.getHeight();
        UserAgentAdapter userAgent = new UserAgentAdapter();
        DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
        BridgeContext ctx = new BridgeContext((UserAgent)userAgent, loader);
        GVTBuilder builder = new GVTBuilder();
        String path = PATH;
        String[] iconName = new String[]{"info", "warning", "error", "info-g", "warning-g", "error-g", "folder-open", "task-control", "question"};
        for (int i = 0; i < 9; ++i) {
            try {
                Object tmp;
                String file = new StringBuffer(path).append(iconName[i]).append(".svg").toString();
                Document svgDoc = loader.loadDocument(this.getURI(file));
                this.icons[i] = tmp = builder.build(ctx, svgDoc);
                continue;
            }
            catch (Exception e) {
                URL url = this.getURL(new StringBuffer(path).append(iconName[i]).append("-16x16.png").toString());
                try {
                    this.icons[i] = ImageIO.read(url);
                    continue;
                }
                catch (Exception tmp) {
                    // empty catch block
                }
            }
        }
        int lLeftWidth = 0;
        int lCenterWidth = 0;
        this.leftWidth = this.getWidth(fontMetrics, this.controlLabel);
        this.centerWidth = this.getWidth(fontMetrics, this.controlSummaryLabel);
        this.rightWidth = this.getWidth(fontMetrics, this.controlSeverityLabel);
        if (this.space + this.logoWidth + this.space > this.rightWidth) {
            this.rightWidth = this.space + this.logoWidth + this.space;
        }
        for (ControlGroup group : this.groups) {
            int[] summaryTab = group.getNbControls();
            lLeftWidth = this.space + this.logoWidth + this.space;
            g2D.setFont(defaultFont.deriveFont((float)this.pagelayout.getFontSize()[2]));
            fontMetrics = g2D.getFontMetrics();
            if ((lLeftWidth += fontMetrics.stringWidth(group.getDescription())) > this.leftWidth) {
                this.leftWidth = lLeftWidth;
            }
            lCenterWidth = this.logoWidth * 3 + this.space * 2;
            for (int j = 0; j < summaryTab.length - 1; ++j) {
                lCenterWidth += fontMetrics.stringWidth(Integer.toString(summaryTab[j]));
            }
            if (lCenterWidth > this.centerWidth) {
                this.centerWidth = lCenterWidth;
            }
            g2D.setFont(defaultFont.deriveFont((float)this.pagelayout.getFontSize()[1]));
            fontMetrics = g2D.getFontMetrics();
            for (ControlResult control : group.getResults()) {
                lLeftWidth = (this.space + this.logoWidth + this.space) * 2;
                if ((lLeftWidth += fontMetrics.stringWidth(control.getDescription())) <= this.leftWidth) continue;
                this.leftWidth = lLeftWidth;
            }
        }
        Dimension preferredSize = this.size;
        if (preferredSize != null) {
            if (preferredSize.width < this.leftWidth + this.centerWidth + this.rightWidth) {
                this.scale = (double)preferredSize.width / (double)(this.leftWidth + this.centerWidth + this.rightWidth);
            } else if (this.option) {
                this.leftWidth = preferredSize.width - this.centerWidth - this.rightWidth;
            } else {
                this.scale = (double)(this.leftWidth + this.centerWidth + this.rightWidth) / (double)preferredSize.width;
            }
        }
        g2D.setFont(defaultFont);
    }

    private int getWidth(FontMetrics fm, String label) {
        return fm.stringWidth(label) + 2 * this.space;
    }

    public void paint(Graphics2D graphics2D) {
        this.init(graphics2D);
        Color savedColor = graphics2D.getColor();
        Stroke savedStroke = graphics2D.getStroke();
        Font savedFont = graphics2D.getFont();
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.scale(this.scale, this.scale);
        int width = this.leftWidth + this.centerWidth + this.rightWidth;
        Color gris = new Color(237, 237, 237);
        Color grisClair = new Color(249, 249, 249);
        Font defaultFont = graphics2D.getFont();
        graphics2D.setFont(defaultFont.deriveFont((float)this.pagelayout.getFontSize()[2]));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        float x = 0.0f;
        float y = 0.0f;
        float baseline = y + (float)this.lineHeight - (float)this.padding - (float)fontMetrics.getDescent();
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, width, this.lineHeight);
        graphics2D.setColor(gris);
        graphics2D.fill(rect);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawLine(0, 0, width, 0);
        graphics2D.drawLine(0, this.lineHeight - 1, width, this.lineHeight - 1);
        graphics2D.drawString(this.controlLabel, (float)(this.leftWidth / 2 - fontMetrics.stringWidth(this.controlLabel) / 2), baseline);
        graphics2D.drawString(this.controlSummaryLabel, (float)(this.leftWidth + this.centerWidth / 2 - fontMetrics.stringWidth(this.controlSummaryLabel) / 2), baseline);
        graphics2D.drawString(this.controlSeverityLabel, (float)(this.leftWidth + this.centerWidth + this.rightWidth / 2 - fontMetrics.stringWidth(this.controlSeverityLabel) / 2), baseline);
        for (ControlGroup group : this.groups) {
            baseline += (float)this.lineHeight;
            int[] summaryTab = group.getNbControls();
            graphics2D.setFont(defaultFont.deriveFont((float)this.pagelayout.getFontSize()[2]));
            fontMetrics = graphics2D.getFontMetrics();
            rect = new Rectangle2D.Double(0.0, y += (float)this.lineHeight, width, this.lineHeight - 1);
            graphics2D.setColor(gris);
            graphics2D.fill(rect);
            graphics2D.setColor(Color.BLACK);
            x = this.space;
            this.drawCategory(graphics2D, group.getDescription(), x, y, summaryTab);
            graphics2D.setFont(defaultFont.deriveFont((float)this.pagelayout.getFontSize()[1]));
            fontMetrics = graphics2D.getFontMetrics();
            Color lineColor = Color.white;
            for (ControlResult control : group.getResults()) {
                baseline += (float)this.lineHeight;
                rect = new Rectangle2D.Double(0.0, y += (float)this.lineHeight, width, this.lineHeight);
                graphics2D.setColor(lineColor);
                graphics2D.fill(rect);
                lineColor = lineColor == Color.white ? grisClair : Color.white;
                graphics2D.setColor(Color.black);
                x = 3 * this.space + this.logoWidth;
                this.drawIcon(graphics2D, this.icons[7], (int)x, (int)y + this.padding, this.logoWidth);
                x = (2 * this.space + this.logoWidth) * 2;
                graphics2D.setColor(Color.black);
                graphics2D.drawString(control.getDescription(), x, baseline);
                x = this.leftWidth + this.centerWidth + this.rightWidth / 2 - this.logoWidth / 2;
                this.drawGravite(graphics2D, control.getCalcValue(), (int)x, (int)y + this.padding, this.logoWidth);
            }
        }
        graphics2D.setColor(savedColor);
        graphics2D.setStroke(savedStroke);
        graphics2D.setFont(savedFont);
    }

    private void drawIcon(Graphics2D graphics2D, Object icon, int x, int y, int logoWidth) {
        if (icon == null) {
            return;
        }
        if (icon instanceof BufferedImage) {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage((Image)icon, x, y, logoWidth, logoWidth, null);
        } else if (icon instanceof GraphicsNode) {
            graphics2D.translate(x, y);
            GraphicsNode gn = (GraphicsNode)icon;
            Rectangle2D bounds = gn.getGeometryBounds();
            double factor = (double)logoWidth / bounds.getWidth();
            gn.setTransform(AffineTransform.getScaleInstance(factor, factor));
            gn.paint(graphics2D);
            graphics2D.translate(-x, -y);
        }
    }

    private void drawCategory(Graphics2D graphics2D, String label, float x, float y, int[] summaryTab) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        float baseline = y + (float)this.lineHeight - (float)this.padding - (float)fontMetrics.getDescent();
        this.drawIcon(graphics2D, this.icons[6], (int)x, (int)y + this.padding, this.logoWidth);
        graphics2D.setColor(Color.black);
        graphics2D.drawString(label, x += (float)(this.logoWidth + this.space), baseline);
        int sumWidth = 3 * this.logoWidth + 2 * this.space;
        for (int j = 0; j < 3; ++j) {
            sumWidth += fontMetrics.stringWidth(Integer.toString(summaryTab[j]));
        }
        x = this.leftWidth + this.centerWidth / 2 - sumWidth / 2;
        if (summaryTab[2] != 0) {
            this.drawIcon(graphics2D, this.icons[2], (int)x, (int)y + this.padding, this.logoWidth);
        } else {
            this.drawIcon(graphics2D, this.icons[5], (int)x, (int)y + this.padding, this.logoWidth);
        }
        label = String.valueOf(summaryTab[2]);
        graphics2D.setColor(Color.black);
        graphics2D.drawString(label, x += (float)this.logoWidth, baseline);
        x += (float)(fontMetrics.stringWidth(label) + this.space);
        if (summaryTab[1] != 0) {
            this.drawIcon(graphics2D, this.icons[1], (int)x, (int)y + this.padding, this.logoWidth);
        } else {
            this.drawIcon(graphics2D, this.icons[4], (int)x, (int)y + this.padding, this.logoWidth);
        }
        label = String.valueOf(summaryTab[1]);
        graphics2D.setColor(Color.black);
        graphics2D.drawString(label, x += (float)this.logoWidth, baseline);
        x += (float)(fontMetrics.stringWidth(label) + this.space);
        if (summaryTab[0] != 0) {
            this.drawIcon(graphics2D, this.icons[0], (int)x, (int)y + this.padding, this.logoWidth);
        } else {
            this.drawIcon(graphics2D, this.icons[3], (int)x, (int)y + this.padding, this.logoWidth);
        }
        label = String.valueOf(summaryTab[0]);
        graphics2D.setColor(Color.black);
        graphics2D.drawString(label, x += (float)this.logoWidth, baseline);
        x += (float)(fontMetrics.stringWidth(label) + this.space);
        x = this.leftWidth + this.centerWidth + this.rightWidth / 2 - this.logoWidth / 2;
        this.drawGravite(graphics2D, summaryTab[4], (int)x, (int)y + this.padding, this.logoWidth);
    }

    private void drawGravite(Graphics2D graphics2D, int gravite, int x, int y, int logowidth) {
        switch (gravite) {
            case 2: {
                this.drawIcon(graphics2D, this.icons[2], x, y, this.logoWidth);
                break;
            }
            case 1: {
                this.drawIcon(graphics2D, this.icons[1], x, y, this.logoWidth);
                break;
            }
            case 0: {
                this.drawIcon(graphics2D, this.icons[0], x, y, this.logoWidth);
                break;
            }
            default: {
                this.drawIcon(graphics2D, this.icons[8], x, y, this.logoWidth);
            }
        }
    }

    public List<IArea> getAreas() {
        return null;
    }

    public PaintableProperties getPaintableProperties() {
        return this.paintableProperties;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    public int getCurrentPage() {
        return 0;
    }

    public int getPages() {
        return 1;
    }

    public void setCurrentPage(int currentPage) {
    }

    private String getURI(String file) {
        try {
            URL url = this.getURL(file);
            URI uri = new URI(url.toString());
            return uri.toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    private URL getURL(String file) {
        return StrategyMapChart.class.getResource(file);
    }
}

