/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.dao.ControlGroupDao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.ReportDao;
import com.prelytis.dashboard.dao.SessionDao;
import com.prelytis.dashboard.dao.value.DbControlGroupAccess;
import com.prelytis.dashboard.helper.I18nComparator;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanSession;
import com.prelytis.dashboard.value.data.BeanTaskControlResultAccess;
import com.prelytis.dashboard.value.structure.ControlGroup;
import com.prelytis.dashboard.value.structure.ControlPanelDocument;
import com.prelytis.dashboard.value.structure.ControlResult;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ControlPanelHelper {
    private final DaoFactory daoFactory;

    private ControlPanelHelper(DaoFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    public static final ControlPanelHelper getInstance(DaoFactory daoFactory) {
        return new ControlPanelHelper(daoFactory);
    }

    public ControlPanelDocument getDocument(ExpressionEvaluationData data) throws DashboardException {
        ReportDao reportDao = this.daoFactory.getReportDao();
        ControlGroupDao controlGroupDao = this.daoFactory.getControlGroupDao();
        List list = controlGroupDao.listForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue());
        I18nComparator comp = new I18nComparator(data.getLocale());
        Collections.sort(list, comp);
        ArrayList<ControlGroup> groups = new ArrayList<ControlGroup>();
        for (DbControlGroupAccess refGroup : list) {
            ControlGroup group = new ControlGroup();
            group.setObjectID(refGroup.getObjectID());
            group.setName(refGroup.getName());
            group.setDescription((String)refGroup.getDescriptionMap().get(data.getLocale()));
            List controls = group.getResults();
            Collections.sort(refGroup.getControlList(), comp);
            for (BeanTaskControlResultAccess refControl : refGroup.getControlList()) {
                ControlResult control = new ControlResult();
                control.setCalcDate(refControl.getCalcDate());
                control.setCalcThresholdName(refControl.getCalcThresholdTypeName());
                control.setCalcThresholds(refControl.getCalcThresholds());
                Bean calcReport = reportDao.getCore(refControl.getCalculationReportOID());
                control.setReportName(calcReport.getName());
                control.setReportDescription((String)calcReport.getDescriptionMap().get(data.getLocale()));
                control.setCalcValue(refControl.getCalcValue());
                control.setCustomizable(refControl.getTaskAccessLevel() == 2);
                control.setCustomized(refControl.isCustomized());
                control.setDescription((String)refControl.getDescriptionMap().get(data.getLocale()));
                control.setName(refControl.getName());
                control.setObjectID(refControl.getObjectID());
                controls.add(control);
            }
            groups.add(group);
        }
        ControlPanelDocument cpd = new ControlPanelDocument();
        SessionDao sessionDao = this.daoFactory.getSessionDao();
        BeanSession bean = sessionDao.getSession(SessionType.CONTROL_PANEL, null);
        cpd.setDescription((String)bean.getDescriptionMap().get(data.getLocale()));
        cpd.setGroups(groups);
        return cpd;
    }
}

