/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class DataFileHelper {
    private static final Logger LOG = LogManager.getLogger(DataFileHelper.class);

    private DataFileHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getData(File file) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
             FileInputStream inputStream = new FileInputStream(file);){
            byte[] buffer = new byte[1024];
            int count = 0;
            while ((count = ((InputStream)inputStream).read(buffer)) > 0) {
                outputStream.write(buffer, 0, count);
            }
        }
        return outputStream.toByteArray();
    }

    public static boolean isZipFile(File file) {
        if (!file.isFile()) {
            LOG.error((Object)("Not a file " + file.getAbsolutePath()));
            return false;
        }
        if (!file.canRead()) {
            LOG.error((Object)("Cannot read file " + file.getAbsolutePath()));
            return false;
        }
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            int firstInt = in.readInt();
            in.close();
            if (firstInt != 1347093252) {
                LOG.error((Object)("Invalid zip file " + file.getAbsolutePath()));
                return false;
            }
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)("Error reading zip file " + file.getAbsolutePath()), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)("Error reading zip file " + file.getAbsolutePath()), (Throwable)e);
        }
        return true;
    }
}

