/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.axway.sentinel.dashboard.command.CommandFilteringCheckResult;
import com.axway.sentinel.dashboard.command.CommandFilteringContext;
import com.axway.sentinel.dashboard.command.CommandFilteringEvaluator;
import com.axway.sentinel.dashboard.command.CommandFilteringFieldTypes;
import com.axway.sentinel.dashboard.command.ICommandFilteringContext;
import com.axway.sentinel.dashboard.command.TrackingCommandBean;
import com.axway.sentinel.dashboard.command.TrackingCommandListResponse;
import com.axway.sentinel.dashboard.exception.DashboardServiceException;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.helper.CommandFilter;
import com.prelytis.dashboard.helper.LogMessagesHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.model.helper.ReportHelper;
import com.prelytis.dashboard.security.DashboardManager;
import com.prelytis.dashboard.security.IDashboardManager;
import com.prelytis.dashboard.util.BeanReportHelper;
import com.prelytis.dashboard.util.TableFactory;
import com.prelytis.dashboard.value.chart.ColRow;
import com.prelytis.dashboard.value.chart.Table;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.AbstractBeanReportAvlField;
import com.prelytis.dashboard.value.data.BeanCommand;
import com.prelytis.dashboard.value.data.BeanReport;
import com.prelytis.dashboard.value.data.BeanReportAvlGroup;
import com.prelytis.dashboard.value.data.BeanReportStd;
import com.prelytis.dashboard.value.data.BeanSentinelCommands;
import com.prelytis.dashboard.value.structure.Document;
import com.prelytis.dashboard.value.structure.ReportDocument;
import com.prelytis.dashboard.value.structure.TableDocument;
import com.prelytis.dashboard.value.util.DataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.ServiceUnavailableException;
import org.apache.log4j.Logger;

public final class DocumentCommandHelper {
    private static final Logger LOG = Logger.getLogger(DocumentCommandHelper.class);
    private static IDashboardManager dashboardManager;
    static final Map<DataType, CommandFilteringFieldTypes> TYPES_MAPPING;
    public static final String TABLE_FIELD_SEPARATOR = ".";

    public static IDashboardManager getDashboardManager() throws ServiceUnavailableException {
        if (dashboardManager == null) {
            dashboardManager = DashboardManager.getInstance();
        }
        return dashboardManager;
    }

    public static void setDashboardManager(IDashboardManager dashboardManager) {
        DocumentCommandHelper.dashboardManager = dashboardManager;
    }

    private DocumentCommandHelper() {
    }

    public static List<BeanCommand> getBeanCommands(long userId, ReportDocument doc) {
        List<BeanCommand> cmds = new ArrayList<BeanCommand>();
        try {
            boolean hasRights;
            IDashboardManager manager = DocumentCommandHelper.getDashboardManager();
            if (manager != null && (hasRights = manager.userHasRightsOnSearch(userId, doc.getName()))) {
                TrackingCommandListResponse response = manager.getTrackingCommands(userId);
                TrackingCommandBean[] userCommands = response.getCommandList();
                Map allCommands = doc.getCommands();
                cmds = DocumentCommandHelper.getBeanCommands(allCommands, userCommands, doc);
            }
        }
        catch (ServiceUnavailableException e) {
            LogMessagesHelper.warn(LOG, "Could not retrieve sentinel commands. ", e);
        }
        catch (DashboardServiceException e) {
            LogMessagesHelper.warn(LOG, "Could not retrieve sentinel commands. ", e);
        }
        return cmds;
    }

    private static List<BeanCommand> getBeanCommands(Map<Long, BeanCommand> allCommands, TrackingCommandBean[] userCommands, ReportDocument doc) {
        ArrayList<BeanCommand> cmds = new ArrayList<BeanCommand>();
        if (allCommands != null && allCommands.size() > 0 && userCommands != null && userCommands.length > 0) {
            for (TrackingCommandBean trkCmd : userCommands) {
                BeanCommand beanCmd;
                if (!allCommands.containsKey(trkCmd.getId()) || !(beanCmd = allCommands.get(trkCmd.getId())).isSelected()) continue;
                beanCmd.setName(trkCmd.getName());
                beanCmd.setType(trkCmd.getType());
                beanCmd.setAvailable(true);
                beanCmd.setParams(DocumentCommandHelper.getMissingParams(doc, trkCmd.getParams()));
                beanCmd.setConfirmed(trkCmd.getConfirmed());
                cmds.add(beanCmd);
            }
        }
        return cmds;
    }

    public static List<String> getMissingParams(ReportDocument doc, List<String> commandParams) {
        List<String> result = new ArrayList<String>();
        BeanReport report = DocumentCommandHelper.retrieveReportForDocument(doc);
        if (AbstractBeanReport.class.isAssignableFrom(report.getClass())) {
            result = DocumentCommandHelper.retrieveMissingParams((AbstractBeanReport)report, commandParams);
            result.removeAll(DocumentCommandHelper.getUserInfoParameters());
        }
        return result;
    }

    public static List<String> retrieveMissingParams(AbstractBeanReport report, List<String> params) {
        ArrayList<String> result = new ArrayList<String>();
        if (params.isEmpty()) {
            return result;
        }
        result.addAll(params);
        for (BeanReportAvlGroup reportAvlGroup : report.getAvlGroupList()) {
            block1: for (AbstractBeanReportAvlField beanReportAvlField : reportAvlGroup.getFields()) {
                String fieldName = beanReportAvlField.getName();
                String simpleFieldName = DocumentCommandHelper.getSimpleFieldName(fieldName);
                for (String param : params) {
                    boolean hasPrefix;
                    String paramName = param;
                    int delimiterIndex = paramName.indexOf(":");
                    boolean bl = hasPrefix = delimiterIndex > 0;
                    if (hasPrefix) {
                        paramName = paramName.substring(0, delimiterIndex) + TABLE_FIELD_SEPARATOR + paramName.substring(delimiterIndex + 1);
                    }
                    if ((!hasPrefix || !paramName.equalsIgnoreCase(fieldName)) && !paramName.equalsIgnoreCase(simpleFieldName)) continue;
                    result.remove(param);
                    if (!result.isEmpty()) continue block1;
                    return result;
                }
            }
        }
        return result;
    }

    public static void updateFilteredCommands(ReportDocument doc, Collection<BeanCommand> cmds) {
        if (cmds == null || cmds.size() == 0) {
            return;
        }
        for (Document document : doc) {
            if (!(document instanceof TableDocument)) continue;
            DocumentCommandHelper.updateFilteredCommandsForTable((TableDocument)document, doc.getRowsPerPage(), cmds);
        }
    }

    public static void updateFilteredCommandsForTable(TableDocument doc, int nbRowsPerPage, Collection<BeanCommand> cmds) {
        Table table = doc.getTable();
        if (table.getReportType() == 1 || TableFactory.getColRowInv((Table)table)) {
            return;
        }
        int currentPage = doc.getCurrentPage() == null ? 0 : doc.getCurrentPage();
        int deb = Math.max(currentPage * nbRowsPerPage + 1, 1);
        int nbRows = TableFactory.getFinalNbRows((Table)table);
        int fin = Math.min(deb + nbRowsPerPage, nbRows);
        for (int i = deb; i < fin; ++i) {
            ColRow row = TableFactory.getFinalRow((Table)table, (int)i);
            Set<Long> filteredCommands = DocumentCommandHelper.getFilteredCommands(cmds, row.getCriteriaFieldValues());
            row.setFilteredCmdIds(filteredCommands);
        }
    }

    public static Set<Long> getFilteredCommands(Collection<BeanCommand> cmds, Map<String, Object> values) {
        HashSet<Long> res = new HashSet<Long>();
        for (BeanCommand cmd : cmds) {
            boolean available = true;
            String criteria = cmd.getCriteria();
            if (criteria != null && !"".equals(criteria.trim())) {
                try {
                    CommandFilteringContext context = new CommandFilteringContext(values);
                    available = CommandFilteringEvaluator.evaluate((String)criteria, (ICommandFilteringContext)context);
                }
                catch (IllegalArgumentException e) {
                    LogMessagesHelper.warn(LOG, "Criteria could not be evaluated. ", e);
                    available = false;
                }
            }
            if (!available) continue;
            res.add(cmd.getId());
        }
        return res;
    }

    public static BeanReport retrieveReportForDocument(ReportDocument doc) {
        ReportHelper helper = ReportHelper.getInstance(DaoFactory.getInstance());
        AbstractBeanReport report = null;
        try {
            report = helper.getDefinition(doc.getName());
        }
        catch (DashboardException e) {
            LogMessagesHelper.warn(LOG, "Could not retrieve report. ", e);
            return null;
        }
        return report;
    }

    public static Map<String, CommandFilteringFieldTypes> getAvailableFields(BeanReportStd report) {
        AbstractBeanReportAvlField[] fields;
        LinkedHashMap<String, CommandFilteringFieldTypes> res = new LinkedHashMap<String, CommandFilteringFieldTypes>();
        for (AbstractBeanReportAvlField field : fields = BeanReportHelper.getInstance().getAvailableFields(report)) {
            res.put(DocumentCommandHelper.getSimpleFieldName(field.getName()), DocumentCommandHelper.getFieldType(field.getDataType()));
        }
        return res;
    }

    public static String getSimpleFieldName(String fullFieldName) {
        return fullFieldName.substring(fullFieldName.lastIndexOf(TABLE_FIELD_SEPARATOR) + 1);
    }

    public static List<BeanCommand> getCmdsByFilter(BeanReportStd report, CommandFilter commandFilter) {
        ArrayList<BeanCommand> commands = new ArrayList<BeanCommand>();
        BeanSentinelCommands beanCmds = report.getSentinelCommands();
        if (beanCmds == null || beanCmds.getAllCommands() == null || beanCmds.getAllCommands().isEmpty()) {
            return commands;
        }
        return DocumentCommandHelper.getCmdsByFilter(beanCmds.getAllCommands().values(), commandFilter);
    }

    public static List<BeanCommand> getCmdsByFilter(Collection<BeanCommand> commands, CommandFilter commandFilter) {
        ArrayList<BeanCommand> filteredCommands = new ArrayList<BeanCommand>();
        if (commandFilter == null) {
            filteredCommands.addAll(commands);
        } else {
            for (BeanCommand command : commands) {
                if (!commandFilter.isApplicable(command)) continue;
                filteredCommands.add(command);
            }
        }
        return filteredCommands;
    }

    public static CommandFilteringFieldTypes getFieldType(DataType type) {
        CommandFilteringFieldTypes newType = TYPES_MAPPING.get(type);
        if (newType == null) {
            newType = CommandFilteringFieldTypes.STRING;
        }
        return newType;
    }

    public static Collection<String> getCriteriaFields(BeanReportStd stdReport) {
        HashSet<String> fields = new HashSet<String>();
        ArrayList<CommandFilteringCheckResult> checkResults = DocumentCommandHelper.checkCommandCriteria(stdReport, null);
        for (CommandFilteringCheckResult checkResult : checkResults) {
            fields.addAll(Arrays.asList(checkResult.getIdentifiers()));
        }
        return fields;
    }

    public static ArrayList<CommandFilteringCheckResult> checkCommandCriteria(BeanReportStd stdReport, CommandFilter commandFilter) {
        ArrayList<CommandFilteringCheckResult> checkResults = new ArrayList<CommandFilteringCheckResult>();
        List<BeanCommand> commands = DocumentCommandHelper.getCmdsByFilter(stdReport, commandFilter);
        Map<String, CommandFilteringFieldTypes> fields = DocumentCommandHelper.getAvailableFields(stdReport);
        HashMap<String, CommandFilteringFieldTypes> fieldTypes = new HashMap<String, CommandFilteringFieldTypes>();
        fieldTypes.putAll(fields);
        CommandFilteringContext context = new CommandFilteringContext(fieldTypes);
        for (BeanCommand command : commands) {
            String criteria = command.getCriteria();
            if (criteria == null || "".equals(criteria.trim())) continue;
            CommandFilteringCheckResult result = CommandFilteringEvaluator.check((String)criteria, (ICommandFilteringContext)context);
            result.setCommandName(command.getName());
            checkResults.add(result);
        }
        return checkResults;
    }

    public static boolean reportHasSelectedCommands(BeanReportStd stdReport) {
        List<BeanCommand> commands = DocumentCommandHelper.getCmdsByFilter(stdReport, new CommandFilter(){

            @Override
            public boolean isApplicable(BeanCommand command) {
                return command.isSelected();
            }
        });
        return !commands.isEmpty();
    }

    private static List<String> getUserInfoParameters() {
        ArrayList<String> userInfoParam = new ArrayList<String>();
        userInfoParam.add("LOGIN");
        userInfoParam.add("@USER");
        userInfoParam.add("@PASSWD");
        userInfoParam.add("@CRYPT-PASSWD");
        userInfoParam.add("@DOMAIN");
        return userInfoParam;
    }

    static {
        TYPES_MAPPING = new EnumMap<DataType, CommandFilteringFieldTypes>(DataType.class);
        TYPES_MAPPING.put(DataType.NUMERIC, CommandFilteringFieldTypes.NUMERIC);
        TYPES_MAPPING.put(DataType.DECIMAL, CommandFilteringFieldTypes.NUMERIC);
        TYPES_MAPPING.put(DataType.BIT, CommandFilteringFieldTypes.NUMERIC);
        TYPES_MAPPING.put(DataType.TINYINT, CommandFilteringFieldTypes.NUMERIC);
        TYPES_MAPPING.put(DataType.SMALLINT, CommandFilteringFieldTypes.NUMERIC);
        TYPES_MAPPING.put(DataType.INTEGER, CommandFilteringFieldTypes.NUMERIC);
        TYPES_MAPPING.put(DataType.BIGINT, CommandFilteringFieldTypes.NUMERIC);
        TYPES_MAPPING.put(DataType.REAL, CommandFilteringFieldTypes.NUMERIC);
        TYPES_MAPPING.put(DataType.FLOAT, CommandFilteringFieldTypes.NUMERIC);
        TYPES_MAPPING.put(DataType.DOUBLE, CommandFilteringFieldTypes.NUMERIC);
        TYPES_MAPPING.put(DataType.GENERIC_NUMERIC, CommandFilteringFieldTypes.NUMERIC);
        TYPES_MAPPING.put(DataType.DATE, CommandFilteringFieldTypes.DATE);
        TYPES_MAPPING.put(DataType.GENERIC_DATE, CommandFilteringFieldTypes.DATE);
        TYPES_MAPPING.put(DataType.TIME, CommandFilteringFieldTypes.TIME);
        TYPES_MAPPING.put(DataType.TIMESTAMP, CommandFilteringFieldTypes.DATE_TIME);
        TYPES_MAPPING.put(DataType.BOOLEAN, CommandFilteringFieldTypes.BOOLEAN);
    }
}

